<?php if ( get_header_image() ) : ?>
    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
        <img src="<?php esc_url(header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
    </a>    
<?php endif;  ?>
<header id="main-header" class="main-header wow fadeInDown">
    <div class="navigation-wrapper">
        <div class="main-navigation-area d-none d-lg-block">
            <div class="main-navigation <?php echo esc_attr(cozipress_sticky_menu()); ?>">
                <div class="container">
                    <div class="header_border">
                        <div class="row align-items-center">
                            <div class="col-2 my-auto">
                                <div class="logo">
                                    <?php 
                                    if(has_custom_logo())
                                    {   
                                        the_custom_logo();
                                    }
                                    else { 
                                        ?>
                                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                            <h4 class="site-title">
                                                <?php 
                                                echo esc_html(bloginfo('name'));
                                                ?>
                                            </h4>
                                        </a>    
                                        <?php                       
                                    }
                                    ?>
                                    <?php
                                    $cozigo_site_desc = get_bloginfo( 'description');
                                    if ($cozigo_site_desc) : ?>
                                        <p class="site-description"><?php echo esc_html($cozigo_site_desc); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-7 my-auto">
                                <nav class="navbar-area">
                                    <div class="main-navbar">
                                      <?php 
                                      wp_nav_menu( 
                                        array(  
                                            'theme_location' => 'primary_menu',
                                            'container'  => '',
                                            'menu_class' => 'main-menu',
                                            'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
                                            'walker' => new WP_Bootstrap_Navwalker()
                                        ) 
                                    );
                                    ?>         
                                </div>
                                <div class="main-menu-right">
                                    <ul class="menu-right-list">
                                        <?php 
                                        $cozigo_hs_nav_search       = get_theme_mod( 'hs_nav_search','1'); 
                                        if($cozigo_hs_nav_search == '1') { ?>
                                            <li class="search-button">
                                                <button type="button" id="header-search-toggle" class="header-search-toggle" aria-expanded="false" aria-label="<?php esc_attr_e( 'Search Popup', 'cozigo' ); ?>"><i class="fa fa-search"></i></button>
                                                <div class="header-search-popup">
                                                    <div class="header-search-flex">
                                                        <form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" aria-label="Site Search">
                                                            <input type="search" class="form-control header-search-field" placeholder="<?php esc_attr_e( 'Type To Search', 'cozigo' ); ?>" name="s" id="search">
                                                            <button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
                                                        </form>
                                                        <button type="button" id="header-search-close" class="close-style header-search-close" aria-label="<?php esc_attr_e( 'Search Popup Close', 'cozigo' ); ?>"></button>
                                                    </div>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>                            
                                </div>
                            </nav>
                        </div>
                        <div class="col-3">
                            <div class="widget-right d-flex justify-content-lg-end justify-content-center text-lg-right text-center">
                                <aside class="widget widget_social_widget">
                                    <?php 
                                    do_action( 'cozipress_header_social_icon'); 
                                    ?>  
                                </aside>
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
        </div>
    </div>
    <div class="main-mobile-nav <?php echo esc_attr(cozipress_sticky_menu()); ?>"> 
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="main-mobile-menu">
                        <div class="mobile-logo">
                            <div class="logo">
                                <?php 
                                if(has_custom_logo())
                                {   
                                    the_custom_logo();
                                }
                                else { 
                                    ?>
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                        <h4 class="site-title">
                                            <?php 
                                            echo esc_html(bloginfo('name'));
                                            ?>
                                        </h4>
                                    </a>    
                                    <?php                       
                                }
                                ?>
                                <?php
                                $cozigo_site_desc = get_bloginfo( 'description');
                                if ($cozigo_site_desc) : ?>
                                    <p class="site-description"><?php echo esc_html($cozigo_site_desc); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="menu-collapse-wrap">
                            <div class="hamburger-menu">
                                <button type="button" class="menu-collapsed" aria-label="<?php esc_attr_e( 'Menu Collaped', 'cozigo' ); ?>">
                                    <div class="top-bun"></div>
                                    <div class="meat"></div>
                                    <div class="bottom-bun"></div>
                                </button>
                            </div>
                        </div>
                        <div class="main-mobile-wrapper">
                            <div id="mobile-menu-build" class="main-mobile-build">
                                <button type="button" class="header-close-menu close-style" aria-label="<?php esc_attr_e( 'Header Close Menu', 'cozigo' ); ?>"></button>
                            </div>
                        </div>
                        <?php if ( function_exists( 'burger_companion_activated' ) ) { ?>
                            <div class="header-above-btn">
                                <button type="button" class="header-above-collapse" aria-label="<?php esc_attr_e( 'Header Above Collapse', 'cozigo' ); ?>"><span></span></button>
                            </div>
                            <div class="header-above-wrapper">
                                <div id="header-above-bar" class="header-above-bar"></div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>        
    </div>
</div>
<div id="above-header" class="above-header d-lg-block d-none">
    <div class="header-widget d-flex align-items-center">
        <div class="container">
            <div class="above_border">
                <div class="row">
                    <div class="col-lg-6 col-12 mb-lg-0 mb-4">
                        <div class="widget-left text-lg-left text-center">
                            <?php 
                            do_action( 'cozipress_header_opening_hour'); 
                            do_action( 'cozipress_header_support');
                            ?>  
                        </div>
                    </div>
                    <div class="col-lg-6 col-12 mb-lg-0 mb-4">                            
                        <div class="widget-right justify-content-lg-end justify-content-center text-lg-right text-center">
                            <?php
                            do_action( 'cozipress_header_careers');
                            do_action( 'cozipress_header_email'); 
                            ?>
                            <aside class="widget textwidget">   
                                <?php do_action( 'cozipress_header_booknow_button');  ?>
                            </aside>
                        </div>
                    </div>
                </div>
            </div>    
        </div>
    </div>
</div> 
</header>
