<?php
function cozigo_css() {
	$parent_style = 'cozipress-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'cozigo-style', get_stylesheet_uri(), array( $parent_style ));
	wp_enqueue_style('cozigo-responsive',get_stylesheet_directory_uri().'/assets/css/responsive.css');
	wp_dequeue_style('cozipress-responsive');
}

add_action( 'wp_enqueue_scripts', 'cozigo_css',999);

function cozigo_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'cozipress_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'ffffff',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'cozipress_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'cozigo_custom_header_setup');

/**
 * Import Options From Parent Theme
 *
 */
function cozigo_parent_theme_options() {
	$cozipress_mods = get_option( 'theme_mods_cozipress' );
	if ( ! empty( $cozipress_mods ) ) {
		foreach ( $cozipress_mods as $cozipress_mod_k => $cozipress_mod_v ) {
			set_theme_mod( $cozipress_mod_k, $cozipress_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'cozigo_parent_theme_options' );

require( get_stylesheet_directory() . '/inc/customizer/customizer-pro/class-customize.php');

add_action( 'wp_enqueue_scripts', 'cozigo_condition_scripts' );
function cozigo_condition_scripts(){
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
	if (!is_plugin_active('burger-companion/burger-companion.php')) { 

		wp_enqueue_style('cozigo-condition', get_stylesheet_directory_uri() . '/assets/css/condition.css');

	}
}
