<?php

/**
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * It is also available at this URL: http://www.gnu.org/licenses/gpl-3.0.txt
 */

if (!function_exists('corriere_before_content_function')) {

	function corriere_before_content_function( $type = "post" ) {
		
		if ( ! avventura_lite_is_single() ) {

			do_action('avventura_lite_get_title', 'blog' ); 

		} else {

			if ( !avventura_lite_is_woocommerce_active('is_cart') ) :
	
				if ( avventura_lite_is_single() && !is_page_template() ) :
							 
					do_action('avventura_lite_get_title', 'single');
							
				else :
					
					do_action('avventura_lite_get_title', 'blog'); 
							 
				endif;
	
			endif;

		}

		if ( $type == "post" ) :
		
			echo '<span class="entry-date"><strong>' . get_the_author_posts_link() . '</strong> - ' . esc_html(get_the_date()) . '</span>';

		endif;

	} 
	
	add_action( 'avventura_lite_before_content', 'corriere_before_content_function' );

}

?>