<?php
/**
* Wizard
* @package Whizzie
* @since 1.0.0
*/

class Whizzie {
	protected $version = '1.1.0';
	protected $theme_name = '';
	protected $theme_title = '';
	protected $page_slug = '';
	protected $page_title = '';
	protected $config_steps = array();
	public $parent_slug;
	/**
	 * Constructor
	 * @param $config Configuration parameters
	 */
	public function __construct( $config ) {
		$this->set_vars( $config );
		$this->init();
	}

	/**
	 * Set variables based on configuration
	 * @param $config Configuration parameters
	 */
	public function set_vars( $config ) {
		if ( isset( $config['page_slug'] ) ) {
			$this->page_slug = esc_attr( $config['page_slug'] );
		}
		if ( isset( $config['page_title'] ) ) {
			$this->page_title = esc_attr( $config['page_title'] );
		}
		if ( isset( $config['steps'] ) ) {
			$this->config_steps = $config['steps'];
		}

		$current_theme = wp_get_theme();
		$this->theme_title = $current_theme->get( 'Name' );
		$this->theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $current_theme->get( 'Name' ) ) );
		$this->page_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_page_slug', $this->theme_name . '-wizard' );
		$this->parent_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_parent_slug', '' );
	}

	/*** Initialize hooks and actions ***/
	public function init() {
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'wp_ajax_setup_widgets', array( $this, 'setup_widgets' ) );
	}

	public function enqueue_scripts() {
		wp_enqueue_style( 'theme-wizard-style', get_template_directory_uri() . '/theme-wizard/assets/css/theme-wizard-style.css');
		wp_register_script( 'theme-wizard-script', get_template_directory_uri() . '/theme-wizard/assets/js/theme-wizard-script.js', array( 'jquery' ));
		wp_localize_script(
			'theme-wizard-script',
			'corporate_solutions_whizzie_params',
			array(
				'ajaxurl' => admin_url( 'admin-ajax.php' ),
				'verify_text' => esc_html( 'verifying', 'corporate-solutions' )
			)
		);
		wp_enqueue_script( 'theme-wizard-script' );
	}

	public function menu_page() {
		add_theme_page( esc_html( $this->page_title ), esc_html( $this->page_title ), 'manage_options', $this->page_slug, array( $this, 'corporate_solutions_setup_wizard' ) );
	}

	/*** Display the wizard page content ***/
	public function wizard_page() { ?>
		<div class="main-wrap">
			<div class="card whizzie-wrap">
				<ul class="whizzie-menu">
					<?php foreach ( $this->get_steps() as $step ) : ?>
						<li data-step="<?php echo esc_attr( $step['id'] ); ?>" class="step step-<?php echo esc_attr( $step['id'] ); ?>">

							<h2><?php echo esc_html( $step['title'] ); ?></h2>

							<?php
							$content = call_user_func( array( $this, $step['view'] ) );
							?>

							<?php if ( isset( $content['summary'] ) ) : ?>
								<div class="summary">
									<?php echo wp_kses_post( $content['summary'] ); ?>
								</div>
							<?php endif; ?>

							<?php if ( isset( $content['detail'] ) ) : ?>
								<p>
									<a href="#" class="more-info">
										<?php esc_html_e( 'More Info', 'corporate-solutions' ); ?>
									</a>
								</p>
								<div class="detail">
									<?php echo wp_kses_post( $content['detail'] ); ?>
								</div>
							<?php endif; ?>

							<?php if ( ! empty( $step['button_text'] ) ) : ?>
								<div class="button-wrap">

									<?php if ( ! get_option( 'is-demo-imported' ) ) : ?>

										<a href="#"
										class="button button-primary do-it"
										data-callback="<?php echo esc_attr( $step['callback'] ); ?>"
										data-step="<?php echo esc_attr( $step['id'] ); ?>">
											<?php echo esc_html( $step['button_text'] ); ?>
										</a>

									<?php else : ?>

										<a target="_blank"
										href="<?php echo esc_url( home_url() ); ?>"
										class="button button-primary"
										style="font-size:20px;font-weight:600;">
											<?php esc_html_e( 'Visit Site', 'corporate-solutions' ); ?>
										</a>

									<?php endif; ?>

								</div>
							<?php endif; ?>

						</li>
					<?php endforeach; ?>
				</ul>
				<div class="step-loading">
					<span class="spinner"></span>
				</div>
			</div>
		</div>
	<?php }

	/*** Setup wizard page content and options ***/
	public function corporate_solutions_setup_wizard() { ?>
		<div class="wrapper-info get-stared-page-wrap">
			<div class="tab-sec theme-option-tab">
				<div id="demo_offer" class="tabcontent">
					<?php $this->wizard_page(); ?>
				</div>
			</div>
		</div>
	<?php }

	/**
	 * Get the steps for the wizard
	 * @return array
	 */
	public function get_steps() {
		$steps = array(
			'intro' => array(
				'id' => 'intro',
				'title' => __( 'Welcome to ', 'corporate-solutions' ) . $this->theme_title,
				'view' => 'get_step_intro',
				'callback' => 'do_next_step',
				'button_text' => __( 'Start Now', 'corporate-solutions' ),
				'can_skip' => false
			),
			'widgets' => array(
				'id' => 'widgets',
				'title' => __( 'Demo Importer', 'corporate-solutions' ),
				'view' => 'get_step_widgets',
				'callback' => 'install_widgets',
				'button_text' => __( 'Import Demo', 'corporate-solutions' ),
				'can_skip' => true
			),
			'done' => array(
				'id' => 'done',
				'title' => __( 'All Done', 'corporate-solutions' ),
				'view' => 'get_step_done'
			)
		);

		return $steps;
	}

	/*** Display the content for the intro step ***/
	public function get_step_intro() { ?>
		<div class="summary">
			<p style="text-align: center;"><?php esc_html_e( 'Thank you for choosing our theme! We are excited to help you get started with your new website.', 'corporate-solutions' ); ?></p>
			<p style="text-align: center;"><?php esc_html_e( 'This section will guide you through setting up and customizing the theme. You can follow the steps to import demo content or adjust settings at any time to make the website look and work the way you want.', 'corporate-solutions' ); ?></p>
		</div>
	<?php }

	/*** Display the content for the widgets step ***/
	public function get_step_widgets() { ?>
		<div class="summary">
			<p><?php esc_html_e('To get started, use the button below to import demo content and add widgets to your site. After installation, you can manage settings and customize your site using the Customizer. Enjoy your new theme!', 'corporate-solutions'); ?></p>
		</div>
	<?php }

	/*** Display the content for the final step ***/
	public function get_step_done() { ?>
		<div id="aster-demo-setup-guid">
			<div class="aster-setup-menu">
				<h3><?php esc_html_e('Setup Navigation Menu','corporate-solutions'); ?></h3>
				<p><?php esc_html_e('Follow the following Steps to Setup Menu','corporate-solutions'); ?></p>
				<h4><?php esc_html_e('A) Create Pages','corporate-solutions'); ?></h4>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Pages >> Add New','corporate-solutions'); ?></li>
					<li><?php esc_html_e('Enter Page Details And Save Changes','corporate-solutions'); ?></li>
				</ol>
				<h4><?php esc_html_e('B) Add Pages To Menu','corporate-solutions'); ?></h4>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Appearance >> Menu','corporate-solutions'); ?></li>
					<li><?php esc_html_e('Click On The Create Menu Option','corporate-solutions'); ?></li>
					<li><?php esc_html_e('Select The Pages And Click On The Add to Menu Button','corporate-solutions'); ?></li>
					<li><?php esc_html_e('Select Primary Menu From The Menu Setting','corporate-solutions'); ?></li>
					<li><?php esc_html_e('Click On The Save Menu Button','corporate-solutions'); ?></li>
				</ol>
			</div>
			<div class="aster-setup-widget">
				<h3><?php esc_html_e('Setup Footer Widgets','corporate-solutions'); ?></h3>
				<p><?php esc_html_e('Follow the following Steps to Setup Footer Widgets','corporate-solutions'); ?></p>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Appearance >> Widgets','corporate-solutions'); ?></li>
					<li><?php esc_html_e('Drag And Add The Widgets In The Footer Columns','corporate-solutions'); ?></li>
				</ol>
			</div>
			<div style="display:flex; flex-wrap: wrap; justify-content: center; margin-top: 20px; gap:20px">
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url(home_url()); ?>" class="button button-primary">Visit Site</a>
				</div>
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>" class="button button-primary">Customize Your Demo</a>
				</div>
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url( admin_url('themes.php?page=corporate-solutions-getting-started') ); ?>" class="button button-primary">Dashboard</a>
				</div>
			</div>
		</div>
	<?php }


	//                      ------------- MENUS -----------------                    //

	public function corporate_solutions_customizer_primary_menu(){
		// ------- Create Primary Menu --------
		$corporate_solutions_themename = 'Corporate Solutions'; // Ensure the theme name is set
		$corporate_solutions_menuname = $corporate_solutions_themename . ' Primary Menu';
		$corporate_solutions_bpmenulocation = 'primary';
		$corporate_solutions_menu_exists = wp_get_nav_menu_object($corporate_solutions_menuname);
	
		if( !$corporate_solutions_menu_exists ) {
			$corporate_solutions_menu_id = wp_create_nav_menu($corporate_solutions_menuname);
			
			// Home
			wp_update_nav_menu_item($corporate_solutions_menu_id, 0, array(
				'menu-item-title' => __('Home', 'corporate-solutions'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url('/'),
				'menu-item-status' => 'publish'
			));
	
			// Pages
			$page_pages = get_page_by_path('pages'); // Preferred over get_page_by_title()
			if($page_pages){
				wp_update_nav_menu_item($corporate_solutions_menu_id, 0, array(
					'menu-item-title' => __('Pages', 'corporate-solutions'),
					'menu-item-classes' => 'pages',
					'menu-item-url' => get_permalink($page_pages),
					'menu-item-status' => 'publish'
				));
			}
	
			// Portfolio
			$page_portfolio = get_page_by_path('portfolio');
			if($page_portfolio){
				wp_update_nav_menu_item($corporate_solutions_menu_id, 0, array(
					'menu-item-title' => __('Portfolio', 'corporate-solutions'),
					'menu-item-classes' => 'portfolio',
					'menu-item-url' => get_permalink($page_portfolio),
					'menu-item-status' => 'publish'
				));
			}
	
			// Blog
			$page_blog = get_page_by_path('blog');
			if($page_blog){
				wp_update_nav_menu_item($corporate_solutions_menu_id, 0, array(
					'menu-item-title' => __('Blog', 'corporate-solutions'),
					'menu-item-classes' => 'blog',
					'menu-item-url' => get_permalink($page_blog),
					'menu-item-status' => 'publish'
				));
			}
	
			// Contact Us
			$page_contact = get_page_by_path('contact-us');
			if($page_contact){
				wp_update_nav_menu_item($corporate_solutions_menu_id, 0, array(
					'menu-item-title' => __('Contact Us', 'corporate-solutions'),
					'menu-item-classes' => 'contact',
					'menu-item-url' => get_permalink($page_contact),
					'menu-item-status' => 'publish'
				));
			}
	
			// Assign menu to location if not set
			if( !has_nav_menu($corporate_solutions_bpmenulocation) ){
				$locations = get_theme_mod('nav_menu_locations');
				$locations[$corporate_solutions_bpmenulocation] = $corporate_solutions_menu_id;
				set_theme_mod('nav_menu_locations', $locations);
			}
		}
	}
	

	//                      ------------- /*** Imports demo content ***/ -----------------                    //

	public function setup_widgets() {

		// Create a front page and assign the template
		$corporate_solutions_home_title = 'Home';
		$corporate_solutions_home_check = get_page_by_path('home');
		if (!$corporate_solutions_home_check) {
			$corporate_solutions_home = array(
				'post_type'    => 'page',
				'post_title'   => $corporate_solutions_home_title,
				'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'home' // Unique slug for the home page
			);
			$corporate_solutions_home_id = wp_insert_post($corporate_solutions_home);

			// Set the static front page
			if (!is_wp_error($corporate_solutions_home_id)) {
				update_option('page_on_front', $corporate_solutions_home_id);
				update_option('show_on_front', 'page');
			}
		}

		// Create a posts page and assign the template
		$corporate_solutions_blog_title = 'Blog';
		$corporate_solutions_blog_check = get_page_by_path('blog');
		if (!$corporate_solutions_blog_check) {
			$corporate_solutions_blog = array(
				'post_type'    => 'page',
				'post_title'   => $corporate_solutions_blog_title,
				'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'blog' // Unique slug for the blog page
			);
			$corporate_solutions_blog_id = wp_insert_post($corporate_solutions_blog);

			// Set the posts page
			if (!is_wp_error($corporate_solutions_blog_id)) {
				update_option('page_for_posts', $corporate_solutions_blog_id);
			}
		}

		// Create a Pages page and assign the template
		$corporate_solutions_pages_title = 'Pages';
		$corporate_solutions_pages_check = get_page_by_path('pages');
		if (!$corporate_solutions_pages_check) {
			$corporate_solutions_pages = array(
				'post_type'    => 'page',
				'post_title'   => $corporate_solutions_pages_title,
				'post_content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>',
				'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'pages' // Unique slug for the Pages page
			);
			wp_insert_post($corporate_solutions_pages);
		}

		// Create a Portfolio page and assign the template
		$corporate_solutions_portfolio_title = 'Portfolio';
		$corporate_solutions_portfolio_check = get_page_by_path('portfolio');
		if (!$corporate_solutions_portfolio_check) {
			$corporate_solutions_portfolio = array(
				'post_type'    => 'page',
				'post_title'   => $corporate_solutions_portfolio_title,
				'post_content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>',
				'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'portfolio' // Unique slug for the Portfolio page
			);
			wp_insert_post($corporate_solutions_portfolio);
		}

		// Create a Contact Us page and assign the template
		$corporate_solutions_contact_title = 'Contact Us';
		$corporate_solutions_contact_check = get_page_by_path('contact-us');
		if (!$corporate_solutions_contact_check) {
			$corporate_solutions_contact = array(
				'post_type'    => 'page',
				'post_title'   => $corporate_solutions_contact_title,
				'post_content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>',
				'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'contact-us' // Unique slug for the Contact Us page
			);
			wp_insert_post($corporate_solutions_contact);
		}


		/*----------------------------------------- Header Button --------------------------------------------------*/

			set_theme_mod( 'corporate_solutions_callus_header_number','+12987654321');
			set_theme_mod( 'corporate_solutions_callus_header_text','Call Us');


		// ------------------------------------------ Blogs for Sections --------------------------------------

			// ------------------------------------------ Blogs for Sections --------------------------------------

				// Create categories if not already created
				$corporate_solutions_category_banner = wp_create_category('Banner');
				$corporate_solutions_category_services = wp_create_category('Services');

				// Array of categories to assign to each set of posts
				$corporate_solutions_categories = array($corporate_solutions_category_banner, $corporate_solutions_category_services);

				// Array of image URLs for the "Services" category
				$services_images = array(
					get_template_directory_uri() . '/resource/img/service1.png',
					get_template_directory_uri() . '/resource/img/service2.png',
					get_template_directory_uri() . '/resource/img/service3.png',
					get_template_directory_uri() . '/resource/img/service4.png'
				);

				// Loop to create posts
				for ($i = 1; $i <= 7; $i++) { // Adjusted to 7 posts in total
					$title = array(
						'Precision in Every Process, Excellence in Every Solution.',
						'Empowering Businesses with Innovation, Delivering Success with Precision.',
						'Strategic Solutions for a Dynamic World, Excellence in Every Endeavor.',
						'Corporate Team',
						'Corporate Team',
						'Corporate Team',
						'Corporate Team'
					);

					$content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.';

					// Determine category and post index to use for title
					$category_index = ($i <= 3) ? 0 : 1; // First 3 for Banner, next 4 for Services
					$post_title = $title[$i - 1]; // Adjust for zero-based index in title array

					// Create post object
					$my_post = array(
						'post_title'    => wp_strip_all_tags($post_title),
						'post_content'  => $content,
						'post_status'   => 'publish',
						'post_type'     => 'post',
						'post_category' => array($corporate_solutions_categories[$category_index]), // Assign Banner to first 3, Services to next 4
					);

					// Insert the post into the database
					$post_id = wp_insert_post($my_post);

					// Determine the category and set image URLs based on category
					if ($category_index === 0) { // Banner category
						$slider_index = $i % 3 + 1; // Cycles through 1, 2, 3
						$corporate_solutions_image_url = get_template_directory_uri() . "/resource/img/slider{$slider_index}.png";
						$corporate_solutions_image_name = "slider{$slider_index}.png";
					} else { // Services category
						// Use different images for each post in Services category
						$service_image_index = $i - 4; // Get the correct index for the Services images array (4, 5, 6, 7 corresponds to 0, 1, 2, 3)
						$corporate_solutions_image_url = $services_images[$service_image_index];
						$corporate_solutions_image_name = basename($corporate_solutions_image_url);
					}

					$corporate_solutions_upload_dir = wp_upload_dir();
					$corporate_solutions_image_data = file_get_contents($corporate_solutions_image_url);
					$corporate_solutions_unique_file_name = wp_unique_filename($corporate_solutions_upload_dir['path'], $corporate_solutions_image_name);
					$filename = basename($corporate_solutions_unique_file_name);

					if (wp_mkdir_p($corporate_solutions_upload_dir['path'])) {
						$file = $corporate_solutions_upload_dir['path'] . '/' . $filename;
					} else {
						$file = $corporate_solutions_upload_dir['basedir'] . '/' . $filename;
					}

					if ( ! function_exists( 'WP_Filesystem' ) ) {
						require_once( ABSPATH . 'wp-admin/includes/file.php' );
					}
					
					WP_Filesystem();
					global $wp_filesystem;
					
					if ( ! $wp_filesystem->put_contents( $file, $corporate_solutions_image_data, FS_CHMOD_FILE ) ) {
						wp_die( 'Error saving file!' );
					}

					$wp_filetype = wp_check_filetype($filename, null);
					$attachment = array(
						'post_mime_type' => $wp_filetype['type'],
						'post_title'     => sanitize_file_name($filename),
						'post_content'   => '',
						'post_status'    => 'inherit'
					);

					$corporate_solutions_attach_id = wp_insert_attachment($attachment, $file, $post_id);

					require_once(ABSPATH . 'wp-admin/includes/image.php');

					$corporate_solutions_attach_data = wp_generate_attachment_metadata($corporate_solutions_attach_id, $file);
					wp_update_attachment_metadata($corporate_solutions_attach_id, $corporate_solutions_attach_data);
					set_post_thumbnail($post_id, $corporate_solutions_attach_id);
				}



		// ---------------------------------------- Slider --------------------------------------------------- //

			set_theme_mod('corporate_solutions_enable_banner_section',true);
			for($i=1; $i<=3; $i++) {
				set_theme_mod('corporate_solutions_banner_button_label_'.$i,'Contact Us');
				set_theme_mod('corporate_solutions_banner_button_link_'.$i,'');
			}
			

		// ---------------------------------------- Services --------------------------------------------------- //
		
			set_theme_mod('corporate_solutions_enable_service_section',true);
			set_theme_mod('corporate_solutions_services_section_heading','We Help To Achieve Your Corporate Goal');
			set_theme_mod('corporate_solutions_services_section_text','We love what we do and we do it with passion. We value the experimentation of the message and smart incentives.');
			set_theme_mod('corporate_solutions_services_section_button_text','View All Team');
			set_theme_mod('corporate_solutions_services_section_button_link','#');
			set_theme_mod('corporate_solutions_services_section_image',get_template_directory_uri().'/resource/img/service.png');


		// ---------------------------------------- Footer section --------------------------------------------------- //	
		
			set_theme_mod('corporate_solutions_footer_background_color_setting','#202020');
			
		// ---------------------------------------- Related post_tag --------------------------------------------------- //	
		
			set_theme_mod('corporate_solutions_post_related_post_label','Related Posts');
			set_theme_mod('corporate_solutions_related_posts_count','3');


		$this->corporate_solutions_customizer_primary_menu();
		update_option('is-demo-imported', true);
	}
}