<?php
/**
 * Right Buttons Panel.
 *
 * @package corporate_solutions
 */
?>
<div class="panel-right">
	<div class="pro-btn theme-btn">
		<div class="screenshot">
			<img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/pro-screenshot.png'; ?>" />
		</div>
		<br>
		<div class="theme-info">
			<h3><?php esc_html_e( 'Corporate WordPress Theme', 'corporate-solutions' ); ?></h3>
			<div class="theme-price">
				<span class="price-text"><?php esc_html_e( 'Price:', 'corporate-solutions' ); ?></h6>
				<del><?php esc_html_e( '$49', 'corporate-solutions' ); ?></del>
				<span><?php esc_html_e( '$39', 'corporate-solutions' ); ?></span>
			</div>
			<div class="panelbutton">
				<a class="button button-primary" href="<?php echo esc_url( CORPORATE_SOLUTIONS_PREMIUM_PAGE ); ?>" title="<?php esc_attr_e( 'Go Pro', 'corporate-solutions' ); ?>" target="_blank"><?php esc_html_e( 'Try Premium', 'corporate-solutions' ); ?></a>

				<a class="button button-primary" href="<?php echo esc_url( CORPORATE_SOLUTIONS_PRO_DEMO ); ?>" title="<?php esc_attr_e( 'Live Demo', 'corporate-solutions' ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'corporate-solutions' ); ?></a>
			</div>
			<a class="button button-primary pro-doc" href="<?php echo esc_url( CORPORATE_SOLUTIONS_PREMIUM_DOCUMENTATION ); ?>" title="<?php esc_attr_e( 'Pro Documentation', 'corporate-solutions' ); ?>" target="_blank"><?php esc_html_e( 'Pro Documentation', 'corporate-solutions' ); ?></a>
		</div>
	</div>
	<div class="pro-btn bundle-btn">
		<div class="bundle-img">
			<img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/bundle.png'; ?>" />
		</div>
		<br>
		<h3><?php esc_html_e( 'WP Theme Bundle', 'corporate-solutions' ); ?></h3>
		<p><?php esc_html_e( 'Get access to a collection of premium WordPress themes in one bundle. Enjoy effortless website building, full customization, and dedicated customer support for a smooth, professional web experience.', 'corporate-solutions' ); ?></p>
		<a class="button button-primary" href="<?php echo esc_url( CORPORATE_SOLUTIONS_BUNDLE_PAGE ); ?>" title="<?php esc_attr_e( 'Go Pro', 'corporate-solutions' ); ?>" target="_blank">
            <?php esc_html_e( 'Exclusive Theme Bundle - $79', 'corporate-solutions' ); ?>
        </a>
	</div>
</div>