<?php
/**
 * Getting Started Page.
 *
 * @package corporate_solutions
 */


if( ! function_exists( 'corporate_solutions_getting_started_menu' ) ) :
/**
 * Adding Getting Started Page in admin menu
 */
function corporate_solutions_getting_started_menu(){	
	add_theme_page(
		__( 'Getting Started', 'corporate-solutions' ),
		__( 'Getting Started', 'corporate-solutions' ),
		'manage_options',
		'corporate-solutions-getting-started',
		'corporate_solutions_getting_started_page'
	);
}
endif;
add_action( 'admin_menu', 'corporate_solutions_getting_started_menu' );

if( ! function_exists( 'corporate_solutions_getting_started_admin_scripts' ) ) :
/**
 * Load Getting Started styles in the admin
 */
function corporate_solutions_getting_started_admin_scripts( $hook ){
	// Load styles only on our page
	if( 'appearance_page_corporate-solutions-getting-started' != $hook ) return;

    wp_enqueue_style( 'corporate-solutions-getting-started', get_template_directory_uri() . '/resource/css/getting-started.css', false, CORPORATE_SOLUTIONS_THEME_VERSION );

    wp_enqueue_script( 'corporate-solutions-getting-started', get_template_directory_uri() . '/resource/js/getting-started.js', array( 'jquery' ), CORPORATE_SOLUTIONS_THEME_VERSION, true );
}
endif;
add_action( 'admin_enqueue_scripts', 'corporate_solutions_getting_started_admin_scripts' );

if( ! function_exists( 'corporate_solutions_getting_started_page' ) ) :
/**
 * Callback function for admin page.
*/
function corporate_solutions_getting_started_page(){ 
	$corporate_solutions_theme = wp_get_theme();?>
	<div class="wrap getting-started container">
		<div class="getting-info">
			<div class="theme-intro">
				<div class="intro-wrap">
					<div class="intro cointaner">
						<div class="intro-content">
							<h3><?php echo esc_html( 'Welcome to', 'corporate-solutions' );?> <span class="theme-name"><?php echo esc_html( CORPORATE_SOLUTIONS_THEME_NAME ); ?></span></h3>
							<p class="about-text">
								<?php
								// Remove last sentence of description.
								$corporate_solutions_description = explode( '. ', $corporate_solutions_theme->get( 'Description' ) );

								$corporate_solutions_description = implode( '. ', $corporate_solutions_description );

								echo esc_html( $corporate_solutions_description . '' );
							?></p>
							<div class="btns-getstart">
								<a href="<?php echo esc_url( CORPORATE_SOLUTIONS_PREMIUM_PAGE ); ?>" target="_blank" class="button button-primary"><?php esc_html_e( 'Get Premium', 'corporate-solutions' ); ?></a>
								<a href="<?php echo esc_url( CORPORATE_SOLUTIONS_PRO_DEMO ); ?>" target="_blank" class="button button-primary"><?php esc_html_e( 'Live Demo', 'corporate-solutions' ); ?></a>
								<a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" target="_blank" class="button button-primary"><?php esc_html_e( 'Customize Theme', 'corporate-solutions' ); ?></a>
							</div>
							<div class="btns-wizard">
                                <?php if ( ! get_option('is-demo-imported') ) : ?>
                                    <a class="wizard" href="<?php echo esc_url( admin_url( 'themes.php?page=corporatesolutions-wizard' ) ); ?>" class="button button-primary"><?php esc_html_e( 'Import Theme Demo', 'corporate-solutions' ); ?></a>
                                <?php else : ?>
                                    <a target="_blank" href="<?php echo esc_url( home_url() ); ?>" class="button button-primary view-site">
                                        <?php esc_html_e( 'Visit Your Website', 'corporate-solutions' ); ?>
                                    </a>
                                <?php endif; ?>
  							</div>
						</div>
						<div class="intro-img">
							<img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/bundle.png'; ?>" />										
							<br>
							<h4 class="bundle-text"><?php esc_html_e( 'WP Theme Bundle', 'corporate-solutions' ); ?></h4>
							<p class="about-text"><?php esc_html_e('Get access to a collection of premium WordPress themes in one bundle. Enjoy effortless website building, full customization, and dedicated customer support for a smooth, professional web experience.', 'corporate-solutions'); ?></p>
							<a class="button button-primary" href="<?php echo esc_url( CORPORATE_SOLUTIONS_BUNDLE_PAGE ); ?>" title="<?php esc_attr_e( 'Go Pro', 'corporate-solutions' ); ?>" target="_blank">
								<?php esc_html_e( 'Exclusive Theme Bundle - $79', 'corporate-solutions' ); ?>
							</a>
						</div>
					</div>
				</div>
				<div class="cointaner panels">
					<ul class="inline-list">
						<li class="current">
							<a id="help" href="javascript:void(0);">
								<?php esc_html_e( 'Getting Started', 'corporate-solutions' ); ?>
							</a>
						</li>
						<li>
							<a id="free-pro-panel" href="javascript:void(0);">
								<?php esc_html_e( 'Free Vs Pro', 'corporate-solutions' ); ?>
							</a>
						</li>
					</ul>
					<div id="panel" class="panel">
						<?php require get_template_directory() . '/theme-library/getting-started/tabs/help-panel.php'; ?>
						<?php require get_template_directory() . '/theme-library/getting-started/tabs/free-vs-pro-panel.php'; ?>
						<?php require get_template_directory() . '/theme-library/getting-started/tabs/link-panel.php'; ?>
					</div>
				</div>
			</div>
			<div class="icons-info">
				<div class="icon-img">									
					<a href="<?php echo esc_url( CORPORATE_SOLUTIONS_REVIEW ); ?>" title="<?php esc_attr_e( 'Review Theme', 'corporate-solutions' ); ?>" target="_blank">
						<img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/icon1.png'; ?>" />	
						<?php esc_html_e( 'Review Theme', 'corporate-solutions' ); ?>
					</a>
				</div>
				<div class="icon-img">									
					<a href="<?php echo esc_url( CORPORATE_SOLUTIONS_SUPPORT ); ?>" title="<?php esc_attr_e( 'Contact Support', 'corporate-solutions' ); ?>" target="_blank">
						<img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/icon2.png'; ?>" />	
						<?php esc_html_e( 'Contact Support', 'corporate-solutions' ); ?>
					</a>
				</div>
				<div class="icon-img">									
					<a href="<?php echo esc_url( CORPORATE_SOLUTIONS_THEME_DOCUMENTATION ); ?>" title="<?php esc_attr_e( 'Free Theme Documentation', 'corporate-solutions' ); ?>" target="_blank">
						<img src="<?php echo esc_url(get_template_directory_uri()) .'/theme-library/getting-started/images/icon3.png'; ?>" />	
						<?php esc_html_e( 'Free Theme Documentation', 'corporate-solutions' ); ?>
					</a>
				</div>
			</div>	
		</div>	
	</div>
	<?php
}
endif;