<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package corporate_solutions
 */

function corporate_solutions_body_classes( $corporate_solutions_classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$corporate_solutions_classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$corporate_solutions_classes[] = 'no-sidebar';
	}

	$corporate_solutions_classes[] = corporate_solutions_sidebar_layout();

	return $corporate_solutions_classes;
}
add_filter( 'body_class', 'corporate_solutions_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function corporate_solutions_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'corporate_solutions_pingback_header' );


/**
 * Get all posts for customizer Post content type.
 */
function corporate_solutions_get_post_choices() {
	$corporate_solutions_choices = array( '' => esc_html__( '--Select--', 'corporate-solutions' ) );
	$corporate_solutions_args    = array( 'numberposts' => -1 );
	$corporate_solutions_posts   = get_posts( $corporate_solutions_args );

	foreach ( $corporate_solutions_posts as $corporate_solutions_post ) {
		$corporate_solutions_id             = $corporate_solutions_post->ID;
		$corporate_solutions_title          = $corporate_solutions_post->post_title;
		$corporate_solutions_choices[ $corporate_solutions_id ] = $corporate_solutions_title;
	}

	return $corporate_solutions_choices;
}

/**
 * Get all pages for customizer Page content type.
 */
function corporate_solutions_get_page_choices() {
	$corporate_solutions_choices = array( '' => esc_html__( '--Select--', 'corporate-solutions' ) );
	$corporate_solutions_pages   = get_pages();

	foreach ( $corporate_solutions_pages as $corporate_solutions_page ) {
		$corporate_solutions_choices[ $corporate_solutions_page->ID ] = $corporate_solutions_page->post_title;
	}

	return $corporate_solutions_choices;
}

/**
 * Get all categories for customizer Category content type.
 */
function corporate_solutions_get_post_cat_choices() {
	$corporate_solutions_choices = array( '' => esc_html__( '--Select--', 'corporate-solutions' ) );
	$corporate_solutions_cats    = get_categories();

	foreach ( $corporate_solutions_cats as $corporate_solutions_cat ) {
		$corporate_solutions_choices[ $corporate_solutions_cat->term_id ] = $corporate_solutions_cat->name;
	}

	return $corporate_solutions_choices;
}

/**
 * Get all donation forms for customizer form content type.
 */
function corporate_solutions_get_post_donation_form_choices() {
	$corporate_solutions_choices = array( '' => esc_html__( '--Select--', 'corporate-solutions' ) );
	$corporate_solutions_posts   = get_posts(
		array(
			'post_type'   => 'give_forms',
			'numberposts' => -1,
		)
	);
	foreach ( $corporate_solutions_posts as $corporate_solutions_post ) {
		$corporate_solutions_choices[ $corporate_solutions_post->ID ] = $corporate_solutions_post->post_title;
	}
	return $corporate_solutions_choices;
}

if ( ! function_exists( 'corporate_solutions_excerpt_length' ) ) :
	/**
	 * Excerpt length.
	 */
	function corporate_solutions_excerpt_length( $corporate_solutions_length ) {
		if ( is_admin() ) {
			return $corporate_solutions_length;
		}

		return get_theme_mod( 'corporate_solutions_excerpt_length', 20 );
	}
endif;
add_filter( 'excerpt_length', 'corporate_solutions_excerpt_length', 999 );

if ( ! function_exists( 'corporate_solutions_excerpt_more' ) ) :
	/**
	 * Excerpt more.
	 */
	function corporate_solutions_excerpt_more( $corporate_solutions_more ) {
		if ( is_admin() ) {
			return $corporate_solutions_more;
		}

		return '&hellip;';
	}
endif;
add_filter( 'excerpt_more', 'corporate_solutions_excerpt_more' );

if ( ! function_exists( 'corporate_solutions_sidebar_layout' ) ) {
	/**
	 * Get sidebar layout.
	 */
	function corporate_solutions_sidebar_layout() {
		$corporate_solutions_sidebar_position      = get_theme_mod( 'corporate_solutions_sidebar_position', 'right-sidebar' );
		$corporate_solutions_sidebar_position_post = get_theme_mod( 'corporate_solutions_post_sidebar_position', 'right-sidebar' );
		$corporate_solutions_sidebar_position_page = get_theme_mod( 'corporate_solutions_page_sidebar_position', 'right-sidebar' );

		if ( is_single() ) {
			$corporate_solutions_sidebar_position = $corporate_solutions_sidebar_position_post;
		} elseif ( is_page() ) {
			$corporate_solutions_sidebar_position = $corporate_solutions_sidebar_position_page;
		}

		return $corporate_solutions_sidebar_position;
	}
}

if ( ! function_exists( 'corporate_solutions_is_sidebar_enabled' ) ) {
	/**
	 * Check if sidebar is enabled.
	 */
	function corporate_solutions_is_sidebar_enabled() {
		$corporate_solutions_sidebar_position      = get_theme_mod( 'corporate_solutions_sidebar_position', 'right-sidebar' );
		$corporate_solutions_sidebar_position_post = get_theme_mod( 'corporate_solutions_post_sidebar_position', 'right-sidebar' );
		$corporate_solutions_sidebar_position_page = get_theme_mod( 'corporate_solutions_page_sidebar_position', 'right-sidebar' );

		$corporate_solutions_sidebar_enabled = true;
		if ( is_home() || is_archive() || is_search() ) {
			if ( 'no-sidebar' === $corporate_solutions_sidebar_position ) {
				$corporate_solutions_sidebar_enabled = false;
			}
		} elseif ( is_single() ) {
			if ( 'no-sidebar' === $corporate_solutions_sidebar_position || 'no-sidebar' === $corporate_solutions_sidebar_position_post ) {
				$corporate_solutions_sidebar_enabled = false;
			}
		} elseif ( is_page() ) {
			if ( 'no-sidebar' === $corporate_solutions_sidebar_position || 'no-sidebar' === $corporate_solutions_sidebar_position_page ) {
				$corporate_solutions_sidebar_enabled = false;
			}
		}
		return $corporate_solutions_sidebar_enabled;
	}
}

if ( ! function_exists( 'corporate_solutions_get_homepage_sections ' ) ) {
	/**
	 * Returns homepage sections.
	 */
	function corporate_solutions_get_homepage_sections() {
		$corporate_solutions_sections = array(
			'banner'  => esc_html__( 'Banner Section', 'corporate-solutions' ),
			'services' => esc_html__( 'Services Section', 'corporate-solutions' ),
		);
		return $corporate_solutions_sections;
	}
}

/**
 * Renders customizer section link
 */
function corporate_solutions_section_link( $corporate_solutions_section_id ) {
	$corporate_solutions_section_name      = str_replace( 'corporate_solutions_', ' ', $corporate_solutions_section_id );
	$corporate_solutions_section_name      = str_replace( '_', ' ', $corporate_solutions_section_name );
	$corporate_solutions_starting_notation = '#';
	?>
	<span class="section-link">
		<span class="section-link-title"><?php echo esc_html( $corporate_solutions_section_name ); ?></span>
	</span>
	<style type="text/css">
		<?php echo $corporate_solutions_starting_notation . $corporate_solutions_section_id; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>:hover .section-link {
			visibility: visible;
		}
	</style>
	<?php
}

/**
 * Adds customizer section link css
 */
function corporate_solutions_section_link_css() {
	if ( is_customize_preview() ) {
		?>
		<style type="text/css">
			.section-link {
				visibility: hidden;
				background-color: black;
				position: relative;
				top: 80px;
				z-index: 99;
				left: 40px;
				color: #fff;
				text-align: center;
				font-size: 20px;
				border-radius: 10px;
				padding: 20px 10px;
				text-transform: capitalize;
			}

			.section-link-title {
				padding: 0 10px;
			}

			.banner-section {
				position: relative;
			}

			.banner-section .section-link {
				position: absolute;
				top: 100px;
			}
		</style>
		<?php
	}
}
add_action( 'wp_head', 'corporate_solutions_section_link_css' );

/**
 * Breadcrumb.
 */
function corporate_solutions_breadcrumb( $corporate_solutions_args = array() ) {
	if ( ! get_theme_mod( 'corporate_solutions_enable_breadcrumb', true ) ) {
		return;
	}

	$corporate_solutions_args = array(
		'show_on_front' => false,
		'show_title'    => true,
		'show_browse'   => false,
	);
	breadcrumb_trail( $corporate_solutions_args );
}
add_action( 'corporate_solutions_breadcrumb', 'corporate_solutions_breadcrumb', 10 );

/**
 * Add separator for breadcrumb trail.
 */
function corporate_solutions_breadcrumb_trail_print_styles() {
	$corporate_solutions_breadcrumb_separator = get_theme_mod( 'corporate_solutions_breadcrumb_separator', '/' );

	$corporate_solutions_style = '
		.trail-items li::after {
			content: "' . $corporate_solutions_breadcrumb_separator . '";
		}'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	$corporate_solutions_style = apply_filters( 'corporate_solutions_breadcrumb_trail_inline_style', trim( str_replace( array( "\r", "\n", "\t", '  ' ), '', $corporate_solutions_style ) ) );

	if ( $corporate_solutions_style ) {
		echo "\n" . '<style type="text/css" id="breadcrumb-trail-css">' . $corporate_solutions_style . '</style>' . "\n"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
add_action( 'wp_head', 'corporate_solutions_breadcrumb_trail_print_styles' );

/**
 * Pagination for archive.
 */
function corporate_solutions_render_posts_pagination() {
	$corporate_solutions_footer_background_image = get_theme_mod( 'corporate_solutions_enable_pagination', true );
	if ( $corporate_solutions_footer_background_image ) {
		$corporate_solutions_pagination_type = get_theme_mod( 'corporate_solutions_pagination_type', 'default' );
		if ( 'default' === $corporate_solutions_pagination_type ) :
			the_posts_navigation();
		else :
			the_posts_pagination();
		endif;
	}
}
add_action( 'corporate_solutions_posts_pagination', 'corporate_solutions_render_posts_pagination', 10 );

/**
 * Pagination for single post.
 */
function corporate_solutions_render_post_navigation() {
	the_post_navigation(
		array(
			'prev_text' => '<span>&#10229;</span> <span class="nav-title">%title</span>',
			'next_text' => '<span class="nav-title">%title</span> <span>&#10230;</span>',
		)
	);
}
add_action( 'corporate_solutions_post_navigation', 'corporate_solutions_render_post_navigation' );

/**
 * Adds footer copyright text.
 */
function corporate_solutions_output_footer_copyright_content() {
    $corporate_solutions_theme_data = wp_get_theme();
    $corporate_solutions_copyright_text = get_theme_mod('corporate_solutions_footer_copyright_text');

    if (!empty($corporate_solutions_copyright_text)) {
        $corporate_solutions_text = $corporate_solutions_copyright_text;
    } else {
        $corporate_solutions_default_text = '<a href="'. esc_url(__('https://asterthemes.com/products/free-corporate-wordpress-theme','corporate-solutions')) . '" target="_blank"> ' . esc_html($corporate_solutions_theme_data->get('Name')) . '</a>' . '&nbsp;' . esc_html__('by', 'corporate-solutions') . '&nbsp;<a target="_blank" href="' . esc_url($corporate_solutions_theme_data->get('AuthorURI')) . '">' . esc_html(ucwords($corporate_solutions_theme_data->get('Author'))) . '</a>';
        /* translators: %s: WordPress.org URL */
		$corporate_solutions_default_text .= sprintf(esc_html__(' | Powered by %s', 'corporate-solutions'), '<a href="' . esc_url(__('https://wordpress.org/', 'corporate-solutions')) . '" target="_blank">WordPress</a>. ');

        $corporate_solutions_text = $corporate_solutions_default_text;
    }
    ?>
    <span><?php echo wp_kses_post($corporate_solutions_text); ?></span>
    <?php
}
add_action('corporate_solutions_footer_copyright', 'corporate_solutions_output_footer_copyright_content');

/* Footer Social Icons */ 
function corporate_solutions_footer_social_links() {

    if ( get_theme_mod('corporate_solutions_enable_footer_icon_section', true) ) {

            ?>
            <div class="socialicons">
				<div class="asterthemes-wrapper">
					<?php if ( get_theme_mod('corporate_solutions_footer_facebook_link', 'https://www.facebook.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('corporate_solutions_footer_facebook_link', 'https://www.facebook.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('corporate_solutions_facebook_icon', 'fab fa-facebook-f')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Facebook', 'corporate-solutions'); ?></span>
						</a>
					<?php } ?>
					<?php if ( get_theme_mod('corporate_solutions_footer_twitter_link', 'https://x.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('corporate_solutions_footer_twitter_link', 'https://x.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('corporate_solutions_twitter_icon', 'fab fa-twitter')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Twitter', 'corporate-solutions'); ?></span>
						</a>
					<?php } ?>
					<?php if ( get_theme_mod('corporate_solutions_footer_instagram_link', 'https://www.instagram.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('corporate_solutions_footer_instagram_link', 'https://www.instagram.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('corporate_solutions_instagram_icon', 'fab fa-instagram')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Instagram', 'corporate-solutions'); ?></span>
						</a>
					<?php } ?>
					<?php if ( get_theme_mod('corporate_solutions_footer_linkedin_link', 'https://in.linkedin.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('corporate_solutions_footer_linkedin_link', 'https://in.linkedin.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('corporate_solutions_linkedin_icon', 'fab fa-linkedin')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Linkedin', 'corporate-solutions'); ?></span>
						</a>
					<?php } ?>
					<?php if ( get_theme_mod('corporate_solutions_footer_youtube_link', 'https://www.youtube.com/') != '' ) { ?>
						<a target="_blank" href="<?php echo esc_url(get_theme_mod('corporate_solutions_footer_youtube_link', 'https://www.youtube.com/')); ?>">
							<i class="<?php echo esc_attr(get_theme_mod('corporate_solutions_youtube_icon', 'fab fa-youtube')); ?>"></i>
							<span class="screen-reader-text"><?php esc_html_e('Youtube', 'corporate-solutions'); ?></span>
						</a>
					<?php } ?>
				</div>
            </div>
            <?php
    }
}
add_action('wp_footer', 'corporate_solutions_footer_social_links');

/**
 * GET START FUNCTION
 */

function corporate_solutions_getpage_css($hook) {
	wp_enqueue_script( 'corporate-solutions-admin-script', get_template_directory_uri() . '/resource/js/corporate-solutions-admin-notice-script.js', array( 'jquery' ) );
    wp_localize_script( 'corporate-solutions-admin-script', 'corporate_solutions_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
    wp_enqueue_style( 'corporate-solutions-notice-style', get_template_directory_uri() . '/resource/css/notice.css' );
}

add_action( 'admin_enqueue_scripts', 'corporate_solutions_getpage_css' );


add_action('wp_ajax_corporate_solutions_dismissable_notice', 'corporate_solutions_dismissable_notice');
function corporate_solutions_switch_theme() {
    delete_user_meta(get_current_user_id(), 'corporate_solutions_dismissable_notice');
}
add_action('after_switch_theme', 'corporate_solutions_switch_theme');
function corporate_solutions_dismissable_notice() {
    update_user_meta(get_current_user_id(), 'corporate_solutions_dismissable_notice', true);
    die();
}

function corporate_solutions_deprecated_hook_admin_notice() {
    global $corporate_solutions_pagenow;
    
    // Check if the current page is the one where you don't want the notice to appear
    if ( $corporate_solutions_pagenow === 'themes.php' && isset( $_GET['page'] ) && $_GET['page'] === 'corporate-solutions-getting-started' ) {
        return;
    }

    $corporate_solutions_dismissed = get_user_meta( get_current_user_id(), 'corporate_solutions_dismissable_notice', true );
    if ( !$corporate_solutions_dismissed) { ?>
        <div class="getstrat updated notice notice-success is-dismissible notice-get-started-class">
            <div class="at-admin-content" >
                <h2><?php esc_html_e('Welcome to Corporate Solutions', 'corporate-solutions'); ?></h2>
                <p><?php _e('Explore the features of our Pro Theme and take your Corporate journey to the next level.', 'corporate-solutions'); ?></p>
                <p ><?php _e('Get Started With Theme By Clicking On Getting Started.', 'corporate-solutions'); ?><p>
                <div style="display: flex; justify-content: center; align-items:center; flex-wrap: wrap; gap: 5px">
                    <a class="admin-notice-btn button button-primary button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=corporate-solutions-getting-started' )); ?>"><?php esc_html_e( 'Get started', 'corporate-solutions' ) ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://demo.asterthemes.com/corporate-solutions"><?php esc_html_e('View Demo', 'corporate-solutions') ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://asterthemes.com/products/corporate-wordpress-theme"><?php esc_html_e('Buy Now', 'corporate-solutions') ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="<?php echo esc_url( CORPORATE_SOLUTIONS_BUNDLE_PAGE ); ?>"><?php esc_html_e('Get Bundle', 'corporate-solutions') ?></a>
                </div>
            </div>
            <div class="at-admin-image">
                <img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;border: 2px solid #ddd;border-radius: 4px;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
            </div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'corporate_solutions_deprecated_hook_admin_notice' );

//Admin Notice For Getstart
function corporate_solutions_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

if ( ! function_exists( 'corporate_solutions_footer_widget' ) ) :
	function corporate_solutions_footer_widget() {
		$corporate_solutions_footer_widget_column = get_theme_mod('corporate_solutions_footer_widget_column','4');

		$corporate_solutions_column_class = '';
		if ($corporate_solutions_footer_widget_column == '1') {
			$corporate_solutions_column_class = 'one-column';
		} elseif ($corporate_solutions_footer_widget_column == '2') {
			$corporate_solutions_column_class = 'two-columns';
		} elseif ($corporate_solutions_footer_widget_column == '3') {
			$corporate_solutions_column_class = 'three-columns';
		} else {
			$corporate_solutions_column_class = 'four-columns';
		}
	
		if($corporate_solutions_footer_widget_column !== ''): 
		?>
		<div class="dt_footer-widgets <?php echo esc_attr($corporate_solutions_column_class); ?>">
			<div class="footer-widgets-column">
				<?php
				$footer_widgets_active = false;

				// Loop to check if any footer widget is active
				for ($i = 1; $i <= $corporate_solutions_footer_widget_column; $i++) {
					if (is_active_sidebar('corporate-solutions-footer-widget-' . $i)) {
						$footer_widgets_active = true;
						break;
					}
				}

				if ($footer_widgets_active) {
					// Display active footer widgets
					for ($i = 1; $i <= $corporate_solutions_footer_widget_column; $i++) {
						if (is_active_sidebar('corporate-solutions-footer-widget-' . $i)) : ?>
							<div class="footer-one-column">
								<?php dynamic_sidebar('corporate-solutions-footer-widget-' . $i); ?>
							</div>
						<?php endif;
					}
				} else {
				?>
				<div class="footer-one-column default-widgets">
					<aside id="search-2" class="widget widget_search default_footer_search">
						<div class="widget-header">
							<h4 class="widget-title"><?php esc_html_e('Search Here', 'corporate-solutions'); ?></h4>
						</div>
						<?php get_search_form(); ?>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="recent-posts-2" class="widget widget_recent_entries">
						<h2 class="widget-title"><?php esc_html_e('Recent Posts', 'corporate-solutions'); ?></h2>
						<ul>
							<?php
							$recent_posts = wp_get_recent_posts(array(
								'numberposts' => 5,
								'post_status' => 'publish',
							));
							foreach ($recent_posts as $post) {
								echo '<li><a href="' . esc_url(get_permalink($post['ID'])) . '">' . esc_html($post['post_title']) . '</a></li>';
							}
							wp_reset_query();
							?>
						</ul>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="recent-comments-2" class="widget widget_recent_comments">
						<h2 class="widget-title"><?php esc_html_e('Recent Comments', 'corporate-solutions'); ?></h2>
						<ul>
							<?php
							$recent_comments = get_comments(array(
								'number' => 5,
								'status' => 'approve',
							));
							foreach ($recent_comments as $comment) {
								echo '<li><a href="' . esc_url(get_comment_link($comment)) . '">' .
									/* translators: %s: details. */
									sprintf(esc_html__('Comment on %s', 'corporate-solutions'), get_the_title($comment->comment_post_ID)) .
									'</a></li>';
							}
							?>
						</ul>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="calendar-2" class="widget widget_calendar">
						<h2 class="widget-title"><?php esc_html_e('Calendar', 'corporate-solutions'); ?></h2>
						<?php get_calendar(); ?>
					</aside>
				</div>
			</div>
			<?php } ?>
		</div>
		<?php
		endif;
	}
	endif;
add_action( 'corporate_solutions_footer_widget', 'corporate_solutions_footer_widget' );

function corporate_solutions_footer_text_transform_css() {
    $corporate_solutions_footer_text_transform = get_theme_mod('footer_text_transform', 'none');
    ?>
    <style type="text/css">
        .site-footer h4,footer#colophon h2.wp-block-heading,footer#colophon .widgettitle,footer#colophon .widget-title {
            text-transform: <?php echo esc_html($corporate_solutions_footer_text_transform); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_footer_text_transform_css');