<?php
function corporate_solutions_get_all_google_fonts() {
    $corporate_solutions_webfonts_json = get_template_directory() . '/theme-library/google-webfonts.json';
    if ( ! file_exists( $corporate_solutions_webfonts_json ) ) {
        return array();
    }

    $corporate_solutions_fonts_json_data = file_get_contents( $corporate_solutions_webfonts_json );
    if ( false === $corporate_solutions_fonts_json_data ) {
        return array();
    }

    $corporate_solutions_all_fonts = json_decode( $corporate_solutions_fonts_json_data, true );
    if ( json_last_error() !== JSON_ERROR_NONE ) {
        return array();
    }

    $corporate_solutions_google_fonts = array();
    foreach ( $corporate_solutions_all_fonts as $corporate_solutions_font ) {
        $corporate_solutions_google_fonts[ $corporate_solutions_font['family'] ] = array(
            'family'   => $corporate_solutions_font['family'],
            'variants' => $corporate_solutions_font['variants'],
        );
    }
    return $corporate_solutions_google_fonts;
}


function corporate_solutions_get_all_google_font_families() {
    $corporate_solutions_google_fonts  = corporate_solutions_get_all_google_fonts();
    $corporate_solutions_font_families = array();
    foreach ( $corporate_solutions_google_fonts as $corporate_solutions_font ) {
        $corporate_solutions_font_families[ $corporate_solutions_font['family'] ] = $corporate_solutions_font['family'];
    }
    return $corporate_solutions_font_families;
}

function corporate_solutions_get_fonts_url() {
    $corporate_solutions_fonts_url = '';
    $corporate_solutions_fonts     = array();

    $corporate_solutions_all_fonts = corporate_solutions_get_all_google_fonts();

    if ( ! empty( get_theme_mod( 'corporate_solutions_site_title_font', 'Raleway' ) ) ) {
        $corporate_solutions_fonts[] = get_theme_mod( 'corporate_solutions_site_title_font', 'Raleway' );
    }

    if ( ! empty( get_theme_mod( 'corporate_solutions_site_description_font', 'Raleway' ) ) ) {
        $corporate_solutions_fonts[] = get_theme_mod( 'corporate_solutions_site_description_font', 'Raleway' );
    }

    if ( ! empty( get_theme_mod( 'corporate_solutions_header_font', 'Mulish' ) ) ) {
        $corporate_solutions_fonts[] = get_theme_mod( 'corporate_solutions_header_font', 'Mulish' );
    }

    if ( ! empty( get_theme_mod( 'corporate_solutions_content_font', 'Nunito' ) ) ) {
        $corporate_solutions_fonts[] = get_theme_mod( 'corporate_solutions_content_font', 'Nunito' );
    }

    $corporate_solutions_fonts = array_unique( $corporate_solutions_fonts );

    foreach ( $corporate_solutions_fonts as $corporate_solutions_font ) {
        $corporate_solutions_variants      = $corporate_solutions_all_fonts[ $corporate_solutions_font ]['variants'];
        $corporate_solutions_font_family[] = $corporate_solutions_font . ':' . implode( ',', $corporate_solutions_variants );
    }

    $corporate_solutions_query_args = array(
        'family' => urlencode( implode( '|', $corporate_solutions_font_family ) ),
    );

    if ( ! empty( $corporate_solutions_font_family ) ) {
        $corporate_solutions_fonts_url = add_query_arg( $corporate_solutions_query_args, 'https://fonts.googleapis.com/css' );
    }

    return $corporate_solutions_fonts_url;
}