<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package corporate_solutions
 */


function corporate_solutions_customize_css() {
    ?>
    <style type="text/css">
        :root {
            --primary-color: <?php echo esc_html( get_theme_mod( 'primary_color', '#0fb2b3' ) ); ?>;
        }
    </style>
    <?php
}
add_action( 'wp_head', 'corporate_solutions_customize_css' );

function corporate_solutions_enqueue_selected_fonts() {
    $corporate_solutions_fonts_url = corporate_solutions_get_fonts_url();
    if (!empty($corporate_solutions_fonts_url)) {
        wp_enqueue_style('corporate-solutions-google-fonts', $corporate_solutions_fonts_url, array(), null);
    }
}
add_action('wp_enqueue_scripts', 'corporate_solutions_enqueue_selected_fonts');

function corporate_solutions_layout_customizer_css() {
    $corporate_solutions_margin = get_theme_mod('corporate_solutions_layout_width_margin', 50);
    ?>
    <style type="text/css">
        body.site-boxed--layout #page  {
            margin: 0 <?php echo esc_attr($corporate_solutions_margin); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_layout_customizer_css');

function corporate_solutions_blog_layout_customizer_css() {
    // Retrieve the blog layout option
    $corporate_solutions_blog_layout_option = get_theme_mod('corporate_solutions_blog_layout_option_setting', 'Left');

    // Initialize custom CSS variable
    $corporate_solutions_custom_css = '';

    // Generate custom CSS based on the layout option
    if ($corporate_solutions_blog_layout_option === 'Default') {
        $corporate_solutions_custom_css .= '.mag-post-detail { text-align: center; }';
    } elseif ($corporate_solutions_blog_layout_option === 'Left') {
        $corporate_solutions_custom_css .= '.mag-post-detail { text-align: left; }';
    } elseif ($corporate_solutions_blog_layout_option === 'Right') {
        $corporate_solutions_custom_css .= '.mag-post-detail { text-align: right; }';
    }

    // Output the combined CSS
    ?>
    <style type="text/css">
        <?php echo wp_kses($corporate_solutions_custom_css, array( 'style' => array(), 'text-align' => array() )); ?>
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_blog_layout_customizer_css');

// Featured Image Dimension
function corporate_solutions_custom_featured_image_css() {
    $corporate_solutions_dimension = get_theme_mod('corporate_solutions_blog_post_featured_image_dimension', 'default');
    $corporate_solutions_width = get_theme_mod('corporate_solutions_blog_post_featured_image_custom_width', '');
    $corporate_solutions_height = get_theme_mod('corporate_solutions_blog_post_featured_image_custom_height', '');
    
    if ($corporate_solutions_dimension === 'custom' && $corporate_solutions_width && $corporate_solutions_height) {
        $corporate_solutions_custom_css = "body:not(.single-post) .mag-post-single .mag-post-img img { width: {$corporate_solutions_width}px !important; height: {$corporate_solutions_height}px !important; }";
        wp_add_inline_style('corporate-solutions-style', $corporate_solutions_custom_css);
    }
}
add_action('wp_enqueue_scripts', 'corporate_solutions_custom_featured_image_css');

// Featured Image Border Radius
function corporate_solutions_featured_image_border_radius_css() {
    $corporate_solutions_featured_image_border_radius = get_theme_mod('corporate_solutions_featured_image_border_radius', 10);
    ?>
    <style type="text/css">  
        .mag-post-single img {
            border-radius: <?php echo esc_attr($corporate_solutions_featured_image_border_radius); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_featured_image_border_radius_css');

function corporate_solutions_sidebar_width_customizer_css() {
    $corporate_solutions_sidebar_width = get_theme_mod('corporate_solutions_sidebar_width', '30');
    ?>
    <style type="text/css">
        .right-sidebar .asterthemes-wrapper .asterthemes-page {
            grid-template-columns: auto <?php echo esc_attr($corporate_solutions_sidebar_width); ?>%;
        }
        .left-sidebar .asterthemes-wrapper .asterthemes-page {
            grid-template-columns: <?php echo esc_attr($corporate_solutions_sidebar_width); ?>% auto;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_sidebar_width_customizer_css');

if ( ! function_exists( 'corporate_solutions_get_page_title' ) ) {
    function corporate_solutions_get_page_title() {
        $corporate_solutions_title = '';

        if (is_404()) {
            $corporate_solutions_title = esc_html__('Page Not Found', 'corporate-solutions');
        } elseif (is_search()) {
            $corporate_solutions_title = esc_html__('Search Results for: ', 'corporate-solutions') . esc_html(get_search_query());
        } elseif (is_home() && !is_front_page()) {
            $corporate_solutions_title = esc_html__('Blogs', 'corporate-solutions');
        } elseif (function_exists('is_shop') && is_shop()) {
            $corporate_solutions_title = esc_html__('Shop', 'corporate-solutions');
        } elseif (is_page()) {
            $corporate_solutions_title = get_the_title();
        } elseif (is_single()) {
            $corporate_solutions_title = get_the_title();
        } elseif (is_archive()) {
            $corporate_solutions_title = get_the_archive_title();
        } else {
            $corporate_solutions_title = get_the_archive_title();
        }

        return apply_filters('corporate_solutions_page_title', $corporate_solutions_title);
    }
}

if ( ! function_exists( 'corporate_solutions_has_page_header' ) ) {
    function corporate_solutions_has_page_header() {
        // Default to true (display header)
        $corporate_solutions_return = true;

        // Custom conditions for disabling the header
        if ('hide-all-devices' === get_theme_mod('corporate_solutions_page_header_visibility', 'all-devices')) {
            $corporate_solutions_return = false;
        }

        // Apply filters and return
        return apply_filters('corporate_solutions_display_page_header', $corporate_solutions_return);
    }
}

if ( ! function_exists( 'corporate_solutions_page_header_style' ) ) {
    function corporate_solutions_page_header_style() {
        $corporate_solutions_style = get_theme_mod('corporate_solutions_page_header_style', 'default');
        return apply_filters('corporate_solutions_page_header_style', $corporate_solutions_style);
    }
}

function corporate_solutions_page_title_customizer_css() {
    $corporate_solutions_layout_option = get_theme_mod('corporate_solutions_page_header_layout', 'left');
    ?>
    <style type="text/css">
        .asterthemes-wrapper.page-header-inner {
            <?php if ($corporate_solutions_layout_option === 'flex') : ?>
                display: flex;
                justify-content: space-between;
                align-items: center;
            <?php else : ?>
                text-align: <?php echo esc_attr($corporate_solutions_layout_option); ?>;
            <?php endif; ?>
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_page_title_customizer_css');

function corporate_solutions_pagetitle_height_css() {
    $corporate_solutions_height = get_theme_mod('corporate_solutions_pagetitle_height', 50);
    ?>
    <style type="text/css">
        header.page-header {
            padding: <?php echo esc_attr($corporate_solutions_height); ?>px 0;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_pagetitle_height_css');

function corporate_solutions_site_logo_width() {
    $corporate_solutions_site_logo_width = get_theme_mod('corporate_solutions_site_logo_width', 200);
    ?>
    <style type="text/css">
        .site-logo img {
            max-width: <?php echo esc_attr($corporate_solutions_site_logo_width); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_site_logo_width');

function corporate_solutions_menu_font_size_css() {
    $corporate_solutions_menu_font_size = get_theme_mod('corporate_solutions_menu_font_size', 15);
    ?>
    <style type="text/css">
        .main-navigation a {
            font-size: <?php echo esc_attr($corporate_solutions_menu_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_menu_font_size_css');

function corporate_solutions_sidebar_widget_font_size_css() {
    $corporate_solutions_sidebar_widget_font_size = get_theme_mod('corporate_solutions_sidebar_widget_font_size', 24);
    ?>
    <style type="text/css">
        h2.wp-block-heading,aside#secondary .widgettitle,aside#secondary .widget-title {
            font-size: <?php echo esc_attr($corporate_solutions_sidebar_widget_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_sidebar_widget_font_size_css');

// Retrieve the slider visibility setting
$corporate_solutions_slider = get_theme_mod('corporate_solutions_enable_banner_section', false);

// Function to output custom CSS directly in the head section
function corporate_solutions_custom_css() {
    global $corporate_solutions_slider;
    if ($corporate_solutions_slider == true) {
        echo '<style type="text/css">
            .home header.site-header .header-main-wrapper {
                background: transparent !important;
                width:100%;
                position: absolute !important;
            }
        </style>';
    }
}

// Hook the function into the wp_head action
add_action('wp_head', 'corporate_solutions_custom_css');

// Woocommerce Related Products Settings
function corporate_solutions_related_product_css() {
    $corporate_solutions_related_product_show_hide = get_theme_mod('corporate_solutions_related_product_show_hide', true);

    if ( $corporate_solutions_related_product_show_hide != true) {
        ?>
        <style type="text/css">
            .related.products {
                display: none;
            }
        </style>
        <?php
    }
}
add_action('wp_head', 'corporate_solutions_related_product_css');

// Woocommerce Product Sale Position 
function corporate_solutions_product_sale_position_customizer_css() {
    $corporate_solutions_layout_option = get_theme_mod('corporate_solutions_product_sale_position', 'left');
    ?>
    <style type="text/css">
        .woocommerce ul.products li.product .onsale{
            <?php if ($corporate_solutions_layout_option === 'left') : ?>
                right: auto;
                left: 0px;
            <?php else : ?>
                left: auto;
                right: 0px;
            <?php endif; ?>
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_product_sale_position_customizer_css');  

//Footer Social Icon Alignment
function corporate_solutions_footer_icons_alignment_css() {
    $corporate_solutions_footer_social_align = get_theme_mod( 'corporate_solutions_footer_social_align', 'center' );   
    ?>
    <style type="text/css">
        .socialicons {
            text-align: <?php echo esc_attr( $corporate_solutions_footer_social_align ); ?> 
        }

        /* Mobile Specific */
        @media screen and (max-width: 575px) {
            .socialicons {
                text-align: center;
            }
        }
    </style>
    <?php
}
add_action( 'wp_head', 'corporate_solutions_footer_icons_alignment_css' );

//Copyright Alignment
function corporate_solutions_footer_copyright_alignment_css() {
    $corporate_solutions_footer_bottom_align = get_theme_mod( 'corporate_solutions_footer_bottom_align', 'center' );   
    ?>
    <style type="text/css">
        .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
            justify-content: <?php echo esc_attr( $corporate_solutions_footer_bottom_align ); ?> 
        }

        /* Mobile Specific */
        @media screen and (max-width: 575px) {
            .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
                justify-content: center;
                text-align:center;
            }
        }
    </style>
    <?php
}
add_action( 'wp_head', 'corporate_solutions_footer_copyright_alignment_css' );

//Copyright Font Size
function corporate_solutions_copyright_font_size_css() {
    $corporate_solutions_copyright_font_size = get_theme_mod('corporate_solutions_copyright_font_size', 16);
    ?>
    <style type="text/css">
        .site-footer-bottom .site-info span {
            font-size: <?php echo esc_attr($corporate_solutions_copyright_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_copyright_font_size_css');

// Preloader Background Color Setting
function corporate_solutions_preloader_background_colors_css() {
    $corporate_solutions_preloader_background_color_setting = get_theme_mod('corporate_solutions_preloader_background_color_setting', '');
        // Only output CSS if a color is set
        if (empty($corporate_solutions_preloader_background_color_setting)) {
            return;
        }
    ?>
    <style type="text/css">
        #loader {
            background-color: <?php echo esc_attr($corporate_solutions_preloader_background_color_setting); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_preloader_background_colors_css');

// Preloader Background Image Setting
function corporate_solutions_preloader_background_image_css() {
    $corporate_solutions_preloader_background_image_setting = get_theme_mod('corporate_solutions_preloader_background_image_setting', '');
        // Only output CSS if the background image is set
        if (empty($corporate_solutions_preloader_background_image_setting)) {
            return;
        }
    ?>
    <style type="text/css">
        #loader {
            background-image: url('<?php echo esc_url($corporate_solutions_preloader_background_image_setting); ?>');
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
        }
    </style>
    <?php
}
add_action('wp_head', 'corporate_solutions_preloader_background_image_css');

//Footer Heading Alignment
function corporate_solutions_footer_heading_alignment_css() {
    $corporate_solutions_footer_header_align = get_theme_mod( 'corporate_solutions_footer_header_align', 'left' );   
    ?>
    <style type="text/css">
        .site-footer h4, footer#colophon h2.wp-block-heading, footer#colophon .widgettitle, footer#colophon .widget-title {
            text-align: <?php echo esc_attr( $corporate_solutions_footer_header_align ); ?> 
        }
    </style>
    <?php
}
add_action( 'wp_head', 'corporate_solutions_footer_heading_alignment_css' );