<?php

/**
 * Dynamic CSS
 */
function corporate_solutions_dynamic_css() {
	$corporate_solutions_primary_color = get_theme_mod( 'primary_color', '#0fb2b3' );

	$corporate_solutions_site_title_font       = get_theme_mod( 'corporate_solutions_site_title_font', 'Raleway' );
	$corporate_solutions_site_description_font = get_theme_mod( 'corporate_solutions_site_description_font', 'Raleway' );
	$corporate_solutions_header_font           = get_theme_mod( 'corporate_solutions_header_font', 'Mulish' );
	$corporate_solutions_content_font             = get_theme_mod( 'corporate_solutions_content_font', 'Nunito' );

	// Enqueue Google Fonts
	$corporate_solutions_fonts_url = corporate_solutions_get_fonts_url();
	if ( ! empty( $corporate_solutions_fonts_url ) ) {
		wp_enqueue_style( 'corporate-solutions-google-fonts', esc_url( $corporate_solutions_fonts_url ), array(), null );
	}

	$corporate_solutions_custom_css  = '';
	$corporate_solutions_custom_css .= '
    /* Color */
    :root {
        --primary-color: ' . esc_attr( $corporate_solutions_primary_color ) . ';
        --header-text-color: ' . esc_attr( '#' . get_header_textcolor() ) . ';
    }
    ';

	$corporate_solutions_custom_css .= '
    /* Typography */
    :root {
        --font-heading: "' . esc_attr( $corporate_solutions_header_font ) . '", serif;
        --font-main: -apple-system, BlinkMacSystemFont, "' . esc_attr( $corporate_solutions_content_font ) . '", "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
    }

    body,
	button, input, select, optgroup, textarea, p {
        font-family: "' . esc_attr( $corporate_solutions_content_font ) . '", serif;
	}

	.site-identity p.site-title, h1.site-title a, h1.site-title, p.site-title a, .site-branding h1.site-title a {
        font-family: "' . esc_attr( $corporate_solutions_site_title_font ) . '", serif;
	}
    
	p.site-description {
        font-family: "' . esc_attr( $corporate_solutions_site_description_font ) . '", serif !important;
	}
    ';

	wp_add_inline_style( 'corporate-solutions-style', $corporate_solutions_custom_css );
}
add_action( 'wp_enqueue_scripts', 'corporate_solutions_dynamic_css', 99 );