<?php

/**
 * WooCommerce Settings
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_woocommerce_settings',
	array(
		'panel' => 'corporate_solutions_theme_options',
		'title' => esc_html__( 'WooCommerce Settings', 'corporate-solutions' ),
	)
);

//WooCommerce - Products per page.
$wp_customize->add_setting( 'corporate_solutions_products_per_page', array(
    'default'           => 9,
    'sanitize_callback' => 'absint',
));

$wp_customize->add_control( 'corporate_solutions_products_per_page', array(
    'type'        => 'number',
    'section'     => 'corporate_solutions_woocommerce_settings',
    'label'       => __( 'Products Per Page', 'corporate-solutions' ),
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 50,
        'step' => 1,
    ),
));

//WooCommerce - Products per row.
$wp_customize->add_setting( 'corporate_solutions_products_per_row', array(
    'default'           => '3',
    'sanitize_callback' => 'corporate_solutions_sanitize_choices',
) );

$wp_customize->add_control( 'corporate_solutions_products_per_row', array(
    'label'    => __( 'Products Per Row', 'corporate-solutions' ),
    'section'  => 'corporate_solutions_woocommerce_settings',
    'settings' => 'corporate_solutions_products_per_row',
    'type'     => 'select',
    'choices'  => array(
        '2' => '2',
		'3' => '3',
		'4' => '4',
    ),
) );

//WooCommerce - Show / Hide Related Product.
$wp_customize->add_setting(
	'corporate_solutions_related_product_show_hide',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_related_product_show_hide',
		array(
			'label'   => esc_html__( 'Show / Hide Related product', 'corporate-solutions' ),
			'section' => 'corporate_solutions_woocommerce_settings',
		)
	)
);

//WooCommerce - Product Sale Position.
$wp_customize->add_setting(
	'corporate_solutions_product_sale_position', 
	array(
		'default' => 'left',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'corporate_solutions_product_sale_position', 
	array(
		'label' => __('Product Sale Position', 'corporate-solutions'),
		'section' => 'corporate_solutions_woocommerce_settings',
		'settings' => 'corporate_solutions_product_sale_position',
		'type' => 'radio',
		'choices' => 
	array(
		'left' => __('Left', 'corporate-solutions'),
		'right' => __('Right', 'corporate-solutions'),
	),
));