<?php

/**
 * Typography Settings
 *
 * @package corporate_solutions
 */

// Typography Settings
$wp_customize->add_section(
    'corporate_solutions_typography_setting',
    array(
        'panel' => 'corporate_solutions_theme_options',
        'title' => esc_html__( 'Typography Settings', 'corporate-solutions' ),
    )
);

$wp_customize->add_setting(
    'corporate_solutions_site_title_font',
    array(
        'default'           => 'Raleway',
        'sanitize_callback' => 'corporate_solutions_sanitize_google_fonts',
    )
);

$wp_customize->add_control(
    'corporate_solutions_site_title_font',
    array(
        'label'    => esc_html__( 'Site Title Font Family', 'corporate-solutions' ),
        'section'  => 'corporate_solutions_typography_setting',
        'settings' => 'corporate_solutions_site_title_font',
        'type'     => 'select',
        'choices'  => corporate_solutions_get_all_google_font_families(),
    )
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'corporate_solutions_site_description_font',
	array(
		'default'           => 'Raleway',
		'sanitize_callback' => 'corporate_solutions_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'corporate_solutions_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'corporate-solutions' ),
		'section'  => 'corporate_solutions_typography_setting',
		'settings' => 'corporate_solutions_site_description_font',
		'type'     => 'select',
		'choices'  => corporate_solutions_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'corporate_solutions_header_font',
	array(
		'default'           => 'Mulish',
		'sanitize_callback' => 'corporate_solutions_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'corporate_solutions_header_font',
	array(
		'label'    => esc_html__( 'Heading Font Family', 'corporate-solutions' ),
		'section'  => 'corporate_solutions_typography_setting',
		'settings' => 'corporate_solutions_header_font',
		'type'     => 'select',
		'choices'  => corporate_solutions_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'corporate_solutions_content_font',
	array(
		'default'           => 'Nunito',
		'sanitize_callback' => 'corporate_solutions_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'corporate_solutions_content_font',
	array(
		'label'    => esc_html__( 'Content Font Family', 'corporate-solutions' ),
		'section'  => 'corporate_solutions_typography_setting',
		'settings' => 'corporate_solutions_content_font',
		'type'     => 'select',
		'choices'  => corporate_solutions_get_all_google_font_families(),
	)
);
