<?php

/**
 * Header Options
 *
 * @package corporate_solutions
 */


// ---------------------------------------- GENERAL OPTIONBS ----------------------------------------------------


// ---------------------------------------- PRELOADER ----------------------------------------------------

$wp_customize->add_section(
	'corporate_solutions_general_options',
	array(
		'panel' => 'corporate_solutions_theme_options',
		'title' => esc_html__( 'General Options', 'corporate-solutions' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_preloader_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_preloader_separator', array(
	'label' => __( 'Enable / Disable Site Preloader Section', 'corporate-solutions' ),
	'section' => 'corporate_solutions_general_options',
	'settings' => 'corporate_solutions_preloader_separator',
) ) );

// General Options - Enable Preloader.
$wp_customize->add_setting(
	'corporate_solutions_enable_preloader',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_preloader',
		array(
			'label'   => esc_html__( 'Enable Preloader', 'corporate-solutions' ),
			'section' => 'corporate_solutions_general_options',
		)
	)
);

// Preloader Style Setting
$wp_customize->add_setting(
    'corporate_solutions_preloader_style',
    array(
        'default'           => 'style1',
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    'corporate_solutions_preloader_style',
    array(
        'type'     => 'select',
        'label'    => esc_html__('Select Preloader Styles', 'corporate-solutions'),
		'active_callback' => 'corporate_solutions_is_preloader_style',
        'section'  => 'corporate_solutions_general_options',
        'choices'  => array(
            'style1' => esc_html__('Style 1', 'corporate-solutions'),
            'style2' => esc_html__('Style 2', 'corporate-solutions'),
            'style3' => esc_html__('Style 3', 'corporate-solutions'),
        ),
    )
);


// Preloader Background Color Setting
$wp_customize->add_setting(
	'corporate_solutions_preloader_background_color_setting',
	 array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 'corporate_solutions_preloader_background_color_setting', 
		array(
			'label' => __('Preloader Background Color', 'corporate-solutions'),
			'active_callback' => 'corporate_solutions_is_preloader_style',
			'section' => 'corporate_solutions_general_options',
		)
	)
);

// Preloader Background Image Setting
$wp_customize->add_setting(
	'corporate_solutions_preloader_background_image_setting', 
	array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize, 'corporate_solutions_preloader_background_image_setting',
		 array(
			'label' => __('Preloader Background Image', 'corporate-solutions'),
			'active_callback' => 'corporate_solutions_is_preloader_style',
			'section' => 'corporate_solutions_general_options',
		)
	)
);

// ---------------------------------------- PAGINATION ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_pagination_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_pagination_separator', array(
	'label' => __( 'Enable / Disable Pagination Section', 'corporate-solutions' ),
	'section' => 'corporate_solutions_general_options',
	'settings' => 'corporate_solutions_pagination_separator',
) ) );

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'corporate_solutions_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'corporate-solutions' ),
			'section'  => 'corporate_solutions_general_options',
			'settings' => 'corporate_solutions_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'corporate_solutions_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'corporate_solutions_sanitize_select',
	)
);

$wp_customize->add_control(
	'corporate_solutions_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_general_options',
		'settings'        => 'corporate_solutions_pagination_type',
		'active_callback' => 'corporate_solutions_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'corporate-solutions' ),
			'numeric' => __( 'Numeric', 'corporate-solutions' ),
		),
	)
);



// ---------------------------------------- BREADCRUMB ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_breadcrumb_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_breadcrumb_separators', array(
	'label' => __( 'Enable / Disable Breadcrumb Section', 'corporate-solutions' ),
	'section' => 'corporate_solutions_general_options',
	'settings' => 'corporate_solutions_breadcrumb_separators',
)));


// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'corporate_solutions_enable_breadcrumb',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'corporate-solutions' ),
			'section' => 'corporate_solutions_general_options',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'corporate_solutions_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'corporate_solutions_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'corporate-solutions' ),
		'active_callback' => 'corporate_solutions_is_breadcrumb_enabled',
		'section'         => 'corporate_solutions_general_options',
	)
);



// ---------------------------------------- Website layout ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_layuout_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_layuout_separator', array(
	'label' => __( 'Website Layout Setting', 'corporate-solutions' ),
	'section' => 'corporate_solutions_general_options',
	'settings' => 'corporate_solutions_layuout_separator',
)));


$wp_customize->add_setting(
	'corporate_solutions_website_layout',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_website_layout',
		array(
			'label'   => esc_html__('Boxed Layout', 'corporate-solutions'),
			'section' => 'corporate_solutions_general_options',
		)
	)
);

$wp_customize->add_setting('corporate_solutions_layout_width_margin', array(
	'default'           => 50,
	'sanitize_callback' => 'corporate_solutions_sanitize_range_value',
));

$wp_customize->add_control(new Corporate_Solutions_Customize_Range_Control($wp_customize, 'corporate_solutions_layout_width_margin', array(
		'label'       => __('Set Width', 'corporate-solutions'),
		'description' => __('Adjust the width around the website layout by moving the slider. Use this setting to customize the appearance of your site to fit your design preferences.', 'corporate-solutions'),
		'section'     => 'corporate_solutions_general_options',
		'settings'    => 'corporate_solutions_layout_width_margin',
		'active_callback' => 'corporate_solutions_is_layout_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 130,
			'step' => 1,
		),
)));



// ---------------------------------------- HEADER OPTIONS ----------------------------------------------------	


$wp_customize->add_section(
	'corporate_solutions_header_options',
	array(
		'panel' => 'corporate_solutions_theme_options',
		'title' => esc_html__( 'Header Options', 'corporate-solutions' ),
	)
);

// Add setting for sticky header
$wp_customize->add_setting(
	'corporate_solutions_enable_sticky_header',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
		'default'           => false,
	)
);

// Add control for sticky header setting
$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_sticky_header',
		array(
			'label'   => esc_html__( 'Enable Sticky Header', 'corporate-solutions' ),
			'section' => 'corporate_solutions_header_options',
		)
	)
);

// Header Options - Phone.
$wp_customize->add_setting(
	'corporate_solutions_callus_header_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'corporate_solutions_callus_header_text',
	array(
		'label'           => esc_html__( 'Call Text', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_header_options',
		'type'            => 'text',
	)
);

// Header Options - Phone.
$wp_customize->add_setting(
	'corporate_solutions_callus_header_number',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'corporate_solutions_callus_header_number',
	array(
		'label'           => esc_html__( 'Phone Number', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_header_options',
		'type'            => 'text',
	)
);
// icon // 
$wp_customize->add_setting(
	'corporate_solutions_call_header_icon',
	array(
        'default' => 'fas fa-comments',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Corporate_Solutions_Change_Icon_Control($wp_customize, 
	'corporate_solutions_call_header_icon',
	array(
	    'label'   		=> __('Phone Icon','corporate-solutions'),
	    'section' 		=> 'corporate_solutions_header_options',
		'iconset' => 'fa',
	))  
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_menu_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_menu_separator', array(
	'label' => __( 'Menu Settings', 'corporate-solutions' ),
	'section' => 'corporate_solutions_header_options',
	'settings' => 'corporate_solutions_menu_separator',
)));

$wp_customize->add_setting( 'corporate_solutions_menu_font_size', array(
    'default'           => 15,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'corporate_solutions_menu_font_size', array(
    'type'        => 'number',
    'section'     => 'corporate_solutions_header_options',
    'label'       => __( 'Menu Font Size ', 'corporate-solutions' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));

$wp_customize->add_setting( 'corporate_solutions_menu_text_transform', array(
    'default'           => 'capitalize', // Default value for text transform
    'sanitize_callback' => 'sanitize_text_field',
) );

// Add control for menu text transform
$wp_customize->add_control( 'corporate_solutions_menu_text_transform', array(
    'type'     => 'select',
    'section'  => 'corporate_solutions_header_options', // Adjust the section as needed
    'label'    => __( 'Menu Text Transform', 'corporate-solutions' ),
    'choices'  => array(
        'none'       => __( 'None', 'corporate-solutions' ),
        'capitalize' => __( 'Capitalize', 'corporate-solutions' ),
        'uppercase'  => __( 'Uppercase', 'corporate-solutions' ),
        'lowercase'  => __( 'Lowercase', 'corporate-solutions' ),
    ),
) );

// Menu Text Color 
$wp_customize->add_setting(
	'corporate_solutions_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'corporate_solutions_menu_text_color', 
		array(
			'label' => __('Menu Color', 'corporate-solutions'),
			'section' => 'corporate_solutions_header_options',
		)
	)
);

// Sub Menu Text Color 
$wp_customize->add_setting(
	'corporate_solutions_sub_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'corporate_solutions_sub_menu_text_color', 
		array(
			'label' => __('Sub Menu Color', 'corporate-solutions'),
			'section' => 'corporate_solutions_header_options',
		)
	)
);

// ----------------------------------------SITE IDENTITY----------------------------------------------------


$wp_customize->add_setting( 'corporate_solutions_site_title_size', array(
    'default'           => 40, // Default font size in pixels
    'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
) );

// Add control for site title size
$wp_customize->add_control( 'corporate_solutions_site_title_size', array(
    'type'        => 'number',
    'section'     => 'title_tagline', // You can change this section to your preferred section
    'label'       => __( 'Site Title Font Size ', 'corporate-solutions' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
) );

// Site Logo - Enable Setting.
$wp_customize->add_setting(
	'corporate_solutions_enable_site_logo',
	array(
		'default'           => true, // Default is to display the logo.
		'sanitize_callback' => 'corporate_solutions_sanitize_switch', // Sanitize using a custom switch function.
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_site_logo',
		array(
			'label'    => esc_html__( 'Enable Site Logo', 'corporate-solutions' ),
			'section'  => 'title_tagline', // Section to add this control.
			'settings' => 'corporate_solutions_enable_site_logo',
		)
	)
);

// Site Title - Enable Setting.
$wp_customize->add_setting(
	'corporate_solutions_enable_site_title_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_site_title_setting',
		array(
			'label'    => esc_html__( 'Enable Site Title', 'corporate-solutions' ),
			'section'  => 'title_tagline',
			'settings' => 'corporate_solutions_enable_site_title_setting',
		)
	)
);
// Tagline - Enable Setting.
$wp_customize->add_setting(
	'corporate_solutions_enable_tagline_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_tagline_setting',
		array(
			'label'    => esc_html__( 'Enable Tagline', 'corporate-solutions' ),
			'section'  => 'title_tagline',
			'settings' => 'corporate_solutions_enable_tagline_setting',
		)
	)
);

$wp_customize->add_setting('corporate_solutions_site_logo_width', array(
    'default'           => 200,
    'sanitize_callback' => 'corporate_solutions_sanitize_range_value',
));

$wp_customize->add_control(new Corporate_Solutions_Customize_Range_Control($wp_customize, 'corporate_solutions_site_logo_width', array(
    'label'       => __('Adjust Site Logo Width', 'corporate-solutions'),
    'description' => __('This setting controls the Width of Site Logo', 'corporate-solutions'),
    'section'     => 'title_tagline',
    'settings'    => 'corporate_solutions_site_logo_width',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 400,
        'step' => 5,
    ),
)));