<?php

/**
 * Single Post Options
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_single_post_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'corporate-solutions' ),
		'panel' => 'corporate_solutions_theme_options',
	)
);



// Post Options - Show / Hide Date.
$wp_customize->add_setting(
	'corporate_solutions_single_post_hide_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_single_post_hide_date',
		array(
			'label'   => esc_html__( 'Show / Hide Date', 'corporate-solutions' ),
			'section' => 'corporate_solutions_single_post_options',
		)
	)
);

// Post Options - Show / Hide Author.
$wp_customize->add_setting(
	'corporate_solutions_single_post_hide_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_single_post_hide_author',
		array(
			'label'   => esc_html__( 'Show / Hide Author', 'corporate-solutions' ),
			'section' => 'corporate_solutions_single_post_options',
		)
	)
);

// Post Options - Show / Hide Comments.
$wp_customize->add_setting(
	'corporate_solutions_single_post_hide_comments',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_single_post_hide_comments',
		array(
			'label'   => esc_html__( 'Show / Hide Comments', 'corporate-solutions' ),
			'section' => 'corporate_solutions_single_post_options',
		)
	)
);

// Post Options - Show / Hide Time.
$wp_customize->add_setting(
	'corporate_solutions_single_post_hide_time',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_single_post_hide_time',
		array(
			'label'   => esc_html__( 'Show / Hide Time', 'corporate-solutions' ),
			'section' => 'corporate_solutions_single_post_options',
		)
	)
);

// Post Options - Show / Hide Category.
$wp_customize->add_setting(
	'corporate_solutions_single_post_hide_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_single_post_hide_category',
		array(
			'label'   => esc_html__( 'Show / Hide Category', 'corporate-solutions' ),
			'section' => 'corporate_solutions_single_post_options',
		)
	)
);

// Post Options - Show / Hide Tag.
$wp_customize->add_setting(
	'corporate_solutions_post_hide_tags',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_post_hide_tags',
		array(
			'label'   => esc_html__( 'Show / Hide Tag', 'corporate-solutions' ),
			'section' => 'corporate_solutions_single_post_options',
		)
	)
);

// Post Options - Comment Title.
$wp_customize->add_setting(
	'corporate_solutions_blog_post_comment_title',
	array(
		'default'=> 'Leave a Reply',
		'sanitize_callback'	=> 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'corporate_solutions_blog_post_comment_title',
	array(
		'label'	=> __('Comment Title','corporate-solutions'),
		'input_attrs' => array(
			'placeholder' => __( 'Leave a Reply', 'corporate-solutions' ),
		),
		'section'=> 'corporate_solutions_single_post_options',
		'type'=> 'text'
	)
);