<?php

/**
 * Sidebar Position
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_sidebar_position',
	array(
		'title' => esc_html__( 'Sidebar Position', 'corporate-solutions' ),
		'panel' => 'corporate_solutions_theme_options',
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_global_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_global_sidebar_separator', array(
	'label' => __( 'Global Sidebar Position', 'corporate-solutions' ),
	'section' => 'corporate_solutions_sidebar_position',
	'settings' => 'corporate_solutions_global_sidebar_separator',
)));

// Sidebar Position - Global Sidebar Position.
$wp_customize->add_setting(
	'corporate_solutions_sidebar_position',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'corporate_solutions_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'corporate-solutions' ),
		'section' => 'corporate_solutions_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'corporate-solutions' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'corporate-solutions' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'corporate-solutions' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_post_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_post_sidebar_separator', array(
	'label' => __( 'Post Sidebar Position', 'corporate-solutions' ),
	'section' => 'corporate_solutions_sidebar_position',
	'settings' => 'corporate_solutions_post_sidebar_separator',
)));

// Sidebar Position - Post Sidebar Position.
$wp_customize->add_setting(
	'corporate_solutions_post_sidebar_position',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'corporate_solutions_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'corporate-solutions' ),
		'section' => 'corporate_solutions_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'corporate-solutions' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'corporate-solutions' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'corporate-solutions' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_page_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_page_sidebar_separator', array(
	'label' => __( 'Page Sidebar Position', 'corporate-solutions' ),
	'section' => 'corporate_solutions_sidebar_position',
	'settings' => 'corporate_solutions_page_sidebar_separator',
)));

// Sidebar Position - Page Sidebar Position.
$wp_customize->add_setting(
	'corporate_solutions_page_sidebar_position',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'corporate_solutions_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'corporate-solutions' ),
		'section' => 'corporate_solutions_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'corporate-solutions' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'corporate-solutions' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'corporate-solutions' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_sidebar_width_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_sidebar_width_separator', array(
	'label' => __( 'Sidebar Width Setting', 'corporate-solutions' ),
	'section' => 'corporate_solutions_sidebar_position',
	'settings' => 'corporate_solutions_sidebar_width_separator',
)));


$wp_customize->add_setting( 'corporate_solutions_sidebar_width', array(
	'default'           => '30',
	'sanitize_callback' => 'corporate_solutions_sanitize_range_value',
) );

$wp_customize->add_control(new Corporate_Solutions_Customize_Range_Control($wp_customize, 'corporate_solutions_sidebar_width', array(
	'section'     => 'corporate_solutions_sidebar_position',
	'label'       => __( 'Adjust Sidebar Width', 'corporate-solutions' ),
	'description' => __( 'Adjust the width of the sidebar.', 'corporate-solutions' ),
	'input_attrs' => array(
		'min'  => 10,
		'max'  => 50,
		'step' => 1,
	),
)));

$wp_customize->add_setting( 'corporate_solutions_sidebar_widget_font_size', array(
    'default'           => 24,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'corporate_solutions_sidebar_widget_font_size', array(
    'type'        => 'number',
    'section'     => 'corporate_solutions_sidebar_position',
    'label'       => __( 'Sidebar Widgets Heading Font Size ', 'corporate-solutions' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));