<?php

/**
 * Pige Title Options
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_page_title_options',
	array(
		'panel' => 'corporate_solutions_theme_options',
		'title' => esc_html__( 'Page Title', 'corporate-solutions' ),
	)
);

$wp_customize->add_setting(
    'corporate_solutions_page_header_visibility',
    array(
        'default'           => 'all-devices',
        'sanitize_callback' => 'corporate_solutions_sanitize_select',
    )
);

$wp_customize->add_control(
    new WP_Customize_Control(
        $wp_customize,
        'corporate_solutions_page_header_visibility',
        array(
            'label'    => esc_html__( 'Page Header Visibility', 'corporate-solutions' ),
            'type'     => 'select',
            'section'  => 'corporate_solutions_page_title_options',
            'settings' => 'corporate_solutions_page_header_visibility',
            'priority' => 10,
            'choices'  => array(
                'all-devices'        => esc_html__( 'Show on all devices', 'corporate-solutions' ),
                'hide-tablet'        => esc_html__( 'Hide on Tablet', 'corporate-solutions' ),
                'hide-mobile'        => esc_html__( 'Hide on Mobile', 'corporate-solutions' ),
                'hide-tablet-mobile' => esc_html__( 'Hide on Tablet & Mobile', 'corporate-solutions' ),
                'hide-all-devices'   => esc_html__( 'Hide on all devices', 'corporate-solutions' ),
            ),
        )
    )
);


$wp_customize->add_setting( 'corporate_solutions_page_title_background_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_page_title_background_separator', array(
	'label' => __( 'Page Title BG Image & Color Setting', 'corporate-solutions' ),
	'section' => 'corporate_solutions_page_title_options',
	'settings' => 'corporate_solutions_page_title_background_separator',
)));


$wp_customize->add_setting(
	'corporate_solutions_page_header_style',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
		'default'           => False,
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_page_header_style',
		array(
			'label'   => esc_html__('Page Title Background Image', 'corporate-solutions'),
			'section' => 'corporate_solutions_page_title_options',
		)
	)
);

$wp_customize->add_setting( 'corporate_solutions_page_header_background_image', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'corporate_solutions_page_header_background_image', array(
    'label'    => __( 'Background Image', 'corporate-solutions' ),
    'section'  => 'corporate_solutions_page_title_options',
	'description' => __('Choose either a background image or a color. If a background image is selected, the background color will not be visible.', 'corporate-solutions'),
    'settings' => 'corporate_solutions_page_header_background_image',
	'active_callback' => 'corporate_solutions_is_pagetitle_bcakground_image_enabled',
)));


$wp_customize->add_setting('corporate_solutions_page_header_image_height', array(
	'default'           => 200,
	'sanitize_callback' => 'corporate_solutions_sanitize_range_value',
));

$wp_customize->add_control(new Corporate_Solutions_Customize_Range_Control($wp_customize, 'corporate_solutions_page_header_image_height', array(
		'label'       => __('Image Height', 'corporate-solutions'),
		'section'     => 'corporate_solutions_page_title_options',
		'settings'    => 'corporate_solutions_page_header_image_height',
		'active_callback' => 'corporate_solutions_is_pagetitle_bcakground_image_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 1000,
			'step' => 5,
		),
)));


$wp_customize->add_setting('corporate_solutions_page_title_background_color_setting', array(
    'default' => '#f5f5f5',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'corporate_solutions_page_title_background_color_setting', array(
    'label' => __('Page Title Background Color', 'corporate-solutions'),
    'section' => 'corporate_solutions_page_title_options',
)));

$wp_customize->add_setting('corporate_solutions_pagetitle_height', array(
    'default'           => 50,
    'sanitize_callback' => 'corporate_solutions_sanitize_range_value',
));

$wp_customize->add_control(new Corporate_Solutions_Customize_Range_Control($wp_customize, 'corporate_solutions_pagetitle_height', array(
    'label'       => __('Set Height', 'corporate-solutions'),
    'description' => __('This setting controls the page title height when no background image is set. If a background image is set, this setting will not apply.', 'corporate-solutions'),
    'section'     => 'corporate_solutions_page_title_options',
    'settings'    => 'corporate_solutions_pagetitle_height',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 300,
        'step' => 5,
    ),
)));

$wp_customize->add_setting( 'corporate_solutions_page_title_style_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_page_title_style_separator', array(
	'label' => __( 'Page Title Styling Setting', 'corporate-solutions' ),
	'section' => 'corporate_solutions_page_title_options',
	'settings' => 'corporate_solutions_page_title_style_separator',
)));


$wp_customize->add_setting( 'corporate_solutions_page_header_heading_tag', array(
	'default'   => 'h1',
	'sanitize_callback' => 'corporate_solutions_sanitize_select',
) );

$wp_customize->add_control( 'corporate_solutions_page_header_heading_tag', array(
	'label'   => __( 'Page Title Heading Tag', 'corporate-solutions' ),
	'section' => 'corporate_solutions_page_title_options',
	'type'    => 'select',
	'choices' => array(
		'h1' => __( 'H1', 'corporate-solutions' ),
		'h2' => __( 'H2', 'corporate-solutions' ),
		'h3' => __( 'H3', 'corporate-solutions' ),
		'h4' => __( 'H4', 'corporate-solutions' ),
		'h5' => __( 'H5', 'corporate-solutions' ),
		'h6' => __( 'H6', 'corporate-solutions' ),
		'p' => __( 'p', 'corporate-solutions' ),
		'a' => __( 'a', 'corporate-solutions' ),
		'div' => __( 'div', 'corporate-solutions' ),
		'span' => __( 'span', 'corporate-solutions' ),
	),
) );



$wp_customize->add_setting('corporate_solutions_page_header_layout', array(
	'default' => 'left',
	'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('corporate_solutions_page_header_layout', array(
	'label' => __('Style', 'corporate-solutions'),
	'section' => 'corporate_solutions_page_title_options',
	'description' => __('"Flex Layout Style" wont work below 600px (mobile media)', 'corporate-solutions'),
	'settings' => 'corporate_solutions_page_header_layout',
	'type' => 'radio',
	'choices' => array(
		'left' => __('Classic', 'corporate-solutions'),
		'right' => __('Aligned Right', 'corporate-solutions'),
		'center' => __('Centered Focus', 'corporate-solutions'),
		'flex' => __('Flex Layout', 'corporate-solutions'),
	),
));
