<?php
/**
 * Footer Social Icons
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_footer_icon_options',
	array(
		'panel' => 'corporate_solutions_theme_options',
		'title' => esc_html__( 'Footer Social Icons', 'corporate-solutions' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_footer_icon_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_footer_icon_separators', array(
	'label' => __( 'Footer Icon Settings', 'corporate-solutions' ),
	'section' => 'corporate_solutions_footer_icon_options',
	'settings' => 'corporate_solutions_footer_icon_separators',
)));

// Footer Section - Enable Section.
$wp_customize->add_setting(
	'corporate_solutions_enable_footer_icon_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_footer_icon_section',
		array(
			'label'    => esc_html__( 'Show / Hide Footer Icon', 'corporate-solutions' ),
			'section'  => 'corporate_solutions_footer_icon_options',
			'settings' => 'corporate_solutions_enable_footer_icon_section',
		)
	)
);

// Add setting for Facebook Link
$wp_customize->add_setting(
	'corporate_solutions_footer_facebook_link',
	array(
		'default'           => 'https://www.facebook.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_facebook_link',
	array(
		'label'           => esc_html__( 'Facebook Link', 'corporate-solutions'  ),
		'section'         => 'corporate_solutions_footer_icon_options',
		'settings'        => 'corporate_solutions_footer_facebook_link',
		'type'      => 'url'
	)
);

// Add setting for Facebook Icon Changing
$wp_customize->add_setting(
	'corporate_solutions_facebook_icon',
	array(
        'default' => 'fab fa-facebook-f',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Corporate_Solutions_Change_Icon_Control($wp_customize, 
	'corporate_solutions_facebook_icon',
	array(
	    'label'   		=> __('Facebook Icon','corporate-solutions'),
	    'section' 		=> 'corporate_solutions_footer_icon_options',
		'iconset' => 'fb',
	))  
);


// Add setting for Twitter Link
$wp_customize->add_setting(
	'corporate_solutions_footer_twitter_link',
	array(
		'default'           => 'https://x.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_twitter_link',
	array(
		'label'           => esc_html__( 'Twitter Link', 'corporate-solutions'  ),
		'section'         => 'corporate_solutions_footer_icon_options',
		'settings'        => 'corporate_solutions_footer_twitter_link',
		'type'      => 'url'
	)
);

// Add setting for Twitter Icon Changing
$wp_customize->add_setting(
	'corporate_solutions_twitter_icon',
	array(
        'default' => 'fab fa-twitter',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Corporate_Solutions_Change_Icon_Control($wp_customize, 
	'corporate_solutions_twitter_icon',
	array(
	    'label'   		=> __('Twitter Icon','corporate-solutions'),
	    'section' 		=> 'corporate_solutions_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Instagram Link
$wp_customize->add_setting(
	'corporate_solutions_footer_instagram_link',
	array(
		'default'           => 'https://www.instagram.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_instagram_link',
	array(
		'label'           => esc_html__( 'Instagram Link', 'corporate-solutions'  ),
		'section'         => 'corporate_solutions_footer_icon_options',
		'settings'        => 'corporate_solutions_footer_instagram_link',
		'type'      => 'url'
	)
);

// Add setting for Instagram Icon Changing
$wp_customize->add_setting(
	'corporate_solutions_instagram_icon',
	array(
        'default' => 'fab fa-instagram',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Corporate_Solutions_Change_Icon_Control($wp_customize, 
	'corporate_solutions_instagram_icon',
	array(
	    'label'   		=> __('Instagram Icon','corporate-solutions'),
	    'section' 		=> 'corporate_solutions_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Linkedin Link
$wp_customize->add_setting(
	'corporate_solutions_footer_linkedin_link',
	array(
		'default'           => 'https://in.linkedin.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_linkedin_link',
	array(
		'label'           => esc_html__( 'Linkedin Link', 'corporate-solutions'  ),
		'section'         => 'corporate_solutions_footer_icon_options',
		'settings'        => 'corporate_solutions_footer_linkedin_link',
		'type'      => 'url'
	)
);

// Add setting for Linkedin Icon Changing
$wp_customize->add_setting(
	'corporate_solutions_linkedin_icon',
	array(
        'default' => 'fab fa-linkedin',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Corporate_Solutions_Change_Icon_Control($wp_customize, 
	'corporate_solutions_linkedin_icon',
	array(
	    'label'   		=> __('Linkedin Icon','corporate-solutions'),
	    'section' 		=> 'corporate_solutions_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Youtube Link
$wp_customize->add_setting(
	'corporate_solutions_footer_youtube_link',
	array(
		'default'           => 'https://www.youtube.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_youtube_link',
	array(
		'label'           => esc_html__( 'Youtube Link', 'corporate-solutions'  ),
		'section'         => 'corporate_solutions_footer_icon_options',
		'settings'        => 'corporate_solutions_footer_youtube_link',
		'type'      => 'url'
	)
);

// Add setting for Youtube Icon Changing
$wp_customize->add_setting(
	'corporate_solutions_youtube_icon',
	array(
        'default' => 'fab fa-youtube',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Corporate_Solutions_Change_Icon_Control($wp_customize, 
	'corporate_solutions_youtube_icon',
	array(
	    'label'   		=> __('Youtube Icon','corporate-solutions'),
	    'section' 		=> 'corporate_solutions_footer_icon_options',
		'iconset' => 'fb',
	))  
);

//Icon Alignment
$wp_customize->add_setting(
	'corporate_solutions_footer_social_align',
	array(
		'default' 			=> 'center',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_social_align',
	array(
		'label' => __('Icon Alignment ','corporate-solutions'),
		'section' => 'corporate_solutions_footer_icon_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','corporate-solutions'),
			'right' => __('Right','corporate-solutions'),
			'center' => __('Center','corporate-solutions'),
		),
	)
);