<?php

/**
 * Footer Options
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_footer_options',
	array(
		'panel' => 'corporate_solutions_theme_options',
		'title' => esc_html__( 'Footer Options', 'corporate-solutions' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_footer_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_footer_separators', array(
	'label' => __( 'Footer Settings', 'corporate-solutions' ),
	'section' => 'corporate_solutions_footer_options',
	'settings' => 'corporate_solutions_footer_separators',
)));

// Footer Section - Enable Section.
$wp_customize->add_setting(
	'corporate_solutions_enable_footer_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_footer_section',
		array(
			'label'    => esc_html__( 'Show / Hide Footer', 'corporate-solutions' ),
			'section'  => 'corporate_solutions_footer_options',
			'settings' => 'corporate_solutions_enable_footer_section',
		)
	)
);

// column // 
$wp_customize->add_setting(
	'corporate_solutions_footer_widget_column',
	array(
        'default'			=> '4',
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'corporate_solutions_sanitize_select',
		
	)
);	

$wp_customize->add_control(
	'corporate_solutions_footer_widget_column',
	array(
	    'label'   		=> __('Select Widget Column','corporate-solutions'),
		'description' => __('Note: Default footer widgets are shown. Add your preferred widgets in (Appearance > Widgets > Footer) to see changes.', 'corporate-solutions'),
	    'section' 		=> 'corporate_solutions_footer_options',
		'type'			=> 'select',
		'choices'        => 
		array(
			'' => __( 'None', 'corporate-solutions' ),
			'1' => __( '1 Column', 'corporate-solutions' ),
			'2' => __( '2 Column', 'corporate-solutions' ),
			'3' => __( '3 Column', 'corporate-solutions' ),
			'4' => __( '4 Column', 'corporate-solutions' )
		) 
	) 
);
//  BG Color // 
$wp_customize->add_setting('corporate_solutions_footer_background_color_setting', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'corporate_solutions_footer_background_color_setting', array(
    'label' => __('Footer Background Color', 'corporate-solutions'),
    'section' => 'corporate_solutions_footer_options',
)));

// Footer Background Image Setting
$wp_customize->add_setting('footer_background_image_setting', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_background_image_setting', array(
    'label' => __('Footer Background Image', 'corporate-solutions'),
    'section' => 'corporate_solutions_footer_options',
)));

$wp_customize->add_setting('footer_text_transform', array(
    'default' => 'none',
    'sanitize_callback' => 'sanitize_text_field',
));

// Footer Background Attachment
$wp_customize->add_setting(
	'corporate_solutions_footer_image_attachment_setting',
	array(
		'default'=> 'scroll',
		'sanitize_callback' => 'corporate_solutions_sanitize_choices'
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_image_attachment_setting',
	array(
		'type' => 'select',
		'label' => __('Footer Background Attatchment','corporate-solutions'),
		'choices' => array(
			'fixed' => __('fixed','corporate-solutions'),
			'scroll' => __('scroll','corporate-solutions'),
		),
		'section'=> 'corporate_solutions_footer_options',
  	)
);

// Add Footer Text Transform Control
$wp_customize->add_control('footer_text_transform', array(
    'label' => __('Footer Text Transform', 'corporate-solutions'),
    'section' => 'corporate_solutions_footer_options',
    'settings' => 'footer_text_transform',
    'type' => 'select',
    'choices' => array(
        'none' => __('None', 'corporate-solutions'),
        'capitalize' => __('Capitalize', 'corporate-solutions'),
        'uppercase' => __('Uppercase', 'corporate-solutions'),
        'lowercase' => __('Lowercase', 'corporate-solutions'),
    ),
));


// Footer Heading Alignment
$wp_customize->add_setting(
	'corporate_solutions_footer_header_align',
	array(
		'default' 			=> 'left',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_header_align',
	array(
		'label' => __('Footer Heading Alignment ','corporate-solutions'),
		'section' => 'corporate_solutions_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','corporate-solutions'),
			'right' => __('Right','corporate-solutions'),
			'center' => __('Center','corporate-solutions'),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_copyright_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_copyright_separators', array(
	'label' => __( 'Copyright Settings', 'corporate-solutions' ),
	'section' => 'corporate_solutions_footer_options',
	'settings' => 'corporate_solutions_copyright_separators',
)));

// Copyright Section - Enable Section.
$wp_customize->add_setting(
	'corporate_solutions_enable_copyright_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_copyright_section',
		array(
			'label'    => esc_html__( 'Show / Hide Copyright', 'corporate-solutions' ),
			'section'  => 'corporate_solutions_footer_options',
			'settings' => 'corporate_solutions_enable_copyright_section',
		)
	)
);

$wp_customize->add_setting(
	'corporate_solutions_footer_copyright_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses_post',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'corporate-solutions' ),
		'section'  => 'corporate_solutions_footer_options',
		'settings' => 'corporate_solutions_footer_copyright_text',
		'type'     => 'textarea',
	)
);

//Copyright Alignment
$wp_customize->add_setting(
	'corporate_solutions_footer_bottom_align',
	array(
		'default' 			=> 'center',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'corporate_solutions_footer_bottom_align',
	array(
		'label' => __('Copyright Alignment ','corporate-solutions'),
		'section' => 'corporate_solutions_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','corporate-solutions'),
			'right' => __('Right','corporate-solutions'),
			'center' => __('Center','corporate-solutions'),
		),
	)
);

//Copyright Font Size
$wp_customize->add_setting( 
	'corporate_solutions_copyright_font_size', 
	array(
		'default'           => 16,
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control( 'corporate_solutions_copyright_font_size', 
	array(
		'type'        => 'number',
		'section'     => 'corporate_solutions_footer_options',
		'label'       => __( 'Copyright Font Size ', 'corporate-solutions' ),
		'input_attrs' => 
		array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'corporate_solutions_scroll_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Corporate_Solutions_Separator_Custom_Control( $wp_customize, 'corporate_solutions_scroll_separators', array(
	'label' => __( 'Scroll Top Settings', 'corporate-solutions' ),
	'section' => 'corporate_solutions_footer_options',
	'settings' => 'corporate_solutions_scroll_separators',
)));


// Footer Options - Scroll Top.
$wp_customize->add_setting(
	'corporate_solutions_scroll_top',
	array(
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_scroll_top',
		array(
			'label'   => esc_html__( 'Enable Scroll Top Button', 'corporate-solutions' ),
			'section' => 'corporate_solutions_footer_options',
		)
	)
);
// icon // 
$wp_customize->add_setting(
	'corporate_solutions_scroll_btn_icon',
	array(
        'default' => 'fas fa-chevron-up',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Corporate_Solutions_Change_Icon_Control($wp_customize, 
	'corporate_solutions_scroll_btn_icon',
	array(
	    'label'   		=> __('Scroll Top Icon','corporate-solutions'),
	    'section' 		=> 'corporate_solutions_footer_options',
		'iconset' => 'fa',
	))  
);
$wp_customize->add_setting( 'corporate_solutions_scroll_top_position', array(
    'default'           => 'bottom-right',
    'sanitize_callback' => 'corporate_solutions_sanitize_scroll_top_position',
) );

// Add control for Scroll Top Button Position
$wp_customize->add_control( 'corporate_solutions_scroll_top_position', array(
    'label'    => __( 'Scroll Top Button Position', 'corporate-solutions' ),
    'section'  => 'corporate_solutions_footer_options',
    'settings' => 'corporate_solutions_scroll_top_position',
    'type'     => 'select',
    'choices'  => array(
        'bottom-right' => __( 'Bottom Right', 'corporate-solutions' ),
        'bottom-left'  => __( 'Bottom Left', 'corporate-solutions' ),
        'bottom-center'=> __( 'Bottom Center', 'corporate-solutions' ),
    ),
) );

$wp_customize->add_setting( 'corporate_solutions_scroll_top_shape', array(
	'default'           => 'box',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'corporate_solutions_scroll_top_shape', array(
	'label'    => __( 'Scroll to Top Button Shape', 'corporate-solutions' ),
	'section'  => 'corporate_solutions_footer_options',
	'settings' => 'corporate_solutions_scroll_top_shape',
	'type'     => 'radio',
	'choices'  => array(
		'box'        => __( 'Box', 'corporate-solutions' ),
		'curved-box' => __( 'Curved Box', 'corporate-solutions' ),
		'circle'     => __( 'Circle', 'corporate-solutions' ),
	),
) );