<?php

/**
 * Excerpt
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_excerpt_options',
	array(
		'panel' => 'corporate_solutions_theme_options',
		'title' => esc_html__( 'Excerpt', 'corporate-solutions' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'corporate_solutions_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'absint',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'corporate_solutions_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'corporate-solutions' ),
		'section'     => 'corporate_solutions_excerpt_options',
		'settings'    => 'corporate_solutions_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 10,
			'max'  => 200,
			'step' => 1,
		),
	)
);