<?php

function corporate_solutions_sanitize_select( $corporate_solutions_input, $corporate_solutions_setting ) {
	$corporate_solutions_input = sanitize_key( $corporate_solutions_input );
	$corporate_solutions_choices = $corporate_solutions_setting->manager->get_control( $corporate_solutions_setting->id )->choices;
	return ( array_key_exists( $corporate_solutions_input, $corporate_solutions_choices ) ? $corporate_solutions_input : $corporate_solutions_setting->default );
}

function corporate_solutions_sanitize_switch( $corporate_solutions_input ) {
	if ( true === $corporate_solutions_input ) {
		return true;
	} else {
		return false;
	}
}

function corporate_solutions_sanitize_google_fonts( $corporate_solutions_input, $corporate_solutions_setting ) {
	$corporate_solutions_choices = $corporate_solutions_setting->manager->get_control( $corporate_solutions_setting->id )->choices;
	return ( array_key_exists( $corporate_solutions_input, $corporate_solutions_choices ) ? $corporate_solutions_input : $corporate_solutions_setting->default );
}

/**
 * Sanitize HTML input.
 *
 * @param string $corporate_solutions_input HTML input to sanitize.
 * @return string Sanitized HTML.
 */
function corporate_solutions_sanitize_html( $corporate_solutions_input ) {
    return wp_kses_post( $corporate_solutions_input );
}

/**
 * Sanitize URL input.
 *
 * @param string $corporate_solutions_input URL input to sanitize.
 * @return string Sanitized URL.
 */
function corporate_solutions_sanitize_url( $corporate_solutions_input ) {
    return esc_url_raw( $corporate_solutions_input );
}

// Sanitize Scroll Top Position
function corporate_solutions_sanitize_scroll_top_position( $corporate_solutions_input ) {
    $corporate_solutions_valid_positions = array( 'bottom-right', 'bottom-left', 'bottom-center' );
    if ( in_array( $corporate_solutions_input, $corporate_solutions_valid_positions ) ) {
        return $corporate_solutions_input;
    } else {
        return 'bottom-right'; // Default to bottom-right if invalid value
    }
}
function corporate_solutions_sanitize_choices( $corporate_solutions_input, $corporate_solutions_setting ) {
    global $wp_customize; 
    $corporate_solutions_control = $wp_customize->get_control( $corporate_solutions_setting->id ); 
    if ( array_key_exists( $corporate_solutions_input, $corporate_solutions_control->choices ) ) {
        return $corporate_solutions_input;
    } else {
        return $corporate_solutions_setting->default;
    }
}

function corporate_solutions_sanitize_range_value( $corporate_solutions_number, $corporate_solutions_setting ) {

	// Ensure input is an absolute integer.
	$corporate_solutions_number = absint( $corporate_solutions_number );

	// Get the input attributes associated with the setting.
	$corporate_solutions_atts = $corporate_solutions_setting->manager->get_control( $corporate_solutions_setting->id )->input_attrs;

	// Get minimum number in the range.
	$corporate_solutions_min = ( isset( $corporate_solutions_atts['min'] ) ? $corporate_solutions_atts['min'] : $corporate_solutions_number );

	// Get maximum number in the range.
	$corporate_solutions_max = ( isset( $corporate_solutions_atts['max'] ) ? $corporate_solutions_atts['max'] : $corporate_solutions_number );

	// Get step.
	$corporate_solutions_step = ( isset( $corporate_solutions_atts['step'] ) ? $corporate_solutions_atts['step'] : 1 );

	// If the number is within the valid range, return it; otherwise, return the default.
	return ( $corporate_solutions_min <= $corporate_solutions_number && $corporate_solutions_number <= $corporate_solutions_max && is_int( $corporate_solutions_number / $corporate_solutions_step ) ? $corporate_solutions_number : $corporate_solutions_setting->default );
}