<?php

/**
 * Services Section
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_service_section',
	array(
		'panel'    => 'corporate_solutions_front_page_options',
		'title'    => esc_html__( 'Services Section', 'corporate-solutions' ),
		'priority' => 10,
	)
);

//Service Section - Enable Section.
$wp_customize->add_setting(
	'corporate_solutions_enable_service_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_service_section',
		array(
			'label'    => esc_html__( 'Enable Service Section', 'corporate-solutions' ),
			'section'  => 'corporate_solutions_service_section',
			'settings' => 'corporate_solutions_enable_service_section'
		)
	)
);

// Services Options - Heading.
$wp_customize->add_setting(
	'corporate_solutions_services_section_heading',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'corporate_solutions_services_section_heading',
	array(
		'label'           => esc_html__( 'Services Heading', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_service_section',
		'active_callback' => 'corporate_solutions_is_service_section_enabled',
		'type'            => 'text',
	)
);

// Services Options - Text.
$wp_customize->add_setting(
	'corporate_solutions_services_section_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'corporate_solutions_services_section_text',
	array(
		'label'           => esc_html__( 'Services Text', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_service_section',
		'active_callback' => 'corporate_solutions_is_service_section_enabled',
		'type'            => 'text',
	)
);

// Services Options - Button Text.
$wp_customize->add_setting(
	'corporate_solutions_services_section_button_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'corporate_solutions_services_section_button_text',
	array(
		'label'           => esc_html__( 'Services Button Text', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_service_section',
		'active_callback' => 'corporate_solutions_is_service_section_enabled',
		'type'            => 'text',
	)
);

// Services Options - Button Link.
$wp_customize->add_setting(
	'corporate_solutions_services_section_button_link',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'corporate_solutions_services_section_button_link',
	array(
		'label'           => esc_html__( 'Services Button Link', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_service_section',
		'active_callback' => 'corporate_solutions_is_service_section_enabled',
		'type'            => 'url',
	)
);

// Services Options - Image.

$wp_customize->add_setting('corporate_solutions_services_section_image', 
	array(
	    'default'           => get_template_directory_uri().'/resource/img/service.png',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control( 
	new WP_Customize_Image_Control( 
		$wp_customize, 'corporate_solutions_services_section_image', 
		array(
		    'label' => 'Services Image',
		    'active_callback' => 'corporate_solutions_is_service_section_enabled',
		    'section'   => 'corporate_solutions_service_section'
		) 
	)
);

// Services Section - Content Type.
$wp_customize->add_setting(
	'corporate_solutions_service_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'corporate_solutions_sanitize_select',
	)
);

$wp_customize->add_control(
	'corporate_solutions_service_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_service_section',
		'settings'        => 'corporate_solutions_service_content_type',
		'type'            => 'select',
		'active_callback' => 'corporate_solutions_is_service_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'corporate-solutions' ),
			'post' => esc_html__( 'Post', 'corporate-solutions' ),
		),
	)
);


// Services Category Setting.
$wp_customize->add_setting('corporate_solutions_services_category', array(
	'default'           => 'services',
	'sanitize_callback' => 'sanitize_text_field',
));

// Add custom control for Services Category with conditional visibility.
$wp_customize->add_control(new Corporate_Solutions_Customize_Category_Dropdown_Control($wp_customize, 'corporate_solutions_services_category', array(
	'label'    => __('Select Services Category', 'corporate-solutions'),
	'section'  => 'corporate_solutions_service_section',
	'settings' => 'corporate_solutions_services_category',
	'active_callback' => function() use ($wp_customize) {
		return $wp_customize->get_setting('corporate_solutions_service_content_type')->value() === 'post';
	},
)));


for ( $corporate_solutions_i = 1; $corporate_solutions_i <= 6; $corporate_solutions_i++ ) {

	// Service Section - Select Post.
	$wp_customize->add_setting(
		'corporate_solutions_service_content_post_' . $corporate_solutions_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'corporate_solutions_service_content_post_' . $corporate_solutions_i,
		array(
			'label'           => esc_html__( 'Select Post ', 'corporate-solutions' ) . $corporate_solutions_i,
			'section'         => 'corporate_solutions_service_section',
			'settings'        => 'corporate_solutions_service_content_post_' . $corporate_solutions_i,
			'active_callback' => 'corporate_solutions_is_service_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => corporate_solutions_get_post_choices(),
		)
	);

	// Service Section - Select Page.
	$wp_customize->add_setting(
		'corporate_solutions_service_content_page_' . $corporate_solutions_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'corporate_solutions_service_content_page_' . $corporate_solutions_i,
		array(
			'label'           => esc_html__( 'Select Page ', 'corporate-solutions' ) . $corporate_solutions_i,
			'section'         => 'corporate_solutions_service_section',
			'settings'        => 'corporate_solutions_service_content_page_' . $corporate_solutions_i,
			'active_callback' => 'corporate_solutions_is_service_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => corporate_solutions_get_page_choices(),
		)
	);
}