<?php

/**
 * Banner Section
 *
 * @package corporate_solutions
 */

$wp_customize->add_section(
	'corporate_solutions_banner_section',
	array(
		'panel'    => 'corporate_solutions_front_page_options',
		'title'    => esc_html__( 'Banner Section', 'corporate-solutions' ),
		'priority' => 10,
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'corporate_solutions_enable_banner_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'corporate_solutions_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Corporate_Solutions_Toggle_Switch_Custom_Control(
		$wp_customize,
		'corporate_solutions_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'corporate-solutions' ),
			'section'  => 'corporate_solutions_banner_section',
			'settings' => 'corporate_solutions_enable_banner_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'corporate_solutions_enable_banner_section',
		array(
			'selector' => '#corporate_solutions_banner_section .section-link',
			'settings' => 'corporate_solutions_enable_banner_section',
		)
	);
}

// Banner Section - Banner Slider Content Type.
$wp_customize->add_setting(
	'corporate_solutions_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'corporate_solutions_sanitize_select',
	)
);

$wp_customize->add_control(
	'corporate_solutions_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Select Banner Slider Content Type', 'corporate-solutions' ),
		'section'         => 'corporate_solutions_banner_section',
		'settings'        => 'corporate_solutions_banner_slider_content_type',
		'type'            => 'select',
		'active_callback' => 'corporate_solutions_is_banner_slider_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'corporate-solutions' ),
			'post' => esc_html__( 'Post', 'corporate-solutions' ),
		),
	)
);


// Banner Slider Category Setting.
$wp_customize->add_setting('corporate_solutions_banner_slider_category', array(
	'default'           => 'banner',
	'sanitize_callback' => 'sanitize_text_field',
));

// Add custom control for Banner Slider Category with conditional visibility.
$wp_customize->add_control(new Corporate_Solutions_Customize_Category_Dropdown_Control($wp_customize, 'corporate_solutions_banner_slider_category', array(
	'label'    => __('Select Banner Category', 'corporate-solutions'),
	'section'  => 'corporate_solutions_banner_section',
	'settings' => 'corporate_solutions_banner_slider_category',
	'active_callback' => function() use ($wp_customize) {
		return $wp_customize->get_setting('corporate_solutions_banner_slider_content_type')->value() === 'post';
	},
)));

for ( $corporate_solutions_i = 1; $corporate_solutions_i <= 3; $corporate_solutions_i++ ) {

	// Banner Section - Select Banner Post.
	$wp_customize->add_setting(
		'corporate_solutions_banner_slider_content_post_' . $corporate_solutions_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'corporate_solutions_banner_slider_content_post_' . $corporate_solutions_i,
		array(
			/* translators: %d: Post Count. */
			'label'           => sprintf( esc_html__( 'Select Post %d', 'corporate-solutions' ), $corporate_solutions_i ),
			'description'     => sprintf( esc_html__( 'Kindly :- Select a Post based on the category selected in the upper settings', 'corporate-solutions' ), $corporate_solutions_i ),
			'section'         => 'corporate_solutions_banner_section',
			'settings'        => 'corporate_solutions_banner_slider_content_post_' . $corporate_solutions_i,
			'active_callback' => 'corporate_solutions_is_banner_slider_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => corporate_solutions_get_post_choices(),
		)
	);

	// Banner Section - Select Banner Page.
	$wp_customize->add_setting(
		'corporate_solutions_banner_slider_content_page_' . $corporate_solutions_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'corporate_solutions_banner_slider_content_page_' . $corporate_solutions_i,
		array(
			/* translators: %d: Page Count. */
			'label'           => sprintf( esc_html__( 'Select Page %d', 'corporate-solutions' ), $corporate_solutions_i ),
			'section'         => 'corporate_solutions_banner_section',
			'settings'        => 'corporate_solutions_banner_slider_content_page_' . $corporate_solutions_i,
			'active_callback' => 'corporate_solutions_is_banner_slider_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => corporate_solutions_get_page_choices(),
		)
	);

	// Banner Section - Button Label.
	$wp_customize->add_setting(
		'corporate_solutions_banner_button_label_' . $corporate_solutions_i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'corporate_solutions_banner_button_label_' . $corporate_solutions_i,
		array(
			/* translators: %d: Button Label Count. */
			'label'           => sprintf( esc_html__( 'Button Label %d', 'corporate-solutions' ), $corporate_solutions_i ),
			'section'         => 'corporate_solutions_banner_section',
			'settings'        => 'corporate_solutions_banner_button_label_' . $corporate_solutions_i,
			'type'            => 'text',
			'active_callback' => 'corporate_solutions_is_banner_slider_section_enabled',
		)
	);

	// Banner Section - Button Link.
	$wp_customize->add_setting(
		'corporate_solutions_banner_button_link_' . $corporate_solutions_i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'corporate_solutions_banner_button_link_' . $corporate_solutions_i,
		array(
			/* translators: %d: Button Link Count. */
			'label'           => sprintf( esc_html__( 'Button Link %d', 'corporate-solutions' ), $corporate_solutions_i ),
			'section'         => 'corporate_solutions_banner_section',
			'settings'        => 'corporate_solutions_banner_button_link_' . $corporate_solutions_i,
			'type'            => 'url',
			'active_callback' => 'corporate_solutions_is_banner_slider_section_enabled',
		)
	);
}