<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package corporate_solutions
 */

function corporate_solutions_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'corporate_solutions_custom_header_args', array(
		'default-text-color'     => 'fff',
		'header-text' 			 =>	false,
		'width'                  => 1360,
		'height'                 => 110,
		'flex-width'         	 => true,
        'flex-height'        	 => true,
		'wp-head-callback'       => 'corporate_solutions_header_style',
	) ) );
}

add_action( 'after_setup_theme', 'corporate_solutions_custom_header_setup' );

if ( ! function_exists( 'corporate_solutions_header_style' ) ) :

add_action( 'wp_enqueue_scripts', 'corporate_solutions_header_style' );
function corporate_solutions_header_style() {

	if ( get_header_image() ) :
		$corporate_solutions_custom_css = "
        .header-background-image {
            background-image: url('".esc_url(get_header_image())."') !important;
            background-position: center;
            background-size: cover;
            height: 200px; /* Your custom height */
        }
        .header-main-wrapper {
            position: absolute;
            width: 100%;
            z-index: 9999;
            padding-top: 20px;
        }
		@media only screen and (max-width: 600px) {
			.header-background-image {
				display:none;
			}
			.header-main-wrapper {
				position: relative;
			}
		}
		";
	   	wp_add_inline_style( 'corporate-solutions-style', $corporate_solutions_custom_css );
	endif;
}
endif;