<?php

if ( ! get_theme_mod( 'corporate_solutions_enable_service_section', false ) ) {
	return;
}

$corporate_solutions_content_ids  = array();
$corporate_solutions_content_type = get_theme_mod( 'corporate_solutions_service_content_type', 'post' );

for ( $corporate_solutions_i = 1; $corporate_solutions_i <= 6; $corporate_solutions_i++ ) {
	$corporate_solutions_content_ids[] = get_theme_mod( 'corporate_solutions_service_content_' . $corporate_solutions_content_type . '_' . $corporate_solutions_i );
}

// Get the category for the services slider from theme mods or a default category
$corporate_solutions_services_category = get_theme_mod('corporate_solutions_services_category', 'services');

// Modify query to fetch posts from a specific category
$corporate_solutions_service_args = array(
    'post_type'           => $corporate_solutions_content_type,
    'post__in'            => array_filter( $corporate_solutions_content_ids ),
    'orderby'             => 'post__in',
    'posts_per_page'      => absint(8),
    'ignore_sticky_posts' => true,
);

// Apply category filter only if content type is 'post'
if ( 'post' === $corporate_solutions_content_type && ! empty( $corporate_solutions_services_category ) ) {
    $corporate_solutions_service_args['category_name'] = $corporate_solutions_services_category;
}

$corporate_solutions_service_args = apply_filters( 'corporate_solutions_service_section_args', $corporate_solutions_service_args );

corporate_solutions_render_service_section( $corporate_solutions_service_args );

/**
 * Render Service Section.
 */
function corporate_solutions_render_service_section( $corporate_solutions_service_args ) { ?>

	<section id="corporate_solutions_service_section" class="asterthemes-frontpage-section service-section service-style-1">
		<?php
		if ( is_customize_preview() ) :
			corporate_solutions_section_link( 'corporate_solutions_service_section' );
		endif;
		?>
		<div class="asterthemes-wrapper">
			<div class="services-part-wrapper">
				<div class="services-left-part">
					<?php 
						$corporate_solutions_services_section_heading = get_theme_mod( 'corporate_solutions_services_section_heading');
						$corporate_solutions_services_section_text = get_theme_mod( 'corporate_solutions_services_section_text');
						$corporate_solutions_services_section_button_text = get_theme_mod( 'corporate_solutions_services_section_button_text');
						$corporate_solutions_services_section_button_link = get_theme_mod( 'corporate_solutions_services_section_button_link');
						$corporate_solutions_services_section_image = get_theme_mod( 'corporate_solutions_services_section_image',get_template_directory_uri().'/resource/img/service.png');
					?>
					<?php if ( ! empty( $corporate_solutions_services_section_heading ) ) { ?>
						<h3>
							<?php echo esc_html( $corporate_solutions_services_section_heading ); ?>
						</h3>
					<?php } ?>
					<?php if ( ! empty( $corporate_solutions_services_section_text ) ) { ?>
						<p>
							<?php echo esc_html( $corporate_solutions_services_section_text ); ?>
						</p>
					<?php } ?>
					<?php if ( ! empty( $corporate_solutions_services_section_button_text ) ) { ?>
						<a class="asterthemes-button" href="<?php echo esc_url( $corporate_solutions_services_section_button_link ); ?>"><?php echo esc_html( $corporate_solutions_services_section_button_text ); ?></a>
					<?php } ?>
				</div>
				<div class="services-middle-part">
					<img src="<?php echo esc_url( $corporate_solutions_services_section_image ); ?>">
				</div>
			</div>
			<div class="video-main-box">
				<?php 
				$corporate_solutions_query = new WP_Query( $corporate_solutions_service_args );
				if ( $corporate_solutions_query->have_posts() ) :
					?>
					<div class="section-body">
						<div class="service-section-wrapper">
							<?php
							$corporate_solutions_i = 1;
							while ( $corporate_solutions_query->have_posts() ) :
								$corporate_solutions_query->the_post();
								?>
								<div class="service-single">
									<div class="service-image">
										<?php the_post_thumbnail( 'full' ); ?>
									</div>
									<div class="service-title">
										<h3>
											<a href="<?php the_permalink(); ?>">
												<?php the_title(); ?>
											</a>
										</h3>
										<p>
											<?php echo wp_kses_post( wp_trim_words( get_the_content(), 10 ) ); ?>
										</p>
									</div>
								</div>
								<?php
								$corporate_solutions_i++;
							endwhile;
							wp_reset_postdata();
							?>
						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<?php
}