<?php
if ( ! get_theme_mod( 'corporate_solutions_enable_banner_section', false ) ) {
	return;
}

$corporate_solutions_slider_content_ids  = array();
$corporate_solutions_slider_content_type = get_theme_mod( 'corporate_solutions_banner_slider_content_type', 'post' );

for ( $corporate_solutions_i = 1; $corporate_solutions_i <= 3; $corporate_solutions_i++ ) {
	$corporate_solutions_slider_content_ids[] = get_theme_mod( 'corporate_solutions_banner_slider_content_' . $corporate_solutions_slider_content_type . '_' . $corporate_solutions_i );
}

// Get the category for the banner slider from theme mods or a default category
$corporate_solutions_banner_slider_category = get_theme_mod('corporate_solutions_banner_slider_category', 'Banner');

// Modify query to fetch posts from a specific category
$corporate_solutions_banner_slider_args = array(
    'post_type'           => $corporate_solutions_slider_content_type,
    'post__in'            => array_filter( $corporate_solutions_slider_content_ids ),
    'orderby'             => 'post__in',
    'posts_per_page'      => absint(3),
    'ignore_sticky_posts' => true,
);

// Apply category filter only if content type is 'post'
if ( 'post' === $corporate_solutions_slider_content_type && ! empty( $corporate_solutions_banner_slider_category ) ) {
    $corporate_solutions_banner_slider_args['category_name'] = $corporate_solutions_banner_slider_category;
}

$corporate_solutions_banner_slider_args = apply_filters( 'corporate_solutions_banner_section_args', $corporate_solutions_banner_slider_args );

corporate_solutions_render_banner_section( $corporate_solutions_banner_slider_args );

/**
 * Render Banner Section.
 */
function corporate_solutions_render_banner_section( $corporate_solutions_banner_slider_args ) {     ?>

	<section id="corporate_solutions_banner_section" class="banner-section banner-style-1">
		<?php
		if ( is_customize_preview() ) :
			corporate_solutions_section_link( 'corporate_solutions_banner_section' );
		endif;
		?>
		<div class="banner-section-wrapper">
			<?php
			$corporate_solutions_query = new WP_Query( $corporate_solutions_banner_slider_args );
			if ( $corporate_solutions_query->have_posts() ) :
				?>
				<div class="asterthemes-banner-wrapper banner-slider corporate-solutions-carousel-navigation" data-slick='{"autoplay": false }'>
					<?php
					$corporate_solutions_i = 1;
					while ( $corporate_solutions_query->have_posts() ) :
						$corporate_solutions_query->the_post();
						$corporate_solutions_button_label = get_theme_mod( 'corporate_solutions_banner_button_label_' . $corporate_solutions_i);
						$corporate_solutions_button_link  = get_theme_mod( 'corporate_solutions_banner_button_link_' . $corporate_solutions_i);
						$corporate_solutions_button_link  = ! empty( $corporate_solutions_button_link ) ? $corporate_solutions_button_link : get_the_permalink();
						?>
						<div class="banner-single-outer">
							<div class="banner-single">
								<div class="banner-img">
									<?php the_post_thumbnail( 'full' ); ?>
								</div>
								<div class="banner-caption">
									<div class="asterthemes-wrapper">
										<div class="banner-catption-wrapper">
											<h1 class="banner-caption-title">
												<?php the_title(); ?>
											</h1>
											<?php if ( ! empty( $corporate_solutions_button_label ) ) { ?>
												<div class="banner-slider-btn">
													<a href="<?php echo esc_url( $corporate_solutions_button_link ); ?>" class="asterthemes-button"><?php echo esc_html( $corporate_solutions_button_label ); ?></a>
												</div>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php
						$corporate_solutions_i++;
					endwhile;
					wp_reset_postdata();
					?>
				</div>
				<?php
			endif;
			?>
		</div>
	</section>

	<?php
}