<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! corporate_solutions_has_page_header() ) {
    return;
}

$corporate_solutions_classes = array( 'page-header' );
$corporate_solutions_style = corporate_solutions_page_header_style();

if ( $corporate_solutions_style ) {
    $corporate_solutions_classes[] = $corporate_solutions_style . '-page-header';
}

$corporate_solutions_visibility = get_theme_mod( 'corporate_solutions_page_header_visibility', 'all-devices' );

if ( 'hide-all-devices' === $corporate_solutions_visibility ) {
    // Don't show the header at all
    return;
}

if ( 'hide-tablet' === $corporate_solutions_visibility ) {
    $corporate_solutions_classes[] = 'hide-on-tablet';
} elseif ( 'hide-mobile' === $corporate_solutions_visibility ) {
    $corporate_solutions_classes[] = 'hide-on-mobile';
} elseif ( 'hide-tablet-mobile' === $corporate_solutions_visibility ) {
    $corporate_solutions_classes[] = 'hide-on-tablet-mobile';
}

$corporate_solutions_PAGE_TITLE_background_color = get_theme_mod('corporate_solutions_page_title_background_color_setting', '');

// Get the toggle switch value
$corporate_solutions_background_image_enabled = get_theme_mod('corporate_solutions_page_header_style', true);

// Add background image to the header if enabled
$corporate_solutions_background_image = get_theme_mod( 'corporate_solutions_page_header_background_image', '' );
$corporate_solutions_background_height = get_theme_mod( 'corporate_solutions_page_header_image_height', '200' );
$corporate_solutions_inline_style = '';

if ( $corporate_solutions_background_image_enabled && ! empty( $corporate_solutions_background_image ) ) {
    $corporate_solutions_inline_style .= 'background-image: url(' . esc_url( $corporate_solutions_background_image ) . '); ';
    $corporate_solutions_inline_style .= 'height: ' . esc_attr( $corporate_solutions_background_height ) . 'px; ';
    $corporate_solutions_inline_style .= 'background-size: cover; ';
    $corporate_solutions_inline_style .= 'background-position: center center; ';

    // Add the unique class if the background image is set
    $corporate_solutions_classes[] = 'has-background-image';
}

$corporate_solutions_classes = implode( ' ', $corporate_solutions_classes );
$corporate_solutions_heading = get_theme_mod( 'corporate_solutions_page_header_heading_tag', 'h1' );
$corporate_solutions_heading = apply_filters( 'corporate_solutions_page_header_heading', $corporate_solutions_heading );

?>

<?php do_action( 'corporate_solutions_before_page_header' ); ?>

<header class="<?php echo esc_attr( $corporate_solutions_classes ); ?>" style="<?php echo esc_attr( $corporate_solutions_inline_style ); ?> background-color: <?php echo esc_attr($corporate_solutions_PAGE_TITLE_background_color); ?>;">

    <?php do_action( 'corporate_solutions_before_page_header_inner' ); ?>

    <div class="asterthemes-wrapper page-header-inner">

        <?php if ( corporate_solutions_has_page_header() ) : ?>

            <<?php echo esc_attr( $corporate_solutions_heading ); ?> class="page-header-title">
                <?php echo wp_kses_post( corporate_solutions_get_page_title() ); ?>
            </<?php echo esc_attr( $corporate_solutions_heading ); ?>>

        <?php endif; ?>

        <?php if ( function_exists( 'corporate_solutions_breadcrumb' ) ) : ?>
            <?php corporate_solutions_breadcrumb(); ?>
        <?php endif; ?>

    </div><!-- .page-header-inner -->

    <?php do_action( 'corporate_solutions_after_page_header_inner' ); ?>

</header><!-- .page-header -->

<?php do_action( 'corporate_solutions_after_page_header' ); ?>