<?php
/**
 * Corporate Solutions functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package corporate_solutions
 */

if ( ! defined( 'CORPORATE_SOLUTIONS_VERSION' ) ) {
	define( 'CORPORATE_SOLUTIONS_VERSION', '1.0.0' );
}
$corporate_solutions_theme_data = wp_get_theme();

if( ! defined( 'CORPORATE_SOLUTIONS_THEME_VERSION' ) ) define ( 'CORPORATE_SOLUTIONS_THEME_VERSION', $corporate_solutions_theme_data->get( 'Version' ) );
if( ! defined( 'CORPORATE_SOLUTIONS_THEME_NAME' ) ) define( 'CORPORATE_SOLUTIONS_THEME_NAME', $corporate_solutions_theme_data->get( 'Name' ) );

if ( ! function_exists( 'corporate_solutions_setup' ) ) :
	
	function corporate_solutions_setup() {
		
		load_theme_textdomain( 'corporate-solutions', get_template_directory() . '/languages' );

		add_theme_support( 'automatic-feed-links' );
		
		add_theme_support( 'title-tag' );

		add_theme_support( 'woocommerce' );

		add_theme_support( 'post-thumbnails' );

		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary', 'corporate-solutions' ),
			)
		);

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'woocommerce',
			)
		);

		add_theme_support( 'post-formats', array(
			'image',
			'video',
			'gallery',
			'audio', 
		) );

		add_theme_support(
			'custom-background',
			apply_filters(
				'corporate_solutions_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'corporate_solutions_setup' );

function corporate_solutions_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'corporate_solutions_content_width', 640 );
}
add_action( 'after_setup_theme', 'corporate_solutions_content_width', 0 );

function corporate_solutions_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'corporate-solutions' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'corporate-solutions' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
	);

	// Regsiter 4 footer widgets.
	$corporate_solutions_footer_widget_column = get_theme_mod('corporate_solutions_footer_widget_column','4');
	for ($i=1; $i<=$corporate_solutions_footer_widget_column; $i++) {
		register_sidebar( array(
			'name' => __( 'Footer  ', 'corporate-solutions' )  . $i,
			'id' => 'corporate-solutions-footer-widget-' . $i,
			'description' => __( 'The Footer Widget Area', 'corporate-solutions' )  . $i,
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="widget-header"><h4 class="widget-title">',
			'after_title' => '</h4></div>',
		) );
	}
}
add_action( 'widgets_init', 'corporate_solutions_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function corporate_solutions_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	// Slick style.
	wp_enqueue_style( 'slick-style', get_template_directory_uri() . '/resource/css/slick' . $min . '.css', array(), '1.8.1' );

	// Fontawesome style.
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri())."/resource/css/fontawesome-all.css" );

	// Main style.
	wp_enqueue_style( 'corporate-solutions-style', get_template_directory_uri() . '/style.css', array(), CORPORATE_SOLUTIONS_VERSION );

	// Animate CSS
	wp_enqueue_style( 'animate-style', get_template_directory_uri() . '/resource/css/animate.css' );

	// Navigation script.
	wp_enqueue_script( 'corporate-solutions-navigation-script', get_template_directory_uri() . '/resource/js/navigation' . $min . '.js', array(), CORPORATE_SOLUTIONS_VERSION, true );

	// Slick script.
	wp_enqueue_script( 'slick-script', get_template_directory_uri() . '/resource/js/slick' . $min . '.js', array( 'jquery' ), '1.8.1', true );

	// Wow script.
	wp_enqueue_script( 'wow-jquery', get_template_directory_uri() . '/resource/js/wow.js', array('jquery'),'' ,true );

	// Custom script.
	wp_enqueue_script( 'corporate-solutions-custom-script', get_template_directory_uri() . '/resource/js/custom.js', array( 'jquery' ), CORPORATE_SOLUTIONS_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// Include the file.
	require_once get_theme_file_path( 'theme-library/function-files/wptt-webfont-loader.php' );

	// Load the webfont.
	wp_enqueue_style(
		'mulish',
		wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Mulish:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;0,1000;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900;1,1000&display=swap' ),
		array(),
		'1.0'
	);
}
add_action( 'wp_enqueue_scripts', 'corporate_solutions_scripts' );

function corporate_solutions_enqueuing_admin_scripts(){
    wp_enqueue_style('block-editor-admin', get_template_directory_uri().'/resource/css/block-editor-admin.css');
}
add_action( 'admin_enqueue_scripts', 'corporate_solutions_enqueuing_admin_scripts' );

//Change number of products per page 
add_filter( 'loop_shop_per_page', 'corporate_solutions_products_per_page' );
function corporate_solutions_products_per_page( $cols ) {
  	return  get_theme_mod( 'corporate_solutions_products_per_page',9);
}

// Change number or products per row 
add_filter('loop_shop_columns', 'corporate_solutions_loop_columns');
	if (!function_exists('corporate_solutions_loop_columns')) {
	function corporate_solutions_loop_columns() {
		return get_theme_mod( 'corporate_solutions_products_per_row', 3 );
	}
}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/theme-library/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/theme-library/function-files/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/theme-library/function-files/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/theme-library/customizer.php';

/**
 * Breadcrumb
 */
require get_template_directory() . '/theme-library/function-files/class-breadcrumb-trail.php';

/**
 * Getting Started
*/
require get_template_directory() . '/theme-library/getting-started/getting-started.php';

/**
 * Google Fonts
 */
require get_template_directory() . '/theme-library/function-files/google-fonts.php';

/**
 * Dynamic CSS
 */
require get_template_directory() . '/theme-library/dynamic-css.php';

/**
 * Demo Import
*/
add_action( 'init', 'corporate_solutions_load_theme_wizard' );
function corporate_solutions_load_theme_wizard() {
    require get_parent_theme_file_path( '/theme-wizard/config.php' );
}

function corporate_solutions_links_setup() {
	if ( ! defined( 'CORPORATE_SOLUTIONS_PREMIUM_PAGE' ) ) {
	define('CORPORATE_SOLUTIONS_PREMIUM_PAGE',__('https://asterthemes.com/products/corporate-wordpress-theme','corporate-solutions'));
	}
	if ( ! defined( 'CORPORATE_SOLUTIONS_THEME_PAGE' ) ) {
		define('CORPORATE_SOLUTIONS_THEME_PAGE',__('https://asterthemes.com/products/corporate-solutions','corporate-solutions'));
	}
	if ( ! defined( 'CORPORATE_SOLUTIONS_SUPPORT' ) ) {
	define('CORPORATE_SOLUTIONS_SUPPORT',__('https://wordpress.org/support/theme/corporate-solutions/','corporate-solutions'));
	}
	if ( ! defined( 'CORPORATE_SOLUTIONS_REVIEW' ) ) {
	define('CORPORATE_SOLUTIONS_REVIEW',__('https://wordpress.org/support/theme/corporate-solutions/reviews/','corporate-solutions'));
	}
	if ( ! defined( 'CORPORATE_SOLUTIONS_PRO_DEMO' ) ) {
	define('CORPORATE_SOLUTIONS_PRO_DEMO',__('https://demo.asterthemes.com/corporate-solutions/','corporate-solutions'));
	}
	if ( ! defined( 'CORPORATE_SOLUTIONS_THEME_DOCUMENTATION' ) ) {
	define('CORPORATE_SOLUTIONS_THEME_DOCUMENTATION',__('https://demo.asterthemes.com/docs/corporate-solutions-free/','corporate-solutions'));
	}
	if ( ! defined( 'CORPORATE_SOLUTIONS_PREMIUM_DOCUMENTATION' ) ) {
	define('CORPORATE_SOLUTIONS_PREMIUM_DOCUMENTATION',__('https://demo.asterthemes.com/docs/corporate-solutions-pro/','corporate-solutions'));
	}
	if ( ! defined( 'CORPORATE_SOLUTIONS_BUNDLE_PAGE' ) ) {
		define('CORPORATE_SOLUTIONS_BUNDLE_PAGE',__('https://asterthemes.com/products/wp-theme-bundle','corporate-solutions'));
	}
}
add_action('after_setup_theme', 'corporate_solutions_links_setup');

/**
 * Customizer Settings Functions
*/
require get_template_directory() . '/theme-library/function-files/customizer-settings-functions.php';

// Enqueue Customizer live preview script
function corporate_solutions_customizer_live_preview() {
    wp_enqueue_script(
        'corporate-solutions-customizer',
        get_template_directory_uri() . '/js/customizer.js',
        array('jquery', 'customize-preview'),
        '',
        true
    );
}
add_action('customize_preview_init', 'corporate_solutions_customizer_live_preview');

// Featured Image Dimension
function corporate_solutions_blog_post_featured_image_dimension(){
	if(get_theme_mod('corporate_solutions_blog_post_featured_image_dimension') == 'custom' ) {
		return true;
	}
	return false;
}