<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package corporate_solutions
 */

get_header();

$corporate_solutions_column = get_theme_mod( 'corporate_solutions_archive_column_layout', 'column-1' );
?>
<main id="primary" class="site-main">
	<?php if ( have_posts() ) : ?>
		<div class="corporate_solutions-archive-layout grid-layout <?php echo esc_attr( $corporate_solutions_column ); ?>">
			<?php
			/* Start the Loop */
			while ( have_posts() ) : the_post();

			get_template_part( 'template-parts/content', get_post_format() );

			endwhile;
			?>
		</div>
		<?php
		do_action( 'corporate_solutions_posts_pagination' );
	else :
		get_template_part( 'template-parts/content', 'none' );
	endif;
	?>
</main>
<?php
if ( corporate_solutions_is_sidebar_enabled() ) {
	get_sidebar();
}
get_footer();