<?php
/**
 * Customizer
 * 
 * @package WordPress
 * @subpackage corporate-blocks
 * @since corporate-blocks 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function corporate_blocks_customize_register( $wp_customize ) {
	$wp_customize->add_section( new Corporate_Blocks_Upsell_Section($wp_customize,'upsell_section',array(
		'title'            => __( 'Corporate Blocks Pro', 'corporate-blocks' ),
		'button_text'      => __( 'Upgrade Pro', 'corporate-blocks' ),
		'url'              => 'https://www.wpradiant.net/products/corporate-wordpress-theme',
		'priority'         => 0,
	)));
}
add_action( 'customize_register', 'corporate_blocks_customize_register' );

/**
 * Enqueue script for custom customize control.
 */
function corporate_blocks_custom_control_scripts() {
	wp_enqueue_script( 'corporate-blocks-custom-controls-js', get_template_directory_uri() . '/assets/js/custom-controls.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-sortable' ), '1.0', true );
	wp_enqueue_style( 'corporate-blocks-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/css/customize-controls.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'corporate_blocks_custom_control_scripts' );