<?php 

add_action( 'admin_menu', 'corporate_blocks_menu' );
add_action( 'admin_init', 'corporate_blocks_register_settings' );

function corporate_blocks_menu() {
    add_menu_page(
        'Theme Options',
        'Theme Option',
        'manage_options',
        'corporate_blocks_theme_option',
        'corporate_blocks_preloader_page_callback',
        'dashicons-screenoptions',
        30
    );
}

function corporate_blocks_register_settings() {
    register_setting( 'corporate_blocks_preloader_settings', 'corporate_blocks_preloader_toggle' );
}

function corporate_blocks_preloader_page_callback() {
    ?>
    <div class="menu-box">
        <h2><?php esc_html__('Preloader Setting','corporate-blocks'); ?></h2>
        <form method="post" action="options.php">
            <?php settings_fields( 'corporate_blocks_preloader_settings' ); ?>
            <?php $toggle = get_option( 'corporate_blocks_preloader_toggle', 'off' ); ?>
            <label for="corporate_blocks_preloader_toggle">
                <input type="checkbox" id="corporate_blocks_preloader_toggle" name="corporate_blocks_preloader_toggle" <?php checked( $toggle, 'on' ); ?> />
                <?php esc_html__('Enable Preloader','corporate-blocks'); ?>
            </label>
            <?php submit_button(); ?>
        </form>
    </div>
    


    <?php
}
