<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php esc_url(header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif; ?>
<header id="main-header" class="main-header">
    <?php do_action( 'corapress_above_header'); ?>
    <div class="navigation-wrapper">
        <div class="main-navigation-area d-none d-lg-block">
           <div class="main-navigation <?php echo esc_attr(cozipress_sticky_menu()); ?>">
            <div class="container">
                <div class="row">
                    <div class="col-12 my-auto">
                        <nav class="navbar-area">
                            <div class="header-logo">
                                <div class="logo-shapbox">
                                    <div class="shap-item logo">
                                        <?php 
                                        if(has_custom_logo())
                                        {   
                                            the_custom_logo();
                                        }
                                        else { 
                                            ?>
                                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                                <h4 class="site-title">
                                                    <?php 
                                                    echo esc_html(bloginfo('name'));
                                                    ?>
                                                </h4>
                                            </a>                 
                                        <?php } 
                                        $corapress_site_desc = get_bloginfo( 'description');
                                        if ($corapress_site_desc) : ?>
                                            <p class="site-description"><?php echo esc_html($corapress_site_desc); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="main-navbar">
                                <?php 
                                wp_nav_menu( 
                                    array(  
                                        'theme_location' => 'primary_menu',
                                        'container'  => '',
                                        'menu_class' => 'main-menu',
                                        'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
                                        'walker' => new WP_Bootstrap_Navwalker()
                                    ) 
                                );
                                ?>                              
                            </div>
                            <div class="main-menu-right">
                               <ul class="menu-right-list">
                                <?php 
                                $corapress_hs_nav_search = get_theme_mod( 'hs_nav_search','1');
                                if($corapress_hs_nav_search == '1') { ?>
                                    <li class="search-button">
                                        <button type="button" id="header-search-toggle" class="header-search-toggle" aria-expanded="false" aria-label="<?php esc_attr_e( 'Search Popup', 'corapress' ); ?>"><i class="fa fa-search"></i></button>
                                        <div class="header-search-popup">
                                            <div class="header-search-flex">
                                                <form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" aria-label="<?php esc_attr_e( 'Site Search', 'corapress' ); ?>">
                                                    <input type="search" class="form-control header-search-field" placeholder="<?php esc_attr_e( 'Type To Search', 'corapress' ); ?>" name="s" id="search">
                                                    <button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
                                                </form>
                                                <button type="button" id="header-search-close" class="close-style header-search-close" aria-label="<?php esc_attr_e( 'Search Popup Close', 'corapress' ); ?>"></button>
                                            </div>
                                        </div>
                                    </li>
                                <?php } ?>
                            </ul>                                           
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="main-mobile-nav <?php echo esc_attr(cozipress_sticky_menu()); ?>"> 
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="main-mobile-menu">
                    <div class="menu-collapse-wrap">
                        <div class="hamburger-menu">
                            <button type="button" class="menu-collapsed" aria-label="<?php esc_attr_e( 'Menu Collaped', 'corapress' ); ?>">
                                <div class="top-bun"></div>
                                <div class="meat"></div>
                                <div class="bottom-bun"></div>
                            </button>
                        </div>
                    </div>
                    <div class="mobile-logo">
                        <div class="mobile-logo_shape"></div>
                        <div class="logo">
                            <?php 
                            if(has_custom_logo())
                            {   
                                the_custom_logo();
                            }
                            else { 
                                ?>
                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                    <h4 class="site-title">
                                        <?php 
                                        echo esc_html(bloginfo('name'));
                                        ?>
                                    </h4>
                                </a>    
                                <?php                       
                            }
                            ?>
                            <?php
                            $corapress_site_desc = get_bloginfo( 'description');
                            if ($corapress_site_desc) : ?>
                                <p class="site-description"><?php echo esc_html($corapress_site_desc); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="main-menu-right">
                        <ul class="menu-right-list">
                            <li class="search-button">
                                <button type="button" id="header-search-toggle" class="header-search-toggle" aria-expanded="false" aria-label="<?php esc_attr_e( 'Search Popup', 'corapress' ); ?>"><i class="fa fa-search"></i></button>
                                <div class="header-search-popup">
                                    <div class="header-search-flex">
                                        <form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" aria-label="<?php esc_attr_e( 'Site Search', 'corapress' ); ?>">
                                            <input type="search" class="form-control header-search-field" placeholder="<?php esc_attr_e( 'Type To Search', 'corapress' ); ?>" name="s" id="search">
                                            <button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
                                        </form>
                                        <button type="button" id="header-search-close" class="close-style header-search-close" aria-label="<?php esc_attr_e( 'Search Popup Close', 'corapress' ); ?>"></button>
                                    </div>
                                </div>
                            </li>
                        </ul>                            
                    </div>
                    <div class="main-mobile-wrapper">
                        <div id="mobile-menu-build" class="main-mobile-build">
                            <button type="button" class="header-close-menu close-style" aria-label="<?php esc_attr_e( 'Header Close Menu', 'corapress' ); ?>"></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>        
</div>
</div>
</header>