<?php
function corapress_css() {
	$parent_style = 'cozipress-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'corapress-style', get_stylesheet_uri(), array( $parent_style ));
}
add_action( 'wp_enqueue_scripts', 'corapress_css',999);

function corapress_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'cozipress_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'ffffff',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'cozipress_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'corapress_custom_header_setup' );

/**
 * Import Options From Parent Theme
 *
 */
function corapress_parent_theme_options() {
	$cozipress_mods = get_option( 'theme_mods_cozipress' );
	if ( ! empty( $cozipress_mods ) ) {
		foreach ( $cozipress_mods as $cozipress_mod_k => $cozipress_mod_v ) {
			set_theme_mod( $cozipress_mod_k, $cozipress_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'corapress_parent_theme_options' );

/**
 * Customize Remove
 *
 */
function corapress_customize_remove() {     
	global $wp_customize;
	$wp_customize->remove_control('slider_opacity');
	$wp_customize->remove_control('hdr_btn_icon');
	$wp_customize->remove_control('hide_show_cart');
	$wp_customize->remove_control('hdr_nav_cart');
} 
add_action( 'customize_register', 'corapress_customize_remove', 11 );

require( get_stylesheet_directory() . '/inc/customizer/customizer-pro/class-customize.php');