<?php
/*
 *  Custom Style
 */

/* All Dynamic CSS Styles */
if ( ! function_exists( 'consultee_dynamic_styles' ) ) {
  function consultee_dynamic_styles() {


  ob_start();
  global $post;

  if ( defined('FW') ) {
    $consultee_menu_color = fw_get_db_customizer_option('consultee_menu_color');
    $consultee_menu_bg_color = fw_get_db_customizer_option('consultee_menu_bg_color');
    $consultee_menu_logo_color = fw_get_db_customizer_option('consultee_menu_logo_color');
    $consultee_title_text_color = fw_get_db_customizer_option('consultee_title_text_color');
    $consultee_title_bg_color = fw_get_db_customizer_option('consultee_title_bg_color');
    $consultee_footer_copywrite_color = fw_get_db_customizer_option('consultee_footer_copywrite_color');
    $consultee_footer_copywrite_bg_color = fw_get_db_customizer_option('consultee_footer_copywrite_bg_color');
    $consultee_body_typography = fw_get_db_customizer_option('consultee_body_typography');
    $consultee_heading_typography = fw_get_db_customizer_option('consultee_heading_typography');
  }
  $consultee_menu_color = isset( $consultee_menu_color ) ? $consultee_menu_color : '';
  $consultee_menu_bg_color = isset( $consultee_menu_bg_color ) ? $consultee_menu_bg_color : '';
  $consultee_menu_logo_color = isset( $consultee_menu_logo_color ) ? $consultee_menu_logo_color : '';
  $consultee_title_text_color = isset( $consultee_title_text_color ) ? $consultee_title_text_color : '';
  $consultee_title_bg_color = isset( $consultee_title_bg_color ) ? $consultee_title_bg_color : '';
  $consultee_footer_copywrite_color = isset( $consultee_footer_copywrite_color ) ? $consultee_footer_copywrite_color : '';
  $consultee_footer_copywrite_bg_color = isset( $consultee_footer_copywrite_bg_color ) ? $consultee_footer_copywrite_bg_color : '';
  $consultee_body_typography = isset( $consultee_body_typography['family'] ) ? $consultee_body_typography['family'] : '';
  $consultee_heading_typography = isset( $consultee_heading_typography['family'] ) ? $consultee_heading_typography['family'] : '';

  if ( $consultee_menu_color ) {?>
    .site-header #navbar>ul>li>a {
      color: <?php echo esc_attr( $consultee_menu_color ); ?>;
    }
  <?php
  }

  if ( $consultee_menu_bg_color ) {?>
    .site-header .navigation {
      background-color: <?php echo esc_attr( $consultee_menu_bg_color ); ?>;
    }
  <?php
  }
 
  if ( $consultee_menu_logo_color ) {?>
    .site-header .navbar-header .site-branding h2 a, .site-header .navbar-header .site-branding p a {
      color: <?php echo esc_attr( $consultee_menu_logo_color ); ?>;
    }
  <?php
  }

  if ( $consultee_title_text_color ) {?>
    .entry-header h2 {
      color: <?php echo esc_attr( $consultee_title_text_color ); ?>;
    }
  <?php
  }

  if ( $consultee_title_bg_color ) {?>
    .entry-header:before {
      background-color: <?php echo esc_attr( $consultee_title_bg_color ); ?>;
    }
  <?php
  }

  if ( $consultee_footer_copywrite_color ) {?>
    .site-footer .site-info, .site-footer .site-info a {
      color: <?php echo esc_attr( $consultee_footer_copywrite_color ); ?>;
    }
  <?php
  }

  if ( $consultee_footer_copywrite_bg_color ) {?>
    .site-footer {
      background-color: <?php echo esc_attr( $consultee_footer_copywrite_bg_color ); ?>;
    }
  <?php
  }

  if ( $consultee_body_typography ) {?>
     body {
      font-family: <?php echo esc_attr( $consultee_body_typography ); ?>;
    }
  <?php
  }
  if ( $consultee_heading_typography ) {?>
     h1, h2, h3, h4, h5, h6 {
      font-family: <?php echo esc_attr( $consultee_heading_typography ); ?>;
    }
  <?php
  }

  $output = ob_get_clean();
  return $output;

  }

}

/* Custom Styles */
if( ! function_exists( 'consultee_custom_css' ) ) {
  function consultee_custom_css() {
    wp_enqueue_style('consultee-default-style', get_template_directory_uri() . '/style.css');
    $output = consultee_dynamic_styles();
    $custom_css = consultee_compress_css_lines( $output );

    wp_add_inline_style( 'consultee-default-style', $custom_css );
  }
  add_action( 'wp_enqueue_scripts', 'consultee_custom_css' );
}