<?php

if ( ! defined( 'FW' ) ) {
    die( 'Forbidden' );
}

$options = array(
    'consultee_general_settings' => array(
        'title'   => esc_html__( 'General', 'consultee' ),
        'type'    => 'tab',
        'options' => array(
            'general-box' => array(
                'title'   => esc_html__( 'General Settings', 'consultee' ),
                'type'    => 'box',
                'options' => array(
                    'consultee_hide_title'    => array(
                        'label' => esc_html__( 'Hide Title bar', 'consultee' ),
                        'desc'  => esc_html__( 'Please turn on if you dont want to show title bar', 'consultee' ),
                        'type'  => 'switch',
                        'value' => 'title_bar',
                    ),
                    'consultee_header_styles'    => array(
                        'label' => esc_html__( 'Select Header Style', 'consultee' ),
                        'desc'  => esc_html__( 'Pleas select header options here', 'consultee' ),
                        'type'  => 'image-picker',
                        'value' => 'image-2',
                        'choices' => array(
                            'hs_1' => get_template_directory_uri() .'/assets/images/hs-1.png',
                            'hs_2' => get_template_directory_uri() .'/assets/images/hs-2.png',
                        ),
                    ),
                    'consultee_sidebar_style'    => array(
                        'label' => esc_html__( 'Select Sidebar Style', 'consultee' ),
                        'desc'  => esc_html__( 'Pleas select sidebar options here', 'consultee' ),
                        'type'  => 'image-picker',
                        'value' => 'image-2',
                        'choices' => array(
                            'sidebar_full' => get_template_directory_uri() .'/assets/images/page-1.png',
                            'sidebar_left' => get_template_directory_uri() .'/assets/images/page-2.png',
                            'sidebar_right' => get_template_directory_uri() .'/assets/images/page-3.png',
                        ),
                    ),
                    'consultee_header_banner_image' => array(
                        'label' => esc_html__( 'Banner Image', 'consultee' ),
                        'desc'  => esc_html__( 'Please Upload a image for specific page header image', 'consultee' ),
                        'type'  => 'upload'
                    ),
                    'consultee_custom_padding' => array(
                        'label' => esc_html__( 'Cuatom Padding', 'consultee' ),
                        'desc'  => esc_html__( 'Please select custom padding for page', 'consultee' ),
                        'type'  => 'range-slider',
                        'value' => array(
                          'from' => 50,
                          'to'   => 100,
                        ),
                        'properties' => array(
                            'min' => 20,
                            'max' => 200,
                        ),
                    ),
                    'consultee_hide_footer'    => array(
                        'label' => esc_html__( 'Hide Footer', 'consultee' ),
                        'desc'  => esc_html__( 'Please turn on if you dont want to show footer', 'consultee' ),
                        'type'  => 'switch',
                        'value' => 'footer',
                    ),
                )
            ),
        )
    )
);