<?php if (!defined( 'FW' )) die('Forbidden');

$options = array(
    'setting_panel' => array(
        'title' => esc_html__('Consultee Panel', 'consultee'),
        'options' => array(

            'consultee_settings' => array(
                'title' => esc_html__('General Setting', 'consultee'),
                'options' => array(

                    'consultee_preloader' => array(
                        'type'  => 'switch',
                        'label' => esc_html__('Consultee Preloader', 'consultee'),
                        'desc' => esc_html__('Turn off if you dont want to show preloader', 'consultee'),
                    ),

                ),
            ),
            // Blog Settings
            'consultee_blog_settings' => array(
                'title' => esc_html__('Blog Setting', 'consultee'),
                'options' => array(
                    'consultee_blog_sidebar_style'    => array(
                        'label' => esc_html__( 'Select Sidebar Style', 'consultee' ),
                        'desc'  => esc_html__( 'Pleas select sidebar options here', 'consultee' ),
                        'type'  => 'image-picker',
                        'value' => 'image-2',
                        'choices' => array(
                            'sidebar_full' => get_template_directory_uri() .'/assets/images/page-1.png',
                            'sidebar_left' => get_template_directory_uri() .'/assets/images/page-2.png',
                            'sidebar_right' => get_template_directory_uri() .'/assets/images/page-3.png',
                        ),
                    ),
                    'consultee_post_meta' => array(
                        'type'  => 'switch',
                        'value' => false,
                        'label' => esc_html__('Hide Post Meta', 'consultee'),
                        'desc' => esc_html__('Turn On if you dont want to show post meta', 'consultee'),
                    ),
                    'consultee_readmore_text' => array(
                        'type'  => 'text',
                        'value' => 'Read More',
                        'label' => esc_html__('Change Read More Text', 'consultee'),
                        'desc' => esc_html__('Change Read More Post text. Just Type that you want.', 'consultee'),
                    ),

                ),
            ),
            // Footer Settings
            'consultee_footer_settings' => array(
                'title' => esc_html__('Footer Setting', 'consultee'),
                'options' => array(
                    'consultee_footer_widget_block' => array(
                        'type'  => 'switch',
                        'label' => esc_html__('Footer widget', 'consultee'),
                        'desc' => esc_html__('Turn off if you dont want to show Footer widget', 'consultee'),
                    ),
                    'consultee_footer_widget_layout'    => array(
                        'label' => esc_html__( 'Select Footer widget', 'consultee' ),
                        'desc'  => esc_html__( 'Pleas select Footer widget options here', 'consultee' ),
                        'type'  => 'image-picker',
                        'value' => 'footer-2',
                        'choices' => array(
                            '1' => get_template_directory_uri() .'/assets/images/footer-1.png',
                            '2' => get_template_directory_uri() .'/assets/images/footer-2.png',
                            '3' => get_template_directory_uri() .'/assets/images/footer-3.png',
                            '4' => get_template_directory_uri() .'/assets/images/footer-4.png',
                        ),
                    ),
                ),
            ),

            // Typography Settings
            'consultee_typography_settings' => array(
                'title' => esc_html__('Typography Setting', 'consultee'),
                'options' => array(
                    'consultee_body_typography' => array(
                      'type'  => 'typography',
                      'value' => array(
                          'family' => 'segoe-ui',
                      ),
                     'components' => array(
                          'family' => true,
                          'size'   => false,
                          'color'  => false
                      ),
                      'label' => esc_html__('Body Typography', 'consultee'),
                  ),
                    'consultee_heading_typography' => array(
                      'type'  => 'typography',
                      'value' => array(
                          'family' => 'Josefin Sans',
                      ),
                     'components' => array(
                          'family' => true,
                          'size'   => false,
                          'color'  => false
                      ),
                     'label' => esc_html__('Title Typography', 'consultee'),
                  )

                ),
            ),

        ),
        'wp-customizer-args' => array(
            'priority' => 3,
        ),
    ),

    // Color Panel
    'consultee_color_panel' => array(
        'title' => esc_html__('Consultee Colors', 'consultee'),
        'options' => array(

            'consultee_menu_color_section' => array(
                'title' => esc_html__('Menu Color', 'consultee'),
                'options' => array(

                    'consultee_menu_color' => array(
                        'type' => 'color-picker',
                        'value' => '#274054',
                        'label' => esc_html__('Menu Color', 'consultee'),
                        'desc' => esc_html__('Set Color for menu text', 'consultee'),
                    ),
                    'consultee_menu_bg_color' => array(
                        'type' => 'rgba-color-picker',
                        'value' => 'rgba(255,255,255,0.9)',
                        'label' => esc_html__('Menu Background Color', 'consultee'),
                        'desc' => esc_html__('Set Color for menu background', 'consultee'),
                    ),

                    'consultee_menu_logo_color' => array(
                        'type' => 'color-picker',
                        'value' => '#008bff',
                        'label' => esc_html__('Logo Text Color', 'consultee'),
                        'desc' => esc_html__('Set Color for text logo', 'consultee'),
                    ),

                ),
            ),

            'consultee_titlebar_color_section' => array(
                'title' => esc_html__('Titlbar Color', 'consultee'),
                'options' => array(

                    'consultee_title_text_color' => array(
                        'type' => 'color-picker',
                        'value' => '#ffffff',
                        'label' => esc_html__('Title Text Color', 'consultee'),
                        'desc' => esc_html__('Set Color for titlebar text', 'consultee'),
                    ),
                    'consultee_title_bg_color' => array(
                        'type' => 'rgba-color-picker',
                        'value' => 'rgba(2, 169, 72,0.7)',
                        'label' => esc_html__('Title Bar Background', 'consultee'),
                        'desc' => esc_html__('Set Color for titlebar Background', 'consultee'),
                    ),

                ),
            ),
            'consultee_footer_color_section' => array(
                'title' => esc_html__('Footer Color', 'consultee'),
                'options' => array(

                    'consultee_footer_copywrite_color' => array(
                        'type' => 'rgba-color-picker',
                        'value' => '#ffffff',
                        'label' => esc_html__('Copywrite Text', 'consultee'),
                        'desc' => esc_html__('Set Color for Footer Copywrite text', 'consultee'),
                    ),
                    'consultee_footer_copywrite_bg_color' => array(
                        'type' => 'rgba-color-picker',
                        'value' => '#2b2e3a',
                        'label' => esc_html__('Copywrite Background', 'consultee'),
                        'desc' => esc_html__('Set Color for Footer Copywrite Background', 'consultee'),
                    ),

                ),
            ),

        ),
        'wp-customizer-args' => array(
            'priority' => 4,
        ),
    ),
    // Color Panel End
);

