<?php
/**
 * Theme functions and definitions
 *
 * @package Consultco Dark
 */

if ( ! function_exists( 'consultco_dark_enqueue_styles' ) ) :

	/**
	 * Load assets.
	 *
	 * @since 1.0.0
	 */
	function consultco_dark_enqueue_styles() {

		wp_enqueue_style( 'consultco-style-parent', get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'consultco-dark-style', get_stylesheet_directory_uri() . '/style.css', array( 'consultco-dark-style-parent' ), '1.0' );
		wp_enqueue_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.css');
		wp_enqueue_style( 'consultco-dark-default-css', get_stylesheet_directory_uri()."/css/colors/default.css" );
		wp_dequeue_style( 'default',get_template_directory_uri() .'/css/colors/default.css');
	}

endif;

add_action( 'wp_enqueue_scripts', 'consultco_dark_enqueue_styles', 99 );


function consultco_dark_customizer_rid_values($wp_customize) {

  $wp_customize->remove_section('nav_btn_section');
  $wp_customize->remove_section('hide_show_nav_menu_btn');
  $wp_customize->remove_section('menu_btn_label');
}

add_action( 'customize_register', 'consultco_dark_customizer_rid_values', 1000 );



$args = array(
			'default-image'		=>  get_template_directory_uri() .'/images/sub-header.jpg',
			'width'			=> '1600',
			'height'		=> '600',
			'flex-height'		=> false,
			'flex-width'		=> false,
			'header-text'		=> true,
			'default-text-color'	=> 'fff',
			 'wp-head-callback' => 'consultco_header_color',
		);
add_theme_support( 'custom-header', $args );