<?php

add_action( 'admin_menu', 'construction_realestate_gettingstarted' );
function construction_realestate_gettingstarted() {    	
	add_theme_page( esc_html__('About Theme', 'construction-realestate'), esc_html__('Theme Demo Import', 'construction-realestate'), 'edit_theme_options', 'construction-realestate-guide-page', 'construction_realestate_guide');   
}

function construction_realestate_admin_theme_style() {
   wp_enqueue_style('construction-realestate-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/dashboard/get_started_info.css');
   wp_enqueue_script('construction-realestate-tab', esc_url( get_template_directory_uri() ) . '/inc/dashboard/js/get_started_tab.js');
   // Admin notice code START
	wp_register_script('construction-realestate-notice', esc_url(get_template_directory_uri()) . '/inc/dashboard/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('construction-realestate-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'construction_realestate_admin_theme_style');

// Notice after Theme Activation
function construction_realestate_notice(){
    global $pagenow;
    if ( is_admin() && $pagenow === 'themes.php' && (!isset($_GET['page']) || $_GET['page'] !== 'construction-realestate-guide-page')
) {
$construction_realestate_meta = get_option( 'construction_realestate_admin_notice' );
	if (!$construction_realestate_meta) {?>
    <div id="construction-realestate-welcome-notice" class="notice notice-success is-dismissible getting_started activation-notice">
		<div class="notice-info">
			<div class="notice-image">
				<img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
			</div>
			<div class="notice-content">
				<h2><?php esc_html_e( 'Thanks For Installing Construction Realestate, You Rock!', 'construction-realestate' ) ?> </h2>
				<p><?php esc_html_e( 'Take benefit of a variety of features, functionalities, elements, and an exclusive set of customization options to build your own professional charity website. Please Click on the link below to know the theme setup information.', 'construction-realestate' ) ?>
				</p>
				<div style="display: grid;">
					<a class="button notice-btn" href="<?php echo esc_url( admin_url( 'themes.php?page=construction-realestate-guide-page' )); ?>"><?php esc_html_e( 'Get Started', 'construction-realestate' ) ?></a>
					<a class="button notice-btn" target="_blank" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_LIVE_DEMO ); ?>"><?php esc_html_e('Pro Demo', 'construction-realestate') ?></a>
					<a  class="button notice-btn" target="_blank" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_BUY_PRO ); ?>"><?php esc_html_e('Upgrade To Pro', 'construction-realestate') ?></a>
					<a  class="button notice-btn" target="_blank" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_FREE_DOC ); ?>"><?php esc_html_e('Free Doc', 'construction-realestate') ?></a>
				</div>
			</div>
		</div>
	</div>
	<?php }
}
}
add_action('admin_notices', 'construction_realestate_notice');

// Admin notice code START
function construction_realestate_dismissed_notice() {
	update_option( 'construction_realestate_admin_notice', true );
}
add_action( 'wp_ajax_construction_realestate_dismissed_notice', 'construction_realestate_dismissed_notice' );

//After Switch theme function
add_action('after_switch_theme', 'construction_realestate_getstart_setup_options');
function construction_realestate_getstart_setup_options () {
    update_option('construction_realestate_admin_notice', false );
}
// Admin notice code END

/**
 * Theme Info Page
 */
function construction_realestate_guide() {

	// Theme info
	$construction_realestate_return = add_query_arg( array()) ;
	$construction_realestate_theme = wp_get_theme( 'construction-realestate' ); ?>

	<div class="wrap getting-started">
		<div class="getting-started__header">
		    <div>
                <h2 class="tgmpa-notice-warning"></h2>
            </div>
		</div>
		<div class="tab-sec">
			<div class="tab">
				<button role="tab" class="tablinks home" onclick="construction_realestate_openCity(event, 'bwp_getstart')"><?php esc_html_e( 'Theme Demo Import', 'construction-realestate' ); ?></button>
				<button role="tab" class="tablinks" onclick="construction_realestate_openCity(event, 'bwp_setup')"><?php esc_html_e( 'Free Theme Information', 'construction-realestate' ); ?></button>
				<button role="tab" class="tablinks" onclick="construction_realestate_openCity(event, 'bwp_premium_info')"><?php esc_html_e( 'Premium Theme Information', 'construction-realestate' ); ?></button>
				<a class="tablinks tablinks-demo" role="tab" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_LIVE_DEMO ); ?>" target="_blank">
					<?php esc_html_e( 'Live Demo', 'construction-realestate' ); ?>
				</a>
				<a class="tablinks tablinks-pro" role="tab" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_BUY_PRO ); ?>" target="_blank">
					<?php esc_html_e( 'Buy Pro', 'construction-realestate' ); ?>
				</a>
			</div>
			<div  id="bwp_getstart" class="tabcontent">
				<div class="row">
					<div class="col-md-5 intro">
						<div class="pad-box">
							<h2><?php esc_html_e( 'Welcome to Construction Realestate ', 'construction-realestate' ); ?>
							<span><?php esc_html_e( 'Version: ', 'construction-realestate' ); ?><?php echo esc_html($construction_realestate_theme['Version']);?></span>
							</h2>
							<span class="intro__version"><?php esc_html_e( 'Congratulations! You are about to use the most easy to use and flexible WordPress theme.', 'construction-realestate' ); ?>
							</span>
							<div class="powered-by">
								<p><strong><?php esc_html_e( 'Theme created by Buy WP Templates', 'construction-realestate' ); ?></strong></p>
								<p>
									<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/theme-logo.png'); ?>"/>
								</p>
								<div class="demo-content">
									<?php
										/* Demo Import */
										require get_parent_theme_file_path( '/inc/dashboard/demo-content.php' );
									?>
								</div>

								<div id="demo-import-loader">
									<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/spinner.gif'); ?>" alt="<?php echo esc_attr( 'Loading...', 'construction-realestate'); ?>" />
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-7">
						<div class="install-plugins">
							<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/construction-theme.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'construction-realestate'); ?>" />
						</div>
					</div>
				</div>
				<div class="dashboard__blocks">
					<div class="row">
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Get Support','construction-realestate'); ?></h3>
							<ol>
								<li><a target="_blank" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_FREE_SUPPORT ); ?>"><?php esc_html_e( 'Free Theme Support','construction-realestate'); ?></a></li>
								<li><a target="_blank" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_PRO_SUPPORT ); ?>"><?php esc_html_e( 'Premium Theme Support','construction-realestate'); ?></a></li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Getting Started','construction-realestate'); ?></h3>
							<ol>
								<li><?php esc_html_e( 'Start','construction-realestate'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','construction-realestate'); ?></a> <?php esc_html_e( 'your website.','construction-realestate'); ?> </li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Help Docs','construction-realestate'); ?></h3>
							<ol>
								<li><a target="_blank" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_FREE_DOC ); ?>"><?php esc_html_e( 'Free Theme Documentation','construction-realestate'); ?></a></li>
								<li><a target="_blank" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_PRO_DOC ); ?>"><?php esc_html_e( 'Premium Theme Documentation','construction-realestate'); ?></a></li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Buy Premium','construction-realestate'); ?></h3>
							<ol>
								<a href="<?php echo esc_url( CONSTRUCTION_REALESTATE_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'construction-realestate'); ?></a>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<div  id="bwp_setup" class="tabcontent">
				<h2 class="tg-docs-section intruction-title" id="section-4"><?php esc_html_e( '1) Setup Construction Realestate Theme', 'construction-realestate' ); ?></h2>
				<div class="row">
					<div class="theme-instruction-block col-md-7">
						<div class="pad-box">
							<p><?php esc_html_e( 'Construction Realestate WordPress Theme offers you instant answers for your online activities that are related to your building industry. This is an ideal solution for real estate agents, real estate brokers, Brokerage, Property management, construction real estate,real estate development,residential construction,commercial real estate projects,luxury home construction,modern real estate designs,urban property development,real estate infrastructure,real estate investment buildings,sustainable real estate construction,green construction projects,custom property designs,real estate renovation services,industrial property construction,real estate project management,mixed-use development projects,affordable housing construction,real estate consultancy services,real estate building services,turnkey con, rentals services, Land, Residential, Commercial, advanced property search, anybody who is interested in building construction business websites. Though it mainly occupies the construction area, it can be used for multiple businesses such as property inclusion, agent, realtor agency maintainance, construction landing page, and real estate listing etc. This theme has been crafted carefully keeping in mind the latest web design standards. It offers a dynamic customizer with multiple theme options, to bring out the design of your website as per your wants. This minimal WordPress theme is built on Bootstrap that makes it highly responsive and cross-browser compatible. Being a mobile-friendly theme, it gives a cutting-edge performance on every screen size. It has secure and clean codes that are in accordance with WordPress web standards. To match the style of your business, it offers eye-catching buttons, beautiful images, sliders, Microformats, banners, custom menu, footer widgets contact form, and a lot more under the hood. With social media integration, it powers your online presence. Its SEO friendly nature will make your website reach the top search results. Take advantage of ample of features, functionalities, and an advanced set of customization options to create your own professional real estate business site. Reap the benefits of this free, flexible, and robust WordPress theme now!', 'construction-realestate' ); ?><p><br>
							<ol>
								<li><?php esc_html_e( 'Start','construction-realestate'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','construction-realestate'); ?></a> <?php esc_html_e( 'your website.','construction-realestate'); ?> </l>
								<li><?php esc_html_e( 'Construction Realestate','construction-realestate'); ?> <a target="_blank" href="<?php echo esc_url( CONSTRUCTION_REALESTATE_FREE_DOC ); ?>"><?php esc_html_e( 'Documentation','construction-realestate'); ?></a> </li>
							</ol>
						</div>
					</div>
					<div class="col-md-5">
						<div class="pad-box">
								<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/screenshot.png'); ?>"/>
						</div>
					</div>	
				</div>
			</div>
			<div class="col-md-12 text-block tabcontent"  id="bwp_premium_info">
				<h2 class="dashboard-install-title"><?php esc_html_e( '2) Premium Theme Information.','construction-realestate'); ?></h2>
				<div class="row">
					<div class="col-md-7">
						<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/Resize.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'construction-realestate'); ?>">
						<div class="pad-box">
							<h3><?php esc_html_e( 'Pro Theme Description','construction-realestate'); ?></h3>
							<p class="pad-box-p"><?php esc_html_e( 'This property Wp theme is unlike anything you have seen on the webspace, it has been made on the useful bootstrap 4 that ensures responsiveness. No stones were left unturned while the theme was designed and made. We rigorously looked into the themes functionalities and booted any errors and problems that were discovered. It has been put to scrutiny umpteen times so that a utopian real estate template can be created and served on a silver platter. Your money will not only be taken as just an investment with the purchase of our theme. Our theme has the power to reap recurring benefits and pay you back in the foreseeable future. The mesmerizing theme has gorgeous sections strewn across the entire template like the banner head with a helpful call to action button. The premium theme does not halt at that, it also comes with exclusive features that are limited to them. Not to forget the long list of features and beneficial customizer options that can empower you to take control of your website and customize it as per your wishes. This state of the art theme with clean and secure codes takes the security of your web pages very seriously. So what is the wait, hop on and become a part of our budding community of WordPress templates and show the world what you got.', 'construction-realestate' ); ?><p>
						</div>
					</div>
					<div class="col-md-5 install-plugin-right">
						<div class="pad-box">
							<h3><?php esc_html_e( 'Pro Theme Features','construction-realestate'); ?></h3>
							<div class="dashboard-install-benefit">
								<ul>
									<li><?php esc_html_e( 'Property listing','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Agents list','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Multiple image feature for each property with slider.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Meta fields to list down the features of each property.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Inquiry form for each property..','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'All Property listing using shortcode.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Property listing by Category using shortcode.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Agents list shortcode.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Testimonial listing.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Testimonial shortcode.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Social icons widget.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Latest post with the image widget.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Search for properties.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Live customize editor for the About US section.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Font Awesome integrated.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Advanced Color options and color pallets.','construction-realestate'); ?></li>
									<li><?php esc_html_e( '100+ Font Family Options.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Enable-Disable options on All sections.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Well sanitized as per WordPress standards.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Allow to set site title, tagline, logo.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Sticky post & Comment threads.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Left and Right Sidebar.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Customizable Home Page.','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Footer Widgets & Editor style','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Gallery & Banner functionality','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Multiple inner page templates','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Full-width Template','construction-realestate'); ?></li>
									<li><?php esc_html_e( 'Custom Menu, Colors Editor','construction-realestate'); ?></li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php }?>