<div class="theme-offer">
	<?php
        // Check if the demo import has been completed
        $construction_realestate_demo_import_completed = get_option('construction_realestate_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($construction_realestate_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'construction-realestate') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('VIEW SITE', 'construction-realestate') . '</a></span>';
        }

		//POST and update the customizer and other related data of POLITICAL CAMPAIGN
        if (isset($_POST['submit'])) {

            // ------- Create Nav Menu --------
            $construction_realestate_menuname = 'Main Menus';
            $construction_realestate_bpmenulocation = 'primary';
            $construction_realestate_menu_exists = wp_get_nav_menu_object($construction_realestate_menuname);

            if (!$construction_realestate_menu_exists) {
                $construction_realestate_menu_id = wp_create_nav_menu($construction_realestate_menuname);

                // Create Home Page
                $construction_realestate_home_title = 'Home';
                $construction_realestate_home = array(
                    'post_type' => 'page',
                    'post_title' => $construction_realestate_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $construction_realestate_home_id = wp_insert_post($construction_realestate_home);
                // Assign Home Page Template
                add_post_meta($construction_realestate_home_id, '_wp_page_template', 'page-template/custom-home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $construction_realestate_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($construction_realestate_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'construction-realestate'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $construction_realestate_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create About Us Page with Dummy Content
                $construction_realestate_about_title = 'About Us';
                $construction_realestate_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>
                Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $construction_realestate_about = array(
                    'post_type' => 'page',
                    'post_title' => $construction_realestate_about_title,
                    'post_content' => $construction_realestate_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $construction_realestate_about_id = wp_insert_post($construction_realestate_about);
                // Add About Us Page to Menu
                wp_update_nav_menu_item($construction_realestate_menu_id, 0, array(
                    'menu-item-title' => __('About Us', 'construction-realestate'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $construction_realestate_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $construction_realestate_recent_title = 'Recent Property';
                $construction_realestate_recent_content = 'Explore all the recent we have on our website. Find information about our services, company, and more.
                Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $construction_realestate_recent = array(
                    'post_type' => 'page',
                    'post_title' => $construction_realestate_recent_title,
                    'post_content' => $construction_realestate_recent_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'recent'
                );
                $construction_realestate_recent_id = wp_insert_post($construction_realestate_recent);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($construction_realestate_menu_id, 0, array(
                    'menu-item-title' => __('Recent Property', 'construction-realestate'),
                    'menu-item-classes' => 'recent',
                    'menu-item-url' => home_url('/recent/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $construction_realestate_recent_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $construction_realestate_featured_title = 'Featured Property';
                $construction_realestate_featured_content = 'Explore all the featured we have on our website. Find information about our services, company, and more.
                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more featuredly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $construction_realestate_featured = array(
                    'post_type' => 'page',
                    'post_title' => $construction_realestate_featured_title,
                    'post_content' => $construction_realestate_featured_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'featured'
                );
                $construction_realestate_featured_id = wp_insert_post($construction_realestate_featured);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($construction_realestate_menu_id, 0, array(
                    'menu-item-title' => __('Featured Property', 'construction-realestate'),
                    'menu-item-classes' => 'featured',
                    'menu-item-url' => home_url('/featured/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $construction_realestate_featured_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $construction_realestate_contact_title = 'Contact';
                $construction_realestate_contact_content = 'Explore all the contact we have on our website. Find information about our services, company, and more.
                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more contactly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $construction_realestate_contact = array(
                    'post_type' => 'page',
                    'post_title' => $construction_realestate_contact_title,
                    'post_content' => $construction_realestate_contact_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'contact'
                );
                $construction_realestate_contact_id = wp_insert_post($construction_realestate_contact);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($construction_realestate_menu_id, 0, array(
                    'menu-item-title' => __('Contact', 'construction-realestate'),
                    'menu-item-classes' => 'contact',
                    'menu-item-url' => home_url('/contact/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $construction_realestate_contact_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));
                

                // Set the menu location if it's not already set
                if (!has_nav_menu($construction_realestate_bpmenulocation)) {
                    $construction_realestate_locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($construction_realestate_locations)) {
                        $construction_realestate_locations = array();
                    }
                    $construction_realestate_locations[$construction_realestate_bpmenulocation] = $construction_realestate_menu_id;
                    set_theme_mod('nav_menu_locations', $construction_realestate_locations);
                }
            }

            // Set the demo import completion flag
    		update_option('construction_realestate_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'construction-realestate') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('VIEW SITE', 'construction-realestate') . '</a></span>';
            //end

            // Top Bar //
            set_theme_mod( 'construction_realestate_location_icon', 'fas fa-map-marker-alt' );
            set_theme_mod( 'construction_realestate_location', 'Oceanview Hall' );
            set_theme_mod( 'construction_realestate_location1', 'Miami, FL 33141' );
            set_theme_mod( 'construction_realestate_time_icon', 'far fa-clock' );
            set_theme_mod( 'construction_realestate_time', '9 am to 6 pm' );
            set_theme_mod( 'construction_realestate_time1', 'Monday to Friday' );
            set_theme_mod( 'construction_realestate_phone_icon', 'fas fa-phone' );
            set_theme_mod('construction_realestate_number', 'US +91 123-456-7890');
            set_theme_mod('construction_realestate_number1', 'EU +91 123-456-7890');

            // social icon
            set_theme_mod('construction_realestate_facebook_icon', 'fab fa-facebook-f' );
            set_theme_mod('construction_realestate_cont_facebook', 'https://www.facebook.com' );
            set_theme_mod('construction_realestate_twitter_icon', 'fab fa-twitter' );
            set_theme_mod('construction_realestate_cont_twitter', 'https://www.twtter.com');
            set_theme_mod('construction_realestate_pinterest_icon', 'fab fa-pinterest' );
            set_theme_mod('construction_realestate_pinterest', 'https://www.pinterest.com');
            set_theme_mod('construction_realestate_tumblr_icon', 'fab fa-tumblr' );
            set_theme_mod('construction_realestate_tumblr', 'https://www.tumblr.com');
            set_theme_mod('construction_realestate_instagram_icon', 'fab fa-instagram' );
            set_theme_mod('construction_realestate_instagram', 'https://instagram.com');
            set_theme_mod('construction_realestate_linkedin_icon', 'fab fa-linkedin-in' );
            set_theme_mod('construction_realestate_linkedin', 'https://www.linkedin.com');

            // slider section start //
            set_theme_mod( 'construction_realestate_slider_button_text', 'Know More' );
            set_theme_mod('construction_realestate_slider_button_link', '#');

            $construction_realestate_slider_titles = array(
                'Build Your Dream Home with Us',
                'Quality Construction for Modern Living',
                'Smart Real Estate Investments Today',
                'Innovative Designs for Your Future'
            );
         
            for ($construction_realestate_i = 0; $construction_realestate_i < count($construction_realestate_slider_titles); $construction_realestate_i++) {
                $construction_realestate_slider_title = $construction_realestate_slider_titles[$construction_realestate_i];
                $construction_realestate_slider_content = 'Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took.';
                
                // Create post object
                $construction_realestate_my_post = array(
                    'post_title'    => wp_strip_all_tags($construction_realestate_slider_title),
                    'post_content'  => $construction_realestate_slider_content,
                    'post_status'   => 'publish',
                    'post_type'     => 'page',
                );
            
                // Insert the post into the database
                $construction_realestate_post_id = wp_insert_post($construction_realestate_my_post);
            
                if ($construction_realestate_post_id) {
                    // Set the theme mod for the slider page
                    set_theme_mod('construction_realestate_slider' . ($construction_realestate_i + 1), $construction_realestate_post_id);
            
                    $construction_realestate_image_url = get_template_directory_uri() . '/images/slider' . ($construction_realestate_i + 1) . '.png';
                    $construction_realestate_image_id = media_sideload_image($construction_realestate_image_url, $construction_realestate_post_id, null, 'id');
            
                    if (!is_wp_error($construction_realestate_image_id)) {
                        // Set the downloaded image as the post's featured image
                        set_post_thumbnail($construction_realestate_post_id, $construction_realestate_image_id);
                    }
                }
            }         

            // about us
            set_theme_mod('construction_realestate_sec_title', 'ABOUT US');
            
            $construction_realestate_post_title = "What is Lorem Ipsum?";
            $construction_realestate_post_content = 'Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s.';
            // $construction_realestate_image_url = get_template_directory_uri() . '/images/services/service-banner.png'; 

            // Create post object
            $construction_realestate_post_data = array(
                'post_title'    => wp_strip_all_tags($construction_realestate_post_title),
                'post_content'  => $construction_realestate_post_content,
                'post_status'   => 'publish',
                'post_type'     => 'post', // Set post type to 'post'
            );
            set_theme_mod('construction_realestate_about_post_setting', $construction_realestate_post_title);

            // Insert the post into the database
            $construction_realestate_post_id = wp_insert_post($construction_realestate_post_data);

            if (is_wp_error($construction_realestate_post_id)) {
                error_log('Error creating post: ' . $construction_realestate_post_id->get_error_message());
            } else {
                // Handle the featured image
                $construction_realestate_image_id = media_sideload_image($construction_realestate_image_url, $construction_realestate_post_id, null, 'id');

                if (is_wp_error($construction_realestate_image_id)) {
                    error_log('Error downloading image: ' . $construction_realestate_image_id->get_error_message());
                } else {
                    // Assign featured image to post
                    set_post_thumbnail($construction_realestate_post_id, $construction_realestate_image_id);
                }
            }
           
            //Copyright Text
            set_theme_mod( 'construction_realestate_footer_text', 'By Buywptemplate' );

        }
    ?>

    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=construction-realestate-guide-page" method="POST" onsubmit="return validate(this);">
    <?php if (!get_option('construction_realestate_demo_import_completed')) : ?>
        <form method="post">
        <p><?php esc_html_e('Click the below run importer button to import demo content','construction-realestate'); ?></p>
            <input class= "run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer','construction-realestate'); ?>" class="button button-primary button-large">
        </form>
    <?php endif; ?>
    </form>
	<script type="text/javascript">
		function validate(valid) {
			if (confirm("Do you really want to import the theme demo content?")) {
                // Show loader
                document.getElementById('demo-import-loader').style.display = 'block';
                
                // Submit form
                document.forms[0].submit();
            } else {
                return false;
            }
		}
	</script>
</div>
