<?php
/**
 * The template for displaying the footer.
 * @package Construction Realestate
 */
?>
<?php if( get_theme_mod( 'construction_realestate_hide_show_scroll',true) != '' || get_theme_mod( 'construction_realestate_display_scrolltop', true) != '') { ?>
    <?php $construction_realestate_theme_lay = get_theme_mod( 'construction_realestate_footer_options','Right');
        if($construction_realestate_theme_lay == 'Left align'){ ?>
            <a href="#" id="scrollbutton" class="left"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_back_to_top_icon','fas fa-long-arrow-alt-up')); ?> py-4 px-3 rounded-circle"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'construction-realestate' ); ?></span></a>
        <?php }else if($construction_realestate_theme_lay == 'Center align'){ ?>
            <a href="#" id="scrollbutton" class="center"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_back_to_top_icon','fas fa-long-arrow-alt-up')); ?> text-center py-4 px-3 rounded-circle"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'construction-realestate' ); ?></span></a>
        <?php }else{ ?>
            <a href="#" id="scrollbutton"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_back_to_top_icon','fas fa-long-arrow-alt-up')); ?> py-4 px-3 rounded-circle"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'construction-realestate' ); ?></span></a>
    <?php }?>
<?php }?>
<footer role="contentinfo">
    <?php if (get_theme_mod('construction_realestate_show_hide_footer', true)){ ?>

    <?php //Set widget areas classes based on user choice
        $construction_realestate_widget_areas = get_theme_mod('construction_realestate_footer_widget_areas', '4');
        if ($construction_realestate_widget_areas == '3') {
            $construction_realestate_cols = 'col-lg-4 col-md-6 col-sm-12';
        } elseif ($construction_realestate_widget_areas == '4') {
            $construction_realestate_cols = 'col-lg-3 col-md-6 col-sm-12';
        } elseif ($construction_realestate_widget_areas == '2') {
            $construction_realestate_cols = 'col-md-6 col-sm-12';
        } else {
            $construction_realestate_cols = 'col-md-12 col-sm-12';
        }
    ?>
    
    <aside id="sidebar-footer" class="footer-wp" role="complementary">
        <div class="container">
            <div class="row">

                <div class="<?php echo esc_attr($construction_realestate_cols); ?> footer-block wow zoomIn">
                    <?php if (is_active_sidebar('footer-1')) : ?>
                        <?php dynamic_sidebar('footer-1'); ?>
                    <?php else : ?>
                        <aside id="search" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer1', 'construction-realestate'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Search', 'construction-realestate' ); ?></h3>
                            <?php get_search_form(); ?>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($construction_realestate_cols); ?> footer-block wow zoomIn">
                    <?php if (is_active_sidebar('footer-2')) : ?>
                        <?php dynamic_sidebar('footer-2'); ?>
                    <?php else : ?>
                        <aside id="archives" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer2', 'construction-realestate'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Archives', 'construction-realestate' ); ?></h3>
                            <ul>
                                <?php wp_get_archives( array( 'type' => 'monthly' ) ); ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($construction_realestate_cols); ?> footer-block wow zoomIn">
                    <?php if (is_active_sidebar('footer-3')) : ?>
                        <?php dynamic_sidebar('footer-3'); ?>
                    <?php else : ?>
                        <aside id="meta" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer3', 'construction-realestate'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Meta', 'construction-realestate' ); ?></h3>
                            <ul>
                                <?php wp_register(); ?>
                                <li><?php wp_loginout(); ?></li>
                                <?php wp_meta(); ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($construction_realestate_cols); ?> footer-block wow zoomIn">
                    <?php if (is_active_sidebar('footer-4')) : ?>
                        <?php dynamic_sidebar('footer-4'); ?>
                    <?php else : ?>
                        <aside id="categories" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer4', 'construction-realestate'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Categories', 'construction-realestate' ); ?></h3>
                            <ul>
                                <?php wp_list_categories('title_li=');  ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </aside>

    <?php }?>
    <?php if ( get_theme_mod( 'construction_realestate_show_hide_footer_copyright', true ) ) : ?>
    <div class="<?php echo esc_attr(get_theme_mod( 'construction_realestate_sticky_copyright' )? 'sticky-copyright': 'close-sticky'); ?>">
	<div class="copyright-wrapper text-center py-3 px-0">
       <div class="container">
            <p class="m-0"><?php construction_realestate_credit(); ?> <?php echo esc_html(get_theme_mod('construction_realestate_footer_copy',__('By Buywptemplate','construction-realestate'))); ?></p>
            <?php if (get_theme_mod('construction_realestate_show_footer_icons', false)){ ?> 
            <div class="socialicons mt-2">
                <?php if(  get_theme_mod( 'construction_realestate_cont_footer_facebook') != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'construction_realestate_cont_footer_facebook','' ) ); ?>"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_facebook_footer_icon','fab fa-facebook-f')); ?>"></i><span class="screen-reader-text"><?php esc_html_e( 'Facebook','construction-realestate' );?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'construction_realestate_cont_footer_twitter' ) != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'construction_realestate_cont_footer_twitter','' ) ); ?>"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_twitter_footer_icon','fab fa-twitter')); ?>" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Twitter','construction-realestate' );?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'construction_realestate_footer_pinterest') != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'construction_realestate_footer_pinterest','' ) ); ?>"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_pinterest_footer_icon','fab fa-pinterest')); ?>" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Pinterest','construction-realestate' );?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'construction_realestate_footer_tumblr') != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'construction_realestate_footer_tumblr','' ) ); ?>"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_tumblr_footer_icon','fab fa-tumblr')); ?>" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Tumblr','construction-realestate' );?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'construction_realestate_footer_instagram') != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'construction_realestate_footer_instagram','' ) ); ?>"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_instagram_footer_icon','fab fa-instagram')); ?>" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Tumblr','construction-realestate' );?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'construction_realestate_footer_linkedin') != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'construction_realestate_footer_linkedin','' ) ); ?>"><i class="<?php echo esc_attr(get_theme_mod('construction_realestate_linkedin_footer_icon','fab fa-linkedin-in')); ?>" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Tumblr','construction-realestate' );?></span></a>
                <?php } ?>         
            </div>   
            <?php }?>
        </div>
        <div class="clear"></div>
    </div>
    <?php endif;?>
</footer>

<?php wp_footer(); ?>

</body>
</html>