<?php
/**
 * Implements styles set in the theme customizer
 *
 * @package Customizer Library Conica
 */

if ( ! function_exists( 'customizer_library_conica_build_styles' ) && class_exists( 'Customizer_Library_Styles' ) ) :
/**
 * Process user options to generate CSS needed to implement the choices.
 *
 * @since  1.0.0.
 *
 * @return void
 */
function customizer_library_conica_build_styles() {

	$websafe = ( get_theme_mod( 'conica-disable-google-fonts', customizer_library_get_default( 'conica-disable-google-fonts' ) ) == 1 ) ? '-websafe' : '';
	
	// Site Logo Max Width
	$setting = 'conica-logo-max-width';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$logo_max_width = esc_attr( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-branding a.custom-logo-link'
			),
			'declarations' => array(
				'max-width' => $logo_max_width . 'px'
			)
		) );
	}
	
	// Primary Color
	$setting = 'conica-primary-color';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#comments .form-submit #submit,
				.search-block .search-submit,
				.side-aligned-social a.social-icon,
				.no-results-btn,
				.search-block .search-submit,
				.conica-navigation-style-blocks a:hover span,
				.conica-navigation-style-blocks li.current_page_item > a span,
				.conica-navigation-style-blocks li.current_page_ancestor > a span,
				.conica-navigation-style-blocks li.current_page_parent > a span,
				.conica-navigation-style-blocks li.current-menu-item > a span,
				.conica-navigation-style-blocks li.current-menu-parent > a span,
				.main-navigation ul ul li a:hover,
				.main-navigation ul ul li.current-menu-item > a,
				.main-navigation ul ul li.current_page_item > a,
				.main-navigation ul ul li.current-menu-parent > a,
				.main-navigation ul ul li.current_page_parent > a,
				.main-navigation ul ul li.current-menu-ancestor > a,
				.main-navigation ul ul li.current_page_ancestor > a,
				button,
				input[type="button"],
				input[type="reset"],
				input[type="submit"],
				.woocommerce ul.products li.product a.add_to_cart_button, .woocommerce-page ul.products li.product a.add_to_cart_button,
				.woocommerce ul.products li.product .onsale, .woocommerce-page ul.products li.product .onsale,
				.woocommerce button.button.alt,
				.woocommerce-page button.button.alt,
				.woocommerce input.button.alt:hover,
				.woocommerce-page #content input.button.alt:hover,
				.woocommerce .cart-collaterals .shipping_calculator .button,
				.woocommerce-page .cart-collaterals .shipping_calculator .button,
				.woocommerce a.button,
				.woocommerce-page a.button,
				.woocommerce input.button,
				.woocommerce-page #content input.button,
				.woocommerce-page input.button,
				.woocommerce #review_form #respond .form-submit input,
				.woocommerce-page #review_form #respond .form-submit input,
				.woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover,
				.single-product span.onsale,
				.woocommerce nav.woocommerce-pagination ul li span.current,
				.wpcf7-submit'
			),
			'declarations' => array(
				'background' => 'inherit',
                'background-color' => $color
			)
		) );
		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.wp-block-quote:not(.is-large),
				.wp-block-quote:not(.is-style-large)'
			),
			'declarations' => array(
                'border-left-color' => $color
			)
		) );
	}
	
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'a,
				.conica-navigation-style-plain a:hover,
				.conica-navigation-style-plain li.current-menu-item > a,
				.conica-navigation-style-plain li.current_page_item > a,
				.conica-navigation-style-plain li.current-menu-parent > a,
				.conica-navigation-style-plain li.current_page_parent > a,
				.conica-navigation-style-plain li.current-menu-ancestor > a,
				.conica-navigation-style-plain li.current_page_ancestor > a,
				.content-area .entry-content a,
				#comments a,
				.post-edit-link,
				.site-title a,
				.entry-content a,
				.conica-blog-standard-block a,
				.widget ul li a,
				#comments .logged-in-as a,
				.entry-footer a,
				.error-404.not-found .page-header .page-title span,
				.search-button .fa-search,
				.header-cart-checkout.cart-has-items i.fa'
			),
			'declarations' => array(
                'color' => $color . ''
			)
		) );
	}
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.conica-navigation-style-underline a:hover,
				.conica-navigation-style-underline li.current-menu-item > a,
				.conica-navigation-style-underline li.current_page_item > a,
				.conica-navigation-style-underline li.current-menu-parent > a,
				.conica-navigation-style-underline li.current_page_parent > a,
				.conica-navigation-style-underline li.current-menu-ancestor > a,
				.conica-navigation-style-underline li.current_page_ancestor > a'
			),
			'declarations' => array(
                'box-shadow' => '0 -4px ' . $color . ' inset'
			)
		) );
	}
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-header,
				.site-footer-widgets .widgettitle,
				.conica-navigation-style-underline ul ul'
			),
			'declarations' => array(
                'border-color' => $color
			)
		) );
	}
	/* ---------------------------------------- Primary Color -------- */
	

	// Secondary Color
	$setting = 'conica-secondary-color';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.main-navigation button:hover,
				#comments .form-submit #submit:hover,
				.search-block .search-submit:hover,
				.no-results-btn:hover,
				button,
				input[type="button"],
				input[type="reset"],
				input[type="submit"],
				.woocommerce input.button.alt,
				.woocommerce-page #content input.button.alt,
				.woocommerce .cart-collaterals .shipping_calculator .button,
				.woocommerce-page .cart-collaterals .shipping_calculator .button,
				.woocommerce a.button:hover,
				.woocommerce-page a.button:hover,
				.woocommerce input.button:hover,
				.woocommerce-page #content input.button:hover,
				.woocommerce-page input.button:hover,
				.woocommerce ul.products li.product a.add_to_cart_button:hover, .woocommerce-page ul.products li.product a.add_to_cart_button:hover,
				.woocommerce button.button.alt:hover,
				.woocommerce-page button.button.alt:hover,
				.woocommerce #review_form #respond .form-submit input:hover,
				.woocommerce-page #review_form #respond .form-submit input:hover,
				.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
				.wpcf7-submit:hover'
			),
			'declarations' => array(
				'background' => 'inherit',
                'background-color' => $color
			)
		) );
	}
	
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'a:hover,
				.header-top-bar-left .header-social-icon:hover,
				.widget-area .widget a:hover,
				.site-footer-widgets .widget a:hover,
				.site-footer .widget a:hover,
				.search-btn:hover,
				.search-button .fa-search:hover,
				.woocommerce #content div.product p.price,
				.woocommerce-page #content div.product p.price,
				.woocommerce-page div.product p.price,
				.woocommerce #content div.product span.price,
				.woocommerce div.product span.price,
				.woocommerce-page #content div.product span.price,
				.woocommerce-page div.product span.price,
				.woocommerce #content div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce-page div.product .woocommerce-tabs ul.tabs li.active'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Body Font
	$setting = 'conica-body-font'.$websafe;
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
	if ( $websafe ) {
		$stack = '\''.$mod.'\', sans-serif';
	} else {
		$stack = customizer_library_get_font_stack( $mod );
	}

	if ( $mod != customizer_library_get_default( $setting ) || get_theme_mod( 'conica-disable-google-fonts' ) == 1 ) {

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'body,
				.main-navigation ul li a,
				.widget-area .widget a'
			),
			'declarations' => array(
				'font-family' => $stack
			)
		) );

	}
	
	// Body Font Color
	$setting = 'conica-body-font-color';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'body,
                .widget-area .widget a'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Heading Font
	$setting = 'conica-heading-font'.$websafe;
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
	if ( $websafe ) {
		$stack = '\''.$mod.'\', sans-serif';
	} else {
		$stack = customizer_library_get_font_stack( $mod );
	}

	if ( $mod != customizer_library_get_default( $setting ) || get_theme_mod( 'conica-disable-google-fonts' ) == 1 ) {

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'h1, h2, h3, h4, h5, h6,
                h1 a, h2 a, h3 a, h4 a, h5 a, h6 a,
                .widget-area .widget-title,
                .woocommerce table.cart th,
                .woocommerce-page #content table.cart th,
                .woocommerce-page table.cart th,
                .woocommerce input.button.alt,
                .woocommerce-page #content input.button.alt,
                .woocommerce table.cart input,
                .woocommerce-page #content table.cart input,
                .woocommerce-page table.cart input,
                button, input[type="button"],
                input[type="reset"],
                input[type="submit"]',
			),
			'declarations' => array(
				'font-family' => $stack
			)
		) );

	}
	
	// Heading Font Color
	$setting = 'conica-heading-font-color';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'h1, h2, h3, h4, h5, h6,
                h1 a, h2 a, h3 a, h4 a, h5 a, h6 a,
                .widget-area .widget-title'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}
	
	// Site Title Font
	$setting = 'conica-title-font'.$websafe;
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
	if ( $websafe ) {
		$stack = '\''.$mod.'\', sans-serif';
	} else {
		$stack = customizer_library_get_font_stack( $mod );
	}

	if ( $mod != customizer_library_get_default( $setting ) || get_theme_mod( 'conica-disable-google-fonts' ) == 1 ) {

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-title a'
			),
			'declarations' => array(
				'font-family' => $stack
			)
		) );

	}
	$setting = 'conica-shop-remove-cat-count';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$widget_title_size = esc_attr( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'ul.products mark.count'
			),
			'declarations' => array(
				'display' => 'none'
			)
		) );
	}
	
}
endif;

add_action( 'customizer_library_styles', 'customizer_library_conica_build_styles' );

if ( ! function_exists( 'customizer_library_conica_styles' ) ) :
/**
 * Generates the style tag and CSS needed for the theme options.
 *
 * By using the "Customizer_Library_Styles" filter, different components can print CSS in the header.
 * It is organized this way to ensure there is only one "style" tag.
 *
 * @since  1.0.0.
 *
 * @return void
 */
function customizer_library_conica_styles() {

	do_action( 'customizer_library_styles' );

	// Echo the rules
	$css = Customizer_Library_Styles()->build();

	if ( ! empty( $css ) ) {
		echo "\n<!-- Begin Custom CSS -->\n<style type=\"text/css\" id=\"conica-custom-css\">\n";
		echo $css;
		echo "\n</style>\n<!-- End Custom CSS -->\n";
	}
}
endif;

add_action( 'wp_head', 'customizer_library_conica_styles', 11 );