<?php
/**
 * The template part for displaying content
 *
 *
 * @package Conary
 * @since Conary 1.0
 */
?>
<?php $entry_class = is_single() ? '' : 'view-classic'; ?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $entry_class ); ?>>

	<header class="entry-header">
		<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
			<span class="sticky-post"><?php esc_html_e( 'Featured', 'conary' ); ?></span>
		<?php endif; ?>


		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>

		<div class="entry-meta">
			<?php
				conary_entry_meta();
				conary_edit_post_link();
			?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->

	<?php conary_post_thumbnail(); ?>

	<div class="entry-content">
		<?php
			the_content( __('Read More', 'conary') );

			echo '<p>';
			conary_entry_tags();
			echo '</p>';

			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'conary' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'conary' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

			if ( is_single() && '' !== get_the_author_meta( 'description' ) ) {
				get_template_part( 'template-parts/biography' );
			}

		?>
	</div><!-- .entry-content -->

</article><!-- #post-## -->
