<?php
/**
 * Conary Customizer functionality
 *
 *
 * @package Conary
 * @since Conary 1.0
 */


function conary_customize_register( $wp_customize ) {

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	$wp_customize->remove_setting('background_color');
	$wp_customize->remove_control('background_color');

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'				=> '.site-title a',
			'container_inclusive'	=> false,
			'render_callback'     	=> 'conary_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector' 				=> '.site-description',
			'container_inclusive' 	=> false,
			'render_callback'     	=> 'conary_customize_partial_blogdescription',
		) );
	}

	// Panel : Color
	$wp_customize->add_panel( 'panel_colors', array(
		'title'		=> esc_html__( 'Colors', 'conary' ),
		'priority'	=> 20,
	) );

	// Section : Header Color
	$wp_customize->add_section( 'header_colors', array(
		'title'     => esc_html__( 'Header Colors', 'conary' ),
		'panel'     => 'panel_colors',
	) );

	// Section : Content Color
	$wp_customize->add_section( 'content_colors', array(
		'title'     => esc_html__( 'Content Colors', 'conary' ),
		'panel'     => 'panel_colors',
	) );

	// Section : Footer Color
	$wp_customize->add_section( 'footer_colors', array(
		'title'     => esc_html__( 'Footer Colors', 'conary' ),
		'panel'     => 'panel_colors',
	) );

	// Section : Posts Options
	$wp_customize->add_section('posts_options', array (
		'title'		 => esc_html__('Posts Options', 'conary'),
	) );

	// Section : Footer Options
	$wp_customize->add_section('footer_options', array (
		'title'		 => esc_html__('Footer Options', 'conary'),
	) );

}
add_action( 'conary_before_customize_wrapper', 'conary_customize_register' );

/**
 * List of customizer settings
 * See function conary_customizer_wrapper_settings at customizer-simple.php
 * customizer framework with css applier
 */
function conary_customize_items( $settings ) {

	/* Settings for Posts Options start here */
	/* ------------------------------------- */

	// Setting : Homepage blog list
	$settings[] = array(
		'default'			=> 'classic',
		'sanitize_callback' => 'conary_sanitize_blog_list_view',
		'id'				=> 'blog_list_view',
		'label'				=> esc_html__('Homepage/Blog posts shown as', 'conary'),
		'type'				=> 'radio',
		'choices'			=> array (
			'classic'	=> esc_html__( 'Classic View (Full Posts)', 'conary' ),
			'list'		=> esc_html__( 'List View (Small Thumbnail & excerpt)', 'conary' )
		 ),
		'section'			=> 'posts_options'
	);

	// Setting : Archive list
	$settings[] = array(
		'default'			=> 'list',
		'sanitize_callback' => 'conary_sanitize_blog_list_view',
		'id'				=> 'archive_list_view',
		'label'				=> esc_html__('Archive page posts shown as', 'conary'),
		'type'				=> 'radio',
		'choices'			=> array (
			'classic'	=> esc_html__( 'Classic View (Full Posts)', 'conary' ),
			'list'		=> esc_html__( 'List View (Small Thumbnail & excerpt)', 'conary' )
		 ),
		'section'			=> 'posts_options'
	);

	// Setting : Search result list
	$settings[] = array(
		'default'			=> 'list',
		'sanitize_callback' => 'conary_sanitize_blog_list_view',
		'id'				=> 'search_result_list_view',
		'label'				=> esc_html__('Search result posts shown as', 'conary'),
		'type'				=> 'radio',
		'choices'			=> array (
			'classic'	=> esc_html__( 'Classic View (Full Posts)', 'conary' ),
			'list'		=> esc_html__( 'List View (Small Thumbnail & excerpt)', 'conary' )
		 ),
		'section'			=> 'posts_options'
	);

	// Setting : Pagination or load more button
	$settings[] = array(
		'default'			=> false,
		'sanitize_callback' => 'conary_sanitize_checkbox',
		'id'				=> 'pagination_load_more',
		'label'				=> esc_html__('Using ajax load more button instead of default pagination', 'conary'),
		'type'				=> 'checkbox',
		'section'			=> 'posts_options'
	);

	if ( class_exists( 'Jetpack_RelatedPosts' ) ) {
		// Setting : Related Post Title in the single page, if the Jetpack Related Posts active
		$settings[] =array(
			'default'			=> esc_html__('Related Posts', 'conary'),
			'sanitize_callback' => 'sanitize_text_field',
			'id'				=> 'related_posts_title',
			'label'				=> esc_html__('Related Post Title in Single Post', 'conary'),
			'type'				=> 'text',
			'section'			=> 'posts_options',
		);
	}

	// Setting : Highlighted Posts Tag
	$settings[] = array(
		'default'			=> 'headline',
		'sanitize_callback' => 'sanitize_text_field',
		'id'				=> 'highlighted_posts',
		'label'				=> esc_html__('Tags for highlighted posts', 'conary'),
		'description'		=> esc_html__('Any posts tagged with this will shown bolder with overlayed image in the archive list', 'conary'),
		'type'				=> 'text',
		'section'			=> 'posts_options'
	);

	/* Settings for Footer Options start here */
	/* ------------------------------------- */

	// Setting : Credit text
	$settings[] = array(
		'default'			=> conary_footer_credit(),
		'sanitize_callback' => 'conary_sanitize_footer_credit',
		'id'				=> 'footer_credit',
		'label'				=> esc_html__('Credit Text', 'conary'),
		'type'				=> 'textarea',
		'transport'			=> 'postMessage',
		'section'			=> 'footer_options'
	);

	/* Settings for Header Colors start here */
	/* ------------------------------------- */

	// Setting : Color Schemes
	$settings[] = array(
		'default'			=> 'default',
		'sanitize_callback' => 'sanitize_text_field',
		'id'				=> 'header_color_scheme',
		'label'				=> esc_html__('Header Color Scheme', 'conary'),
		'type'				=> 'select',
		'choices'			=> conary_color_schemes_control( conary_header_color_schemes() ),
		'transport'			=> 'postMessage',
		'section'			=> 'header_colors'
	);

	// Setting : Header background color
	$settings[] = array(
		'default'			=> '#ffffff',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'header_background_color',
		'label'				=> esc_html__('Header Background Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'header_colors',
		'apply_css'			=>
			array (
				array (
					'selector' => '.site-header, .main-navigation ul ul li',
					'property' => 'background-color',
				),
				array (
					'selector' =>
						  '.main-navigation ul ul:after',
					'property' => 'border-top-color'
				),
				array (
					'selector' =>
						  '.main-navigation ul ul:after',
					'property' => 'border-bottom-color'
				),

			),
	);

	// Setting : Header link color
	$settings[] = array(
		'default'			=> '#000000',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'header_menu_color',
		'label'				=> esc_html__('Header Menu Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'header_colors',
		'apply_css'			=>
			array (
				array (
					'selector' =>
						  '.site-header, '
						. ' .menu-toggle, '
						. '.dropdown-toggle, '
						. '.dropdown-toggle ',
					'property' => 'color',
				)
			),
	);

	// Setting : Header menu hover color
	$settings[] = array(
		'default'			=> '#ff0036',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'header_menu_hover_color',
		'label'				=> esc_html__('Header Menu Hover Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'header_colors',
		'apply_css'			=>
			array (
				array (
					'selector' =>
						  '.site-branding .site-title a:hover, '
						. '.site-branding .site-title a:focus, '
						. '.main-navigation a:hover,'
						. '.main-navigation a:focus,'
						. '.menu-toggle.toggled-on, '
						. '.menu-toggle.toggled-on:hover, '
						. '.menu-toggle.toggled-on:focus, '
						. '.menu-toggle:hover, '
						. '.menu-toggle:focus, '
						. '.dropdown-toggle:hover, '
						. '.dropdown-toggle:focus, '
						. '.search-toggle.toggled-on, '
						. '.search-submit:hover, '
						. '.search-submit:focus, '
						. '.search-toggle:hover, '
						. '.search-toggle:focus ',
					'property' => 'color',
				)
			),
	);

	// Setting : Header borders color
	$settings[] = array(
		'default'			=> '#dddddd',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'header_border_color',
		'label'				=> esc_html__('Header Borders Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'header_colors',
		'apply_css'			=>
			array (
				array (
					'selector' =>
						  '.main-navigation ul ul, '
						. '.main-navigation ul ul li, '
						. '.main-navigation li, '
						. '.dropdown-toggle:after, '
						. '.main-navigation .primary-menu, '
						. '.site-breadcrumbs, '
						. '.site-header-menu, '
						. '.site-header .search-form ',
					'property' => 'border-color',
				),
				array (
					'selector' =>
						  '.main-navigation ul ul:before',
					'property' => 'border-top-color'
				),
				array (
					'selector' =>
						  '.main-navigation ul ul:before',
					'property' => 'border-bottom-color'
				),
			),
	);

	/* Settings for Content Colors start here */
	/* ------------------------------------- */

	// Setting : Color Schemes
	$settings[] = array(
		'default'			=> 'default',
		'sanitize_callback' => 'sanitize_text_field',
		'id'				=> 'content_color_scheme',
		'label'				=> esc_html__('Content Color Scheme', 'conary'),
		'type'				=> 'select',
		'choices'			=> conary_color_schemes_control( conary_content_color_schemes() ),
		'transport'			=> 'postMessage',
		'section'			=> 'content_colors'
	);

	// Setting : Content background color
	$settings[] = array(
		'default'			=> '#f7f7f7',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'content_background_color',
		'label'				=> esc_html__('Content Box Background Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'content_colors',
		'apply_css'			=> array (
			array (
				'selector' => '.site, .site-breadcrumbs, .widget .widget-title > span, .posts-slider:not(.image-overlay-view) .flex-direction-nav, .widget-recent-posts .image-overlay-view.posts-slider .flex-direction-nav li, .site-featured-posts .flex-direction-nav li a',
				'property' => 'background-color',
			),
			array (
				'selector' =>
					  'mark, '
					. 'ins, '
					. 'button, '
					. 'button[disabled]:hover, '
					. 'button[disabled]:focus, '
					. 'input[type="button"], '
					. 'input[type="button"][disabled]:hover, '
					. 'input[type="button"][disabled]:focus, '
					. 'input[type="reset"], '
					. 'input[type="reset"][disabled]:hover, '
					. 'input[type="reset"][disabled]:focus, '
					. 'input[type="submit"], '
					. 'input[type="submit"][disabled]:hover, '
					. 'input[type="submit"][disabled]:focus, '
					. '.load-more a, '
					. '.load-more a:hover, '
					. '.load-more a:focus, '
					. '.widget_calendar tbody a, '
					. '.widget_calendar tbody a:hover, '
					. '.widget_calendar tbody a:focus, '
					. '.tagcloud a, '
					. '.page-links a, '
					. '.page-links a:hover, '
					. '.page-links a:focus ',
				'property' => 'color'
			),
		)
	);

	// Setting : Content text color
	$settings[] = array(
		'default'			=> '#000000',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'content_text_color',
		'label'				=> esc_html__('Content Text Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'content_colors',
		'apply_css'			=> array (
			array (
				'selector' =>
					  'body, '
					. 'blockquote cite, '
					. 'blockquote small, '
					. '.widget-title a, '
					. '.page-links > .page-links-title, '
					. '.pagination a:hover, '
					. '.pagination a:focus, '
					. '.sharedaddy ul li a:hover, '
					. '.sharedaddy ul li a:focus, '
					. '.widget-recent-posts .tab-control a.active-tab-control, '
					. '.comment-author, '
					. '.comment-reply-title small a:hover, '
					. '.comment-reply-title small a:focus, '
					. '#jp-relatedposts .jp-relatedposts-items .jp-relatedposts-post .jp-relatedposts-post-title a ',
				'property' => 'color',
			),
			array (
				'selector' =>
					  'blockquote, '
					. '.widget, '
					. '.page-header, '
					. '.page-links a ',
				'property' => 'border-color'
			),
			array (
				'selector' =>
					  'mark, '
					. 'ins, '
					. 'button:hover, '
					. 'button:focus, '
					. 'input[type="button"]:hover, '
					. 'input[type="button"]:focus, '
					. 'input[type="reset"]:hover, '
					. 'input[type="reset"]:focus, '
					. 'input[type="submit"]:hover, '
					. 'input[type="submit"]:focus, '
					. '.load-more a:hover, '
					. '.load-more a:focus, '
					. '.tagcloud a:hover, '
					. '.tagcloud a:focus, '
					. '.widget_calendar tbody a, '
					. '.page-links a ',
				'property' => 'background-color'
			)
		)
	);

	// Setting : Content link color
	$settings[] = array(
		'default'			=> '#ff0036',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'content_link_color',
		'label'				=> esc_html__('Content Link Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'content_colors',
		'apply_css'			=> array (
			array (
				'selector' =>
					  'a, '
					. '.post-navigation a:hover .post-title, '
					. '.post-navigation a:focus .post-title, '
					. '.entry-title a:hover, '
					. '.entry-title a:focus, '
					. '.entry-meta .cat-links a, '
					. '.pingback .comment-edit-link:hover, '
					. '.pingback .comment-edit-link:focus, '
					. '.comment-reply-link, '
					. '.comment-reply-link:hover, '
					. '.comment-reply-link:focus, '
					. '.required, '
					. '#jp-relatedposts .jp-relatedposts-items .jp-relatedposts-post .jp-relatedposts-post-title a:hover,'
					. '#jp-relatedposts .jp-relatedposts-items .jp-relatedposts-post .jp-relatedposts-post-title a:focus ',
				'property' => 'color',
			),
			array (
				'selector' =>
					  'button, '
					. 'button[disabled]:hover, '
					. 'button[disabled]:focus, '
					. 'input[type="button"], '
					. 'input[type="button"][disabled]:hover, '
					. 'input[type="button"][disabled]:focus, '
					. 'input[type="reset"], '
					. 'input[type="reset"][disabled]:hover, '
					. 'input[type="reset"][disabled]:focus, '
					. 'input[type="submit"], '
					. 'input[type="submit"][disabled]:hover, '
					. 'input[type="submit"][disabled]:focus, '
					. '.load-more a, '
					. '.tagcloud a, '
					. '.page-links a:hover, '
					. '.page-links a:focus ',
				'property' => 'background-color'
			)
		)
	);

	// Setting : Content meta color
	$settings[] = array(
		'default'			=> '#888888',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'content_meta_color',
		'label'				=> esc_html__('Content Meta Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'content_colors',
		'apply_css'			=> array(
			array (
				'selector' =>
					  'blockquote, '
					. '.post-password-form label, '
					. '.post-navigation .meta-nav, '
					. '.image-navigation, '
					. '.comment-navigation, '
					. 'body:not(.search-results) .entry-summary, '
					. '.widget_recent_entries .post-date, '
					. '.widget_rss .rss-date, '
					. '.widget_rss cite, '
					. '.author-bio, '
					. '.entry-meta, '
					. '.entry-meta a, '
					. '.sticky-post, '
					. '.site-breadcrumbs, '
					. '.site-breadcrumbs a, '
					. '.widget-recent-posts .tab-control a, '
					. '.taxonomy-description, '
					. '.entry-caption, '
					. '.comment-metadata, '
					. '.pingback .edit-link, '
					. '.sharedaddy ul li a, '
					. '.comment-metadata a, '
					. '.pingback .comment-edit-link, '
					. '.comment-notes, '
					. '.comment-awaiting-moderation, '
					. '.logged-in-as, '
					. '.form-allowed-tags, '
					. '.wp-caption .wp-caption-text, '
					. '.gallery-caption, '
					. '.widecolumn label, '
					. '.entry-meta > span:before, '
					. '.widecolumn .mu_register label, '
					. '.site-content #jp-relatedposts .jp-relatedposts-items .jp-relatedposts-post .jp-relatedposts-post-context, '
					. '.site-content #jp-relatedposts .jp-relatedposts-items .jp-relatedposts-post .jp-relatedposts-post-date ',
				'property' => 'color'
			),
			array (
				'selector' =>
					  '.widget_calendar tbody a:hover,'
					. '.widget_calendar tbody a:focus',
				'property' => 'background-color'
			),
			array (
				'selector' => '#wave-content',
				'property' => 'fill'
			)
		)
	);

	// Setting : Content border color
	$settings[] = array(
		'default'			=> '#dddddd',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'content_border_color',
		'label'				=> esc_html__('Content Border Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'content_colors',
		'apply_css'			=> array (
			array (
				'selector' =>
					  'fieldset, '
					. 'pre, '
					. 'abbr, '
					. 'acronym, '
					. 'table, '
					. 'th, '
					. 'td, '
					. 'input[type="date"], '
					. 'input[type="time"], '
					. 'input[type="datetime-local"], '
					. 'input[type="week"], '
					. 'input[type="month"], '
					. 'input[type="text"], '
					. 'input[type="email"], '
					. 'input[type="url"], '
					. 'input[type="password"], '
					. 'input[type="search"], '
					. 'input[type="tel"], '
					. 'input[type="number"], '
					. 'textarea, '
					. '.site-content .search-form, '
					. '.view-list, '
					. '.page .site-main > article.view-list, '
					. '.view-classic, '
					. '.page .site-main > article.view-classic, '
					. '.content-area .has-post-thumbnail.overlay-thumbnail, '
					. '.widget-twitter .twitter-account, '
					. '.single .entry-title ~ .entry-meta > span:nth-child(2), '
					. '.view-classic .entry-title ~ .entry-meta > span:nth-child(2), '
					. '.sharedaddy ul li, '
					. '.widget-recent-posts .tab-control a:first-child, '
					. '.comments-title, '
					. '.comment-reply-title, '
					. '.post-navigation, '
					. '.post-navigation div + div, '
					. '.image-navigation, '
					. '.comment-navigation, '
					. '.entry-content, '
					. '.entry-summary, '
					. '.site-main #jp-relatedposts, '
					. '.pagination, '
					. '.pagination .next, '
					. '.pagination .prev, '
					. '.page-links a, '
					. '.page-links > span, '
					. '.comment-list article, '
					. '.comment-list .pingback, '
					. '.comment-list .trackback, '
					. '.comment-reply-link, '
					. '.no-comments, '
					. '.widecolumn .mu_register .mu_alert ',
				'property' => 'border-color'
			)
		)
	);

	/* Settings for Footer Colors start here */
	/* ------------------------------------- */

	// Setting : Color Schemes
	$settings[] = array(
		'default'			=> 'default',
		'sanitize_callback' => 'sanitize_text_field',
		'id'				=> 'footer_color_scheme',
		'label'				=> esc_html__('Footer Color Scheme', 'conary'),
		'type'				=> 'select',
		'choices'			=> conary_color_schemes_control( conary_footer_color_schemes() ),
		'transport'			=> 'postMessage',
		'section'			=> 'footer_colors'
	);

	// Setting : Footer background color
	$settings[] = array(
		'default'			=> '#ffffff',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'footer_background_color',
		'label'				=> esc_html__('Footer Background Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'footer_colors',
		'apply_css'			=> array (
			array (
				'selector' =>
					  '.site-footer, '
					. '.footer-widgets-container:after,'
					. '.site-footer .widget ',
				'property' => 'background-color'
			),
			array (
				'selector' =>
					  '.site-footer mark, '
					. '.site-footer ins, '
					. '.site-footer button, '
					. '.site-footer button[disabled]:hover, '
					. '.site-footer button[disabled]:focus, '
					. '.site-footer input[type="button"], '
					. '.site-footer input[type="button"][disabled]:hover, '
					. '.site-footer input[type="button"][disabled]:focus, '
					. '.site-footer input[type="reset"], '
					. '.site-footer input[type="reset"][disabled]:hover, '
					. '.site-footer input[type="reset"][disabled]:focus, '
					. '.site-footer input[type="submit"], '
					. '.site-footer input[type="submit"][disabled]:hover, '
					. '.site-footer input[type="submit"][disabled]:focus, '
					. '.site-footer .widget_calendar tbody a, '
					. '.site-footer .widget_calendar tbody a:hover, '
					. '.site-footer .widget_calendar tbody a:focus, '
					. '.site-footer .tagcloud a ',
				'property' => 'color'
			),
		)

	);

	// Setting : Footer text color
	$settings[] = array(
		'default'			=> '#000000',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'footer_text_color',
		'label'				=> esc_html__('Footer Text Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'footer_colors',
		'apply_css'			=> array (
			array (
				'selector' =>
					  '.site-footer, '
					. '.site-footer blockquote cite, '
					. '.site-footer blockquote small, '
					. '.footer-widget .widget-title, '
					. '.site-footer .social-navigation ul li a:hover, '
					. '.site-footer .footer-navigation ul li a ',
				'property' => 'color',
			),
			array (
				'selector' =>
					  '.site-footer button:hover, '
					. '.site-footer button:focus, '
					. '.site-footer input[type="button"]:hover, '
					. '.site-footer input[type="button"]:focus, '
					. '.site-footer input[type="reset"]:hover, '
					. '.site-footer input[type="reset"]:focus, '
					. '.site-footer input[type="submit"]:hover, '
					. '.site-footer input[type="submit"]:focus, '
					. '.site-footer .tagcloud a:hover, '
					. '.site-footer .tagcloud a:focus ',
				'property' => 'background-color'
			)
		)
	);

	// Setting : Footer link color
	$settings[] = array(
		'default'			=> '#ff0036',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'footer_link_color',
		'label'				=> esc_html__('Footer Link Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'footer_colors',
		'apply_css'			=> array (
			array (
				'selector' =>
					  '.site-footer a, '
					. '.site-footer .entry-title a:hover, '
					. '.site-footer .entry-title a:focus, '
					. '.site-footer .entry-meta .cat-links a, '
					. '.site-footer .footer-navigation ul li a:hover, '
					. '.site-footer .footer-navigation ul li a:focus ',
				'property' => 'color',
			),
			array (
				'selector' =>
					  '.site-footer mark, '
					. '.site-footer ins, '
					. '.site-footer button, '
					. '.site-footer button[disabled]:hover, '
					. '.site-footer button[disabled]:focus, '
					. '.site-footer input[type="button"], '
					. '.site-footer input[type="button"][disabled]:hover, '
					. '.site-footer input[type="button"][disabled]:focus, '
					. '.site-footer input[type="reset"], '
					. '.site-footer input[type="reset"][disabled]:hover, '
					. '.site-footer input[type="reset"][disabled]:focus, '
					. '.site-footer input[type="submit"], '
					. '.site-footer input[type="submit"][disabled]:hover, '
					. '.site-footer input[type="submit"][disabled]:focus, '
					. '.site-footer .tagcloud a, '
					. '.site-footer .widget_calendar tbody a ',
				'property' => 'background-color'
			)
		)
	);

	// Setting : Footer meta color
	$settings[] = array(
		'default'			=> '#888888',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'footer_meta_color',
		'label'				=> esc_html__('Footer Meta Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'footer_colors',
		'apply_css'			=> array(
			array (
				'selector' =>
					  '.site-footer blockquote, '
					. '.site-footer .widget_recent_entries .post-date, '
					. '.site-footer .widget_rss .rss-date, '
					. '.site-footer .widget_rss cite, '
					. '.site-footer .entry-meta, '
					. '.site-footer .entry-meta a, '
					. '.site-footer .social-navigation ul li a, '
					. '.site-info, '
					. '.site-info a ',
				'property' => 'color'
			),
			array (
				'selector' =>
					  '.site-footer .widget_calendar tbody a:hover,'
					. '.site-footer .widget_calendar tbody a:focus',
				'property' => 'background-color'
			),
			array (
				'selector' => '.social-navigation a ',
				'property' => 'border-color'
			),
			array (
				'selector' => '#wave-footer',
				'property' => 'fill'
			)
		)

	);

	// Setting : Footer border color
	$settings[] = array(
		'default'			=> '#dddddd',
		'sanitize_callback' => 'conary_sanitize_color_field',
		'id'				=> 'footer_border_color',
		'label'				=> esc_html__('Footer Border Color', 'conary'),
		'type'				=> 'color',
		'transport'			=> 'postMessage',
		'section'			=> 'footer_colors',
		'apply_css'			=> array (
			array (
				'selector' =>
					  '.site-footer fieldset, '
					. '.site-footer pre, '
					. '.site-footer abbr, '
					. '.site-footer acronym, '
					. '.site-footer table, '
					. '.site-footer th, '
					. '.site-footer td, '
					. '.site-footer input[type="date"], '
					. '.site-footer input[type="time"], '
					. '.site-footer input[type="datetime-local"], '
					. '.site-footer input[type="week"], '
					. '.site-footer input[type="month"], '
					. '.site-footer input[type="text"], '
					. '.site-footer input[type="email"], '
					. '.site-footer input[type="url"], '
					. '.site-footer input[type="password"], '
					. '.site-footer input[type="search"], '
					. '.site-footer input[type="tel"], '
					. '.site-footer input[type="number"], '
					. '.site-footer textarea, '
					. '.site-footer .search-form, '
					. '.site-footer .widget-twitter .twitter-account, '
					. '.footer-widgets-container .widget-area, '
					. '.social-navigation + .site-info, '
					. '.footer-navigation + .site-info, '
					. '.footer-widgets-container .widget-area-full .widget, '
					. '.site-footer .footer-widgets-container + .social-navigation, '
					. '.site-footer .footer-widgets-container + .footer-navigation,'
					. '.footer-widgets-container + .site-info ',
				'property' => 'border-color'
			)
		)
	);

	return $settings;

}
add_filter('conary_customizer_wrapper_settings', 'conary_customize_items' );
add_filter('conary_apply_customizer_css', 'conary_customize_items' );

function conary_color_schemes_control( $schemes ) {
	$schemes_control = array();
	foreach ( $schemes as $scheme ) {
		$schemes_control[json_encode( $scheme['colors'] )] = $scheme['label'];
	}
	return $schemes_control;
}

function conary_header_color_schemes() {
	$schemes = array (
		array (
			'label' => esc_html__( 'Default', 'conary' ),
			'colors' => array (
				'header_background_color'	=> '#ffffff',
				'header_menu_color'			=> '#000000',
				'header_menu_hover_color'	=> '#ff0036',
				'header_border_color'		=> '#dddddd'
			),
		),
		array (
			'label' => esc_html__( 'Dark', 'conary' ),
			'colors' => array (
				'header_background_color'	=> '#111111',
				'header_menu_color' 		=>'#ffffff',
				'header_menu_hover_color' 	=> '#fffc51',
				'header_border_color' 		=> '#252525'
			),
		),
		array (
			'label' => esc_html__( 'Dark Blue', 'conary' ),
			'colors' => array (
				'header_background_color'	=> '#191937',
				'header_menu_color' 		=>'#ffffff',
				'header_menu_hover_color' 	=> '#ff0055',
				'header_border_color' 		=> '#303651'
			),
		),
	);

	return $schemes;
}

function conary_content_color_schemes() {
	$schemes = array (
		array (
			'label' => esc_html__( 'Default', 'conary' ),
			'colors' => array (
				'content_background_color'	=> '#f7f7f7',
				'content_text_color'		=> '#000000',
				'content_meta_color'		=> '#888888',
				'content_link_color'		=> '#ff0036',
				'content_border_color'		=> '#dddddd'
			),
		),
		array (
			'label' => esc_html__( 'Dark', 'conary' ),
			'colors' => array (
				'content_background_color'	=> '#111111',
				'content_text_color'		=> '#ffffff',
				'content_meta_color'		=> '#444444',
				'content_link_color'		=> '#fffc51',
				'content_border_color'		=> '#252525'
			),
		),
		array (
			'label' => esc_html__( 'Dark Blue', 'conary' ),
			'colors' => array (
				'content_background_color'	=> '#191937',
				'content_text_color'		=> '#ffffff',
				'content_meta_color'		=> '#42466b',
				'content_link_color'		=> '#ff0055',
				'content_border_color'		=> '#303651'
			),
		),
	);

	return $schemes;
}

function conary_footer_color_schemes() {
	$schemes = array (
		array (
			'label' => esc_html__( 'Default', 'conary' ),
			'colors' => array (
				'footer_background_color'	=> '#ffffff',
				'footer_text_color'			=> '#000000',
				'footer_meta_color'			=> '#888888',
				'footer_link_color'			=> '#ff0036',
				'footer_border_color'		=> '#dddddd'
			),
		),
		array (
			'label' => esc_html__( 'Dark', 'conary' ),
			'colors' => array (
				'footer_background_color'	=> '#111111',
				'footer_text_color'			=> '#ffffff',
				'footer_meta_color'			=> '#444444',
				'footer_link_color'			=> '#fffc51',
				'footer_border_color'		=> '#252525'
			),
		),
		array (
			'label' => esc_html__( 'Dark Blue', 'conary' ),
			'colors' => array (
				'footer_background_color'	=> '#191937',
				'footer_text_color'		=> '#ffffff',
				'footer_meta_color'		=> '#42466b',
				'footer_link_color'		=> '#ff0055',
				'footer_border_color'		=> '#303651'
			),
		),
	);

	return $schemes;
}

function conary_partial_refresh_settings( $wp_customize ) {

	if ( ! isset( $wp_customize->selective_refresh ) ) return;

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'container_inclusive' => false,
		'render_callback' => 'conary_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'container_inclusive' => false,
		'render_callback' => 'conary_customize_partial_blogdescription',
	) );

	$wp_customize->selective_refresh->add_partial( 'footer_credit', array(
		'selector' => '.site-info',
		'container_inclusive' => false,
		'render_callback' => 'conary_customize_partial_footer_credit',
	) );

}
add_action( 'conary_after_customize_wrapper', 'conary_partial_refresh_settings' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @since Conary 1.0
 * @see conary_customize_register()
 *
 * @return void
 */
function conary_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since Conary 1.0
 * @see conary_customize_register()
 *
 * @return void
 */
function conary_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since Conary 1.2
 * @see conary_customize_register()
 *
 * @return void
 */
function conary_customize_partial_footer_credit() {
	if ( $footer_credit = get_theme_mod( 'footer_credit', false ) ) {
		echo conary_sanitize_footer_credit( $footer_credit );
	} else {
		conary_footer_credit(true);
	}
}

/**
 * Sets up the WordPress core custom header and custom background features.
 *
 * @since Conary 1.0
 *
 * @see conary_header_style()
 */
function conary_custom_header_and_background() {
	/**
	 * Filter the arguments used when adding 'custom-background' support in Conary.
	 *
	 * @since Conary 1.0
	 *
	 * @param array $args {
	 *     An array of custom-background support arguments.
	 *
	 *     @type string $default-color Default color of the background.
	 * }
	 */
	add_theme_support( 'custom-background', apply_filters( 'conary_custom_background_args', array(
		'default-color' => '#eeeeee',
	) ) );

	/**
	 * Filter the arguments used when adding 'custom-header' support in Twenty Sixteen.
	 *
	 * @since Twenty Sixteen 1.0
	 *
	 * @param array $args {
	 *     An array of custom-header support arguments.
	 *
	 *     @type string $default-text-color Default color of the header text.
	 *     @type int      $width            Width in pixels of the custom header image. Default 1200.
	 *     @type int      $height           Height in pixels of the custom header image. Default 280.
	 *     @type bool     $flex-height      Whether to allow flexible-height header images. Default true.
	 *     @type callable $wp-head-callback Callback function used to style the header image and text
	 *                                      displayed on the blog.
	 * }
	 */
	/*add_theme_support( 'custom-header', apply_filters( 'conary_custom_header_args', array(
		'width'                  => 1200,
		'height'                 => 280,
		'flex-height'            => true,
		'wp-head-callback'       => 'conary_header_style',
	) ) );*/

}
add_action( 'after_setup_theme', 'conary_custom_header_and_background' );

if ( ! function_exists( 'conary_header_style' ) ) :
/**
 * Styles the header text displayed on the site.
 *
 * Create your own conary_header_style() function to override in a child theme.
 *
 * @since Conary 1.0
 *
 * @see conary_custom_header_and_background().
 */
function conary_header_style() {
	// If the header text option is untouched, let's bail.
	if ( display_header_text() ) {
		return;
	}

	// If the header text has been hidden.
	?>
	<style type="text/css" id="conary-header-css">
		.site-branding {
			margin: 0 auto 0 0;
		}

		.site-branding .site-title,
		.site-description {
			clip: rect(1px, 1px, 1px, 1px);
			position: absolute;
		}
	</style>
	<?php
}
endif; // conary_header_style
