<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after
 *
 * 
 * @package Conary
 * @since Conary 1.0
 */
?>

		</div><!-- .site-content -->

		<footer id="colophon" class="site-footer" role="contentinfo">

			<?php get_sidebar('footer'); ?>
			<?php if ( has_nav_menu( 'social' ) && false ) : ?>
				<nav class="social-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Footer Social Links Menu', 'conary' ); ?>">
					<?php
						add_filter( 'walker_nav_menu_start_el', 'conary_social_menu_item_output', 10, 4 );
						wp_nav_menu( array(
							'theme_location' => 'social',
							'menu_class'     => 'social-links-menu',
							'depth'          => 1,
							'link_before'    => conary_svg_icon('icon_replace') . '<span class="screen-reader-text">',
							'link_after'     => '</span>',
						) );
						remove_filter( 'walker_nav_menu_start_el', 'conary_social_menu_item_output' );
					?>
				</nav><!-- .social-navigation -->
			<?php endif; ?>

			<?php if ( has_nav_menu( 'footer-menu' ) ) : ?>
				<nav class="footer-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Footer Menu', 'conary' ); ?>">
					<?php
						wp_nav_menu( array(
							'theme_location' => 'footer-menu',
							'menu_class'     => 'footer-menu',
						 ) );
					?>
				</nav><!-- .main-navigation -->
			<?php endif; ?>

			<div class="site-info">
				<?php
					/**
					 * Fires before the conary footer text for footer customization.
					 *
					 * @since Conary 1.0
					 */
					do_action( 'conary_credits' );

					if ( $footer_credit = get_theme_mod( 'footer_credit', false ) ) {
						echo conary_sanitize_footer_credit( $footer_credit );
					} else {						
						conary_footer_credit(true);
					}
				?>
				
			</div><!-- .site-info -->
		</footer><!-- .site-footer -->
	</div><!-- .site-inner -->
</div><!-- .site -->

<?php wp_footer(); ?>
</body>
</html>
