<?php if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
get_header(); ?>
<section class="singlepage pb-5 pt-5">
	<div class="container">
	<div class="row content-row gx-5">
		<div class="content-area content-has-sidebar float-left col-xl-8 col-lg-8 col-md-12 col-sm-12">
		    <div class="doemaster-breadcrum">
	       <?php  if (function_exists('codemaster_breadcrumbs'))  codemaster_breadcrumbs();  ?>
	        </div>
			<div class="tag-site-content">
				 <?php // echo $key_1_value = get_post_meta( get_the_ID(), 'origin', true ); ?>
				<?php
				$format = get_post_format() ? : 'standard';
				if ( have_posts() && $format) :
					while ( have_posts() ) :
						the_post();
						?>
						<article <?php post_class(); ?>>
						     <div class="border rounded post-thumbnail-responsive">
                			<?php if(has_post_thumbnail()){ the_post_thumbnail( 'codemaster-custom-image-size' ); } else {
                             echo '<img alt="Image not found" src="' . esc_url(get_stylesheet_directory_uri()). '/assets/images/not-found.webp" />';
                            }  ?>
                			</div>
							<header class="entry-header">
								<?php the_title( '<h1 class="entry-title display-7">', '</h1>' ); ?>
							</header>
							<div class="entry-content">
								<?php   echo wp_trim_words(wp_strip_all_tags( get_the_content(), 6, '...' )); // the_content(); ?>
								<div class="readmore mb-3">
								<a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"> Read More</a>
								</div>
							</div>
						</article>
						<?php
					endwhile;
					?>
					<div class="text-center pt-4 pb-2">
						<?php
						 the_posts_pagination( array(
						    'prev_text' => __( 'Prev', 'codemaster' ),
						    'next_text' => __( 'Next', 'codemaster' ),
						) ); ?>
					</div>
					<?php
				else :
					?>
					<article class="no-results">
						<header class="entry-header">
							<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'codemaster' ); ?></h1>
						</header>
						<div class="entry-content">
							<p><?php esc_html_e( 'It looks like nothing was found at this location.', 'codemaster' ); ?></p>
						</div>
					</article>
				<?php
				endif;
				?>
			</div>
	    </div>
		<aside id="secondary" role="complementary" class="sidebar-fixed widget-area widget-has-sidebar sidebar-fixed col-xl-4 col-lg-4 col-md-12 col-sm-12">
		    <div class="sidebar-fixed-inner">
		    <?php get_sidebar(); // has_post_format() ?>
	     	</div>
		</aside>
	</div>
	</div>
</section>
<?php get_footer(); ?>