<?php 
/**
 * The template for displaying the post.
 *
 * @package codemaster
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<?php get_header(); ?>
<section class="singlepage site-content py-3">
	<div class="container">
	<div class="row content-row gx-5">
		<div class="content-area content-has-sidebar float-left col-xl-8 col-lg-8 col-md-12 col-sm-12 mb-4">
		   <div class="doemaster-breadcrum">
	       <?php  if (function_exists('codemaster_breadcrumbs'))  codemaster_breadcrumbs();  ?>
	        </div>
			<main class="site-main">
				<?php
				$format = get_post_format() ? : 'standard';
				if ( have_posts() && is_singular() && $format) :
					while ( have_posts() ) :
						the_post();
						?>
						<article <?php post_class(); ?>>
						    <div class="border rounded post-thumbnail-responsive">
						    <?php if(has_post_thumbnail()){ the_post_thumbnail( 'codemaster-custom-image-size' ); } else {
                                echo '<img width="726" height="398" alt="Image not found" src="' . get_stylesheet_directory_uri(). '/assets/images/not-found.webp" />';
                            }  ?>
						    </div>
						<div class="themework-post-info p-2">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-calendar-check" viewBox="0 0 16 16">
						  <path d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z"/>
						  <path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z"/>
						</svg> <time datetime="<?php echo esc_attr(get_the_date('c')); ?>" itemprop="datePublished"><?php echo get_the_date(); ?></time>
						<?php $categories = get_the_category();
						$separator = ' ';
						$output = '';
						if ( ! empty( $categories ) ) {
						    foreach( $categories as $category ) {
						        $output .= '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bookmarks" viewBox="0 0 16 16">
				  <path d="M2 4a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v11.5a.5.5 0 0 1-.777.416L7 13.101l-4.223 2.815A.5.5 0 0 1 2 15.5V4zm2-1a1 1 0 0 0-1 1v10.566l3.723-2.482a.5.5 0 0 1 .554 0L11 14.566V4a1 1 0 0 0-1-1H4z"/>
				  <path d="M4.268 1H12a1 1 0 0 1 1 1v11.768l.223.148A.5.5 0 0 0 14 13.5V2a2 2 0 0 0-2-2H6a2 2 0 0 0-1.732 1z"/>
				</svg> <a href="' . esc_url( get_category_link( $category->term_id ) ) . '" title="' . esc_attr( sprintf( __( 'View all posts in %s', 'codemaster' ), $category->name ) ) . '">' . esc_html( $category->name ) . '</a>' . $separator;
						    }
						    echo trim( $output, $separator );
						} ?>
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-check" viewBox="0 0 16 16">
						  <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
						  <path fill-rule="evenodd" d="M15.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L12.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z"/>
						</svg> 
					<?php  
				    //	or get_the_author_link();
					$post_id = get_the_ID(); 
					$author_id = get_post_field( 'post_author', $post_id );
					?>
                    <?php 
                        echo '<a class="text-capitalize fs-6" href="' . esc_url( get_author_posts_url( $post->post_author ) ) . '" title="' . esc_attr( sprintf( __( 'View all posts in %s author', 'codemaster' ), get_the_author_meta( 'display_name', $author_id ) ) ) . '">' . esc_html( get_the_author_meta( 'display_name', $author_id ) ) . '</a>';
					?>
					</div>
						<header class="entry-header">
								<?php sanitize_title(the_title( '<h1 class="entry-title display-7 text-capitalize">', '</h1>' )); ?>
						</header>
						<div class="entry-content">
							<?php wp_strip_all_tags(the_content( esc_html__( 'Continue reading &rarr;', 'codemaster' ) )); ?>
							</div>
						 <?php
							wp_link_pages(
								array(
									'before' => '<div class="page-links">' . __( 'Pages:', 'codemaster' ),
									'after'  => '</div>',
								)
							);
						?>
						</article>
						<div class="entry-navigation">
						<?php the_post_navigation(
						array(
							'prev_text' => '<label class="nav-item nav-post-prev">' . esc_html__( 'Previous Post:', 'codemaster' ) . '</label> <span class="nav-item nav-post-next">%title</span>',
							'next_text' => '<label class="nav-item nav-post-prev">' . esc_html__( 'Next Post:', 'codemaster' ) . '</label> <span class="nav-item nav-post-next">%title</span>',
							)
						); ?>
						</div>
						<?php
					endwhile;
				else :
					?>
					<article class="no-results">
						<header class="entry-header">
							<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'codemaster' ); ?></h1>
						</header>
						<div class="entry-content">
							<p><?php esc_html_e( 'It looks like nothing was found at this location.', 'codemaster' ); ?></p>
						</div>
					</article>
				<?php
				endif;
				?>
				<div class="wp-cus-tag mb-3 mt-3">
				    <?php the_tags(); ?>
				</div>
				<hr />
				<div class="codetheme-social-share">
                    Share this article:
                    <ul>
                    <li><a rel="nofollow noopener" target="_blank" title="Share by Facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo get_permalink(); ?>"><i class="icofont-facebook"></i></a></li>
                    <li><a rel="nofollow noopener" target="_blank" title="Share by Twitter" href="https://twitter.com/intent/tweet?text=<?php sanitize_title(the_title()); ?>&amp;url=<?php echo get_permalink(); ?>" <i class="icofont-twitter"></i></a></li>
                    <li><a rel="nofollow noopener" target="_blank" title="Share by Linkedin" href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo get_permalink(); ?>&amp;summary=<?php sanitize_title(the_title()); ?>" <i class="icofont-linkedin"></i></a></li>
                    <li><a rel="nofollow noopener" target="_blank" title="Share by Whatsapp" href="https://api.whatsapp.com/send?text=<?php sanitize_title(the_title()); ?> <?php echo get_permalink(); ?>" <i class="icofont-whatsapp"></i></a></li>
                     <li><a rel="nofollow noopener" target="_blank" title="Share by Email" href="mailto:?subject=<?php sanitize_title(the_title()); ?>&body=Check out this site: <?php echo get_permalink(); ?>"  <i class="icofont-email"></i></a></li>
                      <li><a rel="nofollow noopener" target="_blank" title="Share by Pinterest" href="http://pinterest.com/pin/create/link/?url=<?php echo get_permalink(); ?>&description=<?php sanitize_title(the_title()); ?>" <i class="icofont-pinterest"></i></a></li>
                       <li><a rel="nofollow noopener" target="_blank" title="Share by Telegram" href="https://telegram.me/share/url?url=<?php echo get_permalink(); ?>&text=<?php sanitize_title(the_title()); ?>" <i class="icofont-telegram"></i></a></li>
                    </ul>
                </div>
                <hr />
                <?php if(comments_open()){ ?>
				<div id="comments" class="comment-forms mb-4 mt-4 ranking-c-f comments-area">
				   <h2 class="code-comments-title mb-3 display-8">Join the conversation.</h2>
				 <div class="comment-respond">
				 <?php comment_form(); ?>
				 </div>
				</div>
				<div class="comment-forms-all mb-6 comment-list-wrap">
				<?php // If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
						//	comments_template();
						endif; ?>
					<?php comments_template(); ?>
				</div>
				<?php } ?>
			</main>
	    </div>
		<aside id="secondary" role="complementary" class="widget-area widget-has-sidebar sidebar-codemaster col-xl-4 col-lg-4 col-md-12 col-sm-12 mb-4">
		    <div class="sidebar-fixed-inner sticky-top">
		    <?php get_sidebar(); ?>
	     	</div>
		</aside>
	</div>
	</div>
</section>

<?php
$user_id = '1';
$codemaster_themeopt_relatedpost =  get_user_meta( $user_id, 'codemaster_themeopt_relatedpost', true ); 
if(!empty($codemaster_themeopt_relatedpost) && $codemaster_themeopt_relatedpost == "Yes") {
        $terms = get_the_terms( get_the_ID(), 'category' );
            $term_list = wp_list_pluck( $terms, 'slug' );
            $related_args = array(
            	'post_type' => 'post',
            	'posts_per_page' => 6,
            	'post_status' => 'publish',
            	'post__not_in' => array( get_the_ID() ),
            	'orderby' => 'rand',
            	'tax_query' => array(
            		array(
            			'taxonomy' => 'category',
            			'field' => 'slug',
            			'terms' => $term_list
            		)
            	)
            );
        $relatedCodeMasterPost = new WP_Query( $related_args );
            
        if( $relatedCodeMasterPost->have_posts() ) :
            $i= 1;
?>
<section class="py-5 bg-gray-100"> 
    <div class="container">
        <div class="row mb-4">
          <div class="col-md-8">
            <p class="subtitle text-secondary"><?php echo esc_html_e("Stories from around the globe", 'codemaster'); ?></p>
            <h3><?php echo esc_html_e("Related Articles", 'codemaster'); ?></h3>
          </div>
          <div class="col-md-4 d-md-flex align-items-center justify-content-end"><a class="text-muted text-sm" href="<?php echo esc_url(home_url('blog')); ?>">
               <?php echo esc_html_e("See all articles", 'codemaster'); ?> <i class="icofont-long-arrow-right ms-2"></i></i>
              </a>
        </div>
        </div>
    <div class="row g-0">
    <div id="carouselExampleControls" class="carousel slide" data-bs-ride="carousel">
         <div class="carousel-inner">
        <?php while( $relatedCodeMasterPost->have_posts() ): $relatedCodeMasterPost->the_post(); ?>
          <div class="carousel-item <?php echo ($i == 1) ? "active" : ""; ?>">
          <div class="col-md-4 px-3">
            <div class="card shadow border-0 h-100">
                <a href="<?php the_permalink(); ?>">
                <div class="image-block-inner">
                <?php if(has_post_thumbnail()){ the_post_thumbnail( 'codemaster-post-image-size' ); } else {
                echo '<img alt="Image not found" src="' . get_stylesheet_directory_uri(). '/assets/images/not-found.png" />';
                } ?>
                </div>
                </a>
            <div class="card-body">
                <h5 class="my-2 text-captilize"><a class="text-dark"  href="<?php the_permalink() ?>" rel="bookmark" title="<?php sanitize_title(the_title()); ?>"><?php sanitize_title(the_title()); ?></a></h5>
                <p class="text-gray-500 text-sm my-3"><i class="icofont-clock-time me-2"></i><?php echo get_the_date(); ?></p>
                <p class="my-2 text-muted text-sm"><?php echo wp_trim_words( get_the_content(), 15, '...' ); ?></p><a class="btn-link ps-0" href="<?php the_permalink(); ?>" title="Permanent Link to <?php the_title_attribute(); ?>">Read more<i class="icofont-arrow-right"></i></a>
            </div>
            </div>
          </div>
          </div>
          <?php $i++; endwhile; ?>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
              </button>
            </div>
        </div>
      </div>
</section>
<?php 
endif;
wp_reset_postdata();
} 
get_footer(); ?>