<?php
/**
 * Template for displaying search forms
 *
 * @package  codemaster
 * @since    1.0
 */
 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label class="form-label">
		<span class="screen-reader-text"  for='s'><?php echo esc_html_x( 'Search for:', 'label', 'codemaster' ); ?></span>
		<input type="search" class="form-control"
		       placeholder="<?php echo esc_attr_x( 'Search&hellip;', 'placeholder', 'codemaster' ); ?>"
		       value="<?php echo get_search_query() ?>" name="s"
		       title="<?php echo esc_attr_x( 'Search for:', 'label', 'codemaster' ); ?>"/>
	</label>
	<button type="submit" class="btn btn-primary">
		<span class="search-btn-text">
			<?php echo _x( 'Search', 'submit button', 'codemaster' ); ?>
		</span>
	</button>
</form>
