<?php if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
get_header(); ?>
<section class="searchpage pb-5 pt-5">
  <div class="site-content container">
	  <header class="page-header">
		  <h1 class="page-title display-4">
			  <?php
				  /* translators: %s: the search query */
			printf( esc_html__( 'Search Results for: %s', 'codemaster' ), '<span>' . get_search_query() . '</span>' );
			  ?>
		  </h1>
	  </header><!-- .page-header -->
	  <hr>
	    <?php
	    if ( have_posts() ) :
	      while ( have_posts() ) :
	        the_post();
	        ?>
	        <article <?php post_class(); ?>>
	          <header class="entry-header pt-2">
	           <a href="<?php the_permalink(); ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>">
	                <?php the_title( '<h3 class="entry-title display-6">', '</h3>' ); ?>
	           </a>
	          </header><!-- .entry-header -->
	          <div class="entry-content">
	            <?php echo wp_trim_words( sanitize_text_field(get_the_content(), 800, '...' )); ?>
	          </div><!-- .entry-content -->
	        </article><!-- #post-## -->
	        <?php
	      endwhile;
		 //  the_posts_navigation();
		  ?>
		  <div class="text-center pt-4 pb-2">
            <div class="pagination ranking-pg">
        	<?php
        	 the_posts_pagination( array(
        	    'prev_text' => __( 'Prev', 'codemaster' ),
        	    'next_text' => __( 'Next', 'codemaster' ),
        	) ); ?>
          </div>
        </div>
		 <?php
	    else :
	       get_template_part( 'template-parts/content-none' );
	       get_search_form();
	    endif;
		?>
	</div><!-- .site-content -->
</section>
<?php get_footer();