<?php
// create custom theme option settings menu
add_action('admin_menu', 'codemaster_theme_option');
if ( ! function_exists( 'codemaster_theme_option' ) &&  is_admin() ) :
function codemaster_theme_option() {
    
	//create new top-level menu
	add_menu_page('CodeMaster Theme Settings', 'Theme Settings', 'manage_options', 'codemaster_theme_settings', 'codemaster_theme_option_settings_page');

	//call register settings function
	add_action( 'admin_init', 'codemaster_theme_option_settings' );
}
endif; 
if ( ! function_exists( 'codemaster_theme_option_settings' ) &&  is_admin() ) :
function codemaster_theme_option_settings() {
        ob_start();
        if (isset($_POST['submit']) && sanitize_text_field($_POST['submit']) == 'Save Changes'){
        $user_id = '1';
        $user_data = get_userdata( $user_id );
        if ( $user_data === false && empty( $user_data )) {
             _e( '<div class="notice notice-warning"><h4><strong>Warning:</strong> Something Wrong! Please contact to CodeMaster theme developer.</h4></div>', 'codemaster' );
                //user id does not exist
        } else {
          $facebook = sanitize_text_field($_POST['facebook']);
          $twitter = sanitize_text_field($_POST['twitter']);
          $instagram = sanitize_text_field($_POST['instagram']);
          $linkedin = sanitize_text_field($_POST['linkedin']);
          $youtube = sanitize_text_field($_POST['youtube']);
          $pinterest = sanitize_text_field($_POST['pinterest']);
        update_user_meta( $user_id, 'codemaster_themeopt_facebook', $facebook );
        update_user_meta( $user_id, 'codemaster_themeopt_twitter', $twitter );
        update_user_meta( $user_id, 'codemaster_themeopt_instagram',$instagram );
        update_user_meta( $user_id, 'codemaster_themeopt_linkedin', $linkedin );
        update_user_meta( $user_id, 'codemaster_themeopt_pinterest', $pinterest );
        update_user_meta( $user_id, 'codemaster_themeopt_youtube', $youtube );
        
        if (empty($_POST['relatedpost'])){
           update_user_meta( $user_id, 'codemaster_themeopt_relatedpost', 'No' );
        } else if (isset($_POST['relatedpost']) && !empty($_POST['relatedpost']) && $_POST['relatedpost'] == "Yes"){
            $relatedpost = sanitize_text_field($_POST['relatedpost']);
            update_user_meta( $user_id, 'codemaster_themeopt_relatedpost', $relatedpost );
        } 
        if (empty($_POST['searchbutton'])){
           update_user_meta( $user_id, 'codemaster_themeopt_searchbutton', 'No' );
        } else if (isset($_POST['searchbutton']) && !empty($_POST['searchbutton']) && $_POST['searchbutton'] == "Yes") {
            $searchbutton = sanitize_text_field($_POST['searchbutton']);
            update_user_meta( $user_id, 'codemaster_themeopt_searchbutton', $searchbutton );
        }
         if (empty($_POST['blogpattern'])){
           update_user_meta( $user_id, 'codemaster_themeopt_blogpattern', 'No' );
        } else if (isset($_POST['blogpattern']) && !empty($_POST['blogpattern']) && $_POST['blogpattern'] == "Yes") {
            $blogpattern = sanitize_text_field($_POST['blogpattern']);
            update_user_meta( $user_id, 'codemaster_themeopt_blogpattern', $blogpattern );
        }
        _e( '<div class="notice notice-info">
		<p><strong>Success:</strong> Theme setting updated successfully!</p>
	    </div>', 'codemaster');
        }
    }
}
endif;
function codemaster_theme_option_settings_page() {
?>
<style>
.codemasteroption {
    background: #eee3ff;
    font-size: 18px;
    color: #000;
    font-weight: 500;
}
.codemasteroption .inputblock {
  width: 100%;
  padding: 10px;
  border: 1px solid #ccc;
  border-radius: 4px;
  box-sizing: border-box;
  margin-top: 6px;
  margin-bottom: 16px;
  resize: vertical;
}
.codemasteroption .switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}
.codemasteroption .switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.codemasteroption .slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}
.codemasteroption .slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

.codemasteroption input:checked + .slider {
  background-color: #2196F3;
}

.codemasteroption input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

.codemasteroption input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.codemasteroption .slider.round {
  border-radius: 34px;
}
.themecontainer legend {
    float: none;
    width: auto;
    padding: 0px 20px;
    margin-top: 10px;
}
.checkboxlay {
    margin-bottom: 20px;
}
.codemasteroption .slider.round:before {
  border-radius: 50%;
}
.themecontainer {
  border-radius: 5px;
  padding: 20px;
}
.themecontainer fieldset {
    border: 2px solid #000;
    padding: 20px;
    margin-bottom: 20px;
}
.infobox {
    background: #d1ffd1;
    padding: 12px 20px;
    box-shadow: 8px 10px rgb(40 255 40 / 60%);
    font-size: 16px;
    margin-bottom: 25px;
}
.blogpatterimg img:hover{
    transform: scale(15);
    transition: all 0.5s;
    border-radius: 2px;
    cursor:pointer;
}
</style>
<div class="wrap">
<h2><?php echo esc_html_e("Code Master Theme Setting", 'codemaster'); ?> <img  alt="yes" src="<?php echo esc_url(get_stylesheet_directory_uri()) ?>/assets/images/yes-icon.png" /></h2>
<hr>
<?php  if ( is_plugin_active( 'ops-robots-txt/ops.php' )){ } else {?>
<div class="infobox">
 <h4><?php echo esc_html_e("Download Best recommended On Page SEO Plugin (Whatsapp Chat Button) formaly OPS Develop by theme developer", 'codemaster'); ?>
 <a class="btn-link ps-0" target="_blank" href="<?php echo esc_url('https://wordpress.org/plugins/ops-robots-txt/'); ?>"><?php echo esc_html_e("Download Plugin", 'codemaster'); ?></a></h4>
 <details>
    <summary><?php echo esc_html_e("About OPS Plugin", 'codemaster'); ?> </summary>
   <?php echo esc_html_e("On-Page SEO plugin is WordPress optimization for Website traffic, Crawler, SEO & ranking. On-page SEO main purpose is to higher search rankings & increased traffic to your website and optimize robots.txt file and  add whatsapp chat button.", 'codemaster'); ?> 
</details>
</div>
<?php } ?>

<?php $checked = 'checked';
    settings_fields( 'theme-option-group' ); ?>
    <?php do_settings_sections( 'theme-option-group' ); ?>
    <section class="theme-section-one codemasteroption">
    <div class="themecontainer">
       <form method="post">
       <fieldset>
          <legend>Social Page Link:</legend>  
            <div class="alert alert-success alert-dismissible fade show p-1" role="alert"><small><?php echo esc_html_e("Note: If you empty any social link box that will not show and other will show.", 'codemaster'); ?></small> </div>
            <label for="fname">Facebook</label>
            <input type="url" class="inputblock" name="facebook" placeholder="Facebook link" value="<?php echo esc_attr( get_user_meta( '1', 'codemaster_themeopt_facebook', true ) ); ?>" />
        
            <label for="tname">Twitter</label>
            <input type="url" class="inputblock" name="twitter" placeholder="Twitter link" value="<?php echo esc_attr( get_user_meta( '1', 'codemaster_themeopt_twitter', true ) ); ?>" />
            
            <label for="iname">Instagram</label>
            <input type="url" class="inputblock" name="instagram" placeholder="Instagram link" value="<?php echo esc_attr( get_user_meta( '1', 'codemaster_themeopt_instagram', true ) ); ?>" />
            
             <label for="lname">Linkedin</label>
            <input type="url" class="inputblock" name="linkedin" placeholder="Linkedin link" value="<?php echo esc_attr( get_user_meta( '1', 'codemaster_themeopt_linkedin', true ) ); ?>" />
             <label for="pname">Pinterest</label>
            <input type="url" class="inputblock" name="pinterest" placeholder="Pinterest link" value="<?php echo esc_attr( get_user_meta( '1', 'codemaster_themeopt_pinterest', true ) ); ?>" />
            
            <label for="yname">Youtube</label>
            <input type="url" class="inputblock" name="youtube" placeholder="Youtube link" value="<?php echo esc_attr( get_user_meta( '1', 'codemaster_themeopt_youtube', true ) ); ?>" />
            
        </fieldset>
         <fieldset>
          <legend>Theme Setting:</legend>  
          <div class="checkboxlay">
          <span>Related Articles - </span> 
            <?php  $codemaster_themeopt_relatedpost =  get_user_meta( '1', 'codemaster_themeopt_relatedpost', true ); ?>
            <label class="switch" title="Active to show | Deactivate to hide">
                <input type="checkbox" name="relatedpost" value="Yes" <?php echo ( ($codemaster_themeopt_relatedpost == "Yes") ? $checked : null ); ?> >
              <span class="slider"></span>
            </label> 
            </div>
            <div class="checkboxlay">
                <span>Search Button - </span>
                <?php  $codemaster_themeopt_searchbutton =  get_user_meta( '1', 'codemaster_themeopt_searchbutton', true ); ?>
                <label class="switch" title="Active to show | Deactivate to hide">
                  <input type="checkbox" name="searchbutton" value="Yes" <?php echo ( ($codemaster_themeopt_searchbutton == "Yes") ? $checked : null ); ?>>
                  <span class="slider"></span>
                </label> 
            </div>
             <div class="checkboxlay">
                <span>Blog Post Design - </span>
                <?php $codemaster_themeopt_blogpattern =  get_user_meta( '1', 'codemaster_themeopt_blogpattern', true ); ?>
                <label class="switch" title="Active to show 1 colum first blog rest 3 column | Deactivate to show 3 column">
                  <input type="checkbox" name="blogpattern" value="Yes" <?php echo ( ($codemaster_themeopt_blogpattern == "Yes") ? $checked : null ); ?>>
                  <span class="slider"></span>
                </label> Note: | <span class="blogpatterimg">Active - Blog column design <img  alt="yes" width=30" height="30" src="<?php echo esc_url(get_stylesheet_directory_uri()) ?>/assets/images/blogpattern1.png" /> | Deactivate - Blog column design <img width=30" height="30" alt="no" src="<?php echo esc_url(get_stylesheet_directory_uri()) ?>/assets/images/blogpattern2.png" /> </span>
            </div>
        </fieldset>
         <?php submit_button(); ?>
      </form>
    </div>
    </section>
</div>
<?php } 