<?php 
/**
 * Breadcrumbs Code for codemaster theme
 * @package CodeMaster
*/

if (!function_exists('codemaster_breadcrumbs')) :
function codemaster_breadcrumbs() {
    // Return if breadcrumbs are disabled.
	if ( is_front_page() ) {
		return;
	}
	
	// Yoast breadcrumbs.
	if ( function_exists( 'yoast_breadcrumb' )
		&& true === WPSEO_Options::get( 'breadcrumbs-enable', false ) ) {
		$classes = 'site-breadcrumbs text-white';
		return yoast_breadcrumb( '<nav class="' . $classes . '">', '</nav>' );
	}

	// SEOPress breadcrumbs.
	if ( function_exists( 'seopress_display_breadcrumbs' ) ) {
		return seopress_display_breadcrumbs();
	}

	// Rank Math breadcrumbs.
	if ( function_exists( 'rank_math_the_breadcrumbs' ) && RankMath\Helper::get_settings( 'general.breadcrumbs' ) ) {
		return rank_math_the_breadcrumbs();
	}
	
	global $post;
    echo '<nav class="mb-2" aria-label="breadcrumb"> 
    <ol class="breadcrumb">';
    if (!is_home()) {
        echo '<li class="breadcrumb-item"><i class="icofont-home"></i>
        <a  href="';
        echo  esc_url(home_url());
        echo '">';
        echo '<span >Home</span>';
        echo '';
        echo '</a></li>';
        if (is_category() || is_single()) {
            echo '<li  class="breadcrumb-item"><span>';
            the_category('</span></li><li  class="breadcrumb-item">');
            if (is_single()) {
                echo ' </li><li class="breadcrumb-item active" aria-current="page"><span>';
                the_title();
                echo '</span></li>';
            }
        } elseif (is_page()) {
            if($post->post_parent){
                $anc = get_post_ancestors( $post->ID );
                $title = get_the_title();
                foreach ( $anc as $ancestor ) {
                    $output = '<li  class="breadcrumb-item"><a href="'.get_permalink($ancestor).'" title="'.get_the_title($ancestor).'"><span>'.get_the_title($ancestor).'</span></a></li>';
                }
                echo $output;
                echo '<li class="breadcrumb-item active" aria-current="page"><span> '.$title.'</span></li>';
            } else {
                echo '<li class="breadcrumb-item active" aria-current="page"><span>'.get_the_title().'</span></li>';
            }
        }
    }
    elseif (is_tag()) {single_tag_title();}
    elseif (is_day()) {echo"<li class='breadcrumb-item active'><span>Archive for "; get_option( 'date_format' ); echo'</span></li>';}
    elseif (is_month()) {echo"<li class='breadcrumb-item active'><span>Archive for "; get_option( 'date_format' ); echo'</span></li>';}
    elseif (is_year()) {echo"<li class='breadcrumb-item active'><span>Archive for "; get_option( 'date_format' ); echo'</span></li>';}
    elseif (is_author()) {echo"<li class='breadcrumb-item active'><span>Author Archive"; echo'</span></li>';}
    elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "<li class='breadcrumb-item active'><span>Blog Archives"; echo'</span></li>';}
    elseif (is_search()) {echo"<li class='breadcrumb-item active'><span >Search Results"; echo'</span></li>';}
    echo '</ol></nav>';
}
endif;
