<?php
/**
 * The template for displaying the header.
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 * @package WordPress
 * @subpackage codemaster
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
// get search buuton value for enable or not
$user_id = '1';
$codemaster_themeopt_searchbutton =  get_user_meta( $user_id, 'codemaster_themeopt_searchbutton', true ); 
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> itemtype="http://schema.org/WebSite" itemscope>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="profile" href="https://gmpg.org/xfn/11">
        <meta name="theme-color" content="#7952b3">
        <?php if(is_singular() && pings_open( get_queried_object() )): ?>
            <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
        <?php endif; ?>
        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
        <header class="mainheader themeworkheader" role="banner" itemscope="" itemtype="https://schema.org/WPHeader">
            <a class="skip-link screen-reader-text" href="#primary">
                <?php _e( 'Skip to content', 'codemaster' ); ?>
            </a>
           <nav class="navbar navbar-expand-lg navbar-light" role="navigation" itemscope="" itemtype="http://schema.org/SiteNavigationElement">
              <div class="container">
                <span class="navbar-brand site-branding" itemscope="itemscope" itemtype="https://schema.org/Organization" > 
                <?php if( get_custom_logo() ) {
                    if ( function_exists( 'the_custom_logo' ) ) {
                        the_custom_logo();
                    }
                } else {  ?> <a class="navbar-brand text-capitalize" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a> 
                    <span class="d-none d-sm-block'">
                     <?php } 
                     
                     // Display Site Title and Tagline in Header 
                     if (display_header_text()==true){
                         $bloginfoName = get_bloginfo( 'name' ); 
                         $bloginfoDescription = wp_trim_words(get_bloginfo( 'description' ), 10);
                         ?>
                        <strong><?php printf(
                        __( '%s', 'codemaster' ),
                        $bloginfoName);  ?></strong>
                        <h5><?php printf(
                        __( '%s', 'codemaster' ),
                        $bloginfoDescription);  ?></h5>
                   <?php } ?>
                   </span>
                </span>
                <button class="navbar-toggler second-button" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle navigation', 'codemaster' ) ?>">
                  <!--<span class="navbar-toggler-icon"></span>-->
                  <div class="animated-icon2"><span></span><span></span><span></span><span></span></div>
                </button> <!-- .search-toggle -->
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav mb-lg-0 primary-menu nav">
                        <?php
                        if ( has_nav_menu( 'primary' ) ) {
                                wp_nav_menu(
                                    array(
                                        'container'  => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' =>'primary',
                                    )
                                );
        
                        } else if ( ! has_nav_menu( 'primary' ) ) {
                            
    						wp_list_pages(
    							array(
    							    'match_menu_classes' => true,
    								'show_sub_menu_icons' => true,
    								'title_li' => false,
    							)
    						);
					    } ?>
                        <?php if(!empty($codemaster_themeopt_searchbutton) && $codemaster_themeopt_searchbutton == "Yes") { ?>
                            <li class="menu-item searchbox"> <!-- Search Button -->
                                <button class="btn openBtn nav-link" onclick="openSearch()"><i class="icofont-search"></i>
                                </button>
                           </li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </nav>
    </header>
<main role="main" id="primary">